/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.entities.ai;

import com.google.common.collect.Lists;
import com.legacy.blue_skies.registries.SkiesVillagers;
import com.legacy.blue_skies.util.EntityUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class NightwatcherRobGoal
extends Goal {
    private final Villager villager;
    private final double speed;
    private Villager targetVillager;
    private int taskID = 0;
    private Vec3 awayVec = null;
    private List<UUID> robbedVilagers = Lists.newArrayList();
    private int robbingDelay = 0;

    public NightwatcherRobGoal(Villager creatureIn, double speedIn) {
        this.speed = speedIn;
        this.villager = creatureIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public void m_8056_() {
        Villager target;
        AABB radiusCheck = new AABB(this.villager.m_142538_()).m_82377_(35.0, 5.0, 35.0);
        List entityList = this.villager.f_19853_.m_6249_((Entity)this.villager, radiusCheck, entity -> entity instanceof Villager && ((Villager)entity).m_5803_());
        if (!entityList.isEmpty() && this.robbingDelay <= 0 && !this.robbedVilagers.contains((target = (Villager)entityList.get(this.villager.f_19853_.f_46441_.nextInt(entityList.size()))).m_142081_())) {
            this.targetVillager = target;
        }
    }

    public void m_8037_() {
        if (this.robbingDelay > 0) {
            --this.robbingDelay;
        }
        if (this.villager.f_19853_.m_46461_() && !this.robbedVilagers.isEmpty()) {
            this.robbedVilagers.clear();
        }
        if (this.targetVillager != null && !this.targetVillager.m_6084_()) {
            this.targetVillager = null;
            this.awayVec = null;
            this.taskID = 0;
        }
        if (this.targetVillager != null && this.targetVillager.m_5803_()) {
            if (this.taskID <= 0) {
                double distance = EntityUtil.getDistanceToPos((Vec3i)this.villager.m_142538_(), (Vec3i)this.targetVillager.m_142538_());
                if (distance < 1.0) {
                    this.robbedVilagers.add(this.targetVillager.m_142081_());
                    this.villager.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
                    this.taskID = 1;
                }
                if (this.taskID <= 0) {
                    if (distance < 3.0) {
                        this.villager.m_21566_().m_6849_(this.targetVillager.m_20185_(), this.targetVillager.m_20186_(), this.targetVillager.m_20189_(), this.speed);
                    } else {
                        this.villager.m_21573_().m_5624_((Entity)this.targetVillager, this.speed);
                    }
                    this.villager.m_21563_().m_24960_((Entity)this.targetVillager, 40.0f, 40.0f);
                }
            } else if (this.taskID == 1) {
                if (this.awayVec == null) {
                    Optional jobSite = this.villager.m_6274_().m_21952_(MemoryModuleType.f_26360_);
                    this.awayVec = jobSite != null && jobSite.isPresent() ? Vec3.m_82512_((Vec3i)((GlobalPos)jobSite.get()).m_122646_()) : LandRandomPos.m_148521_((PathfinderMob)this.villager, (int)20, (int)7, (Vec3)this.targetVillager.m_20182_());
                } else {
                    BlockPos blockPos = new BlockPos(this.awayVec);
                    if (EntityUtil.getDistanceToPos((Vec3i)this.villager.m_142538_(), (Vec3i)blockPos) > 1.0f) {
                        this.villager.m_21573_().m_26519_(this.awayVec.f_82479_, this.awayVec.f_82480_, this.awayVec.f_82481_, (double)0.7f);
                    } else {
                        this.targetVillager = null;
                        this.awayVec = null;
                        this.taskID = 0;
                    }
                }
            }
        }
    }

    public boolean m_8036_() {
        if (this.villager.m_7141_().m_35571_() != SkiesVillagers.NIGHTWATCHER) {
            return false;
        }
        return EntityUtil.isVillagerWorkTime(this.villager);
    }

    public boolean m_8045_() {
        return this.targetVillager != null && this.taskID < 2 && EntityUtil.isVillagerWorkTime(this.villager) && this.villager.m_7141_().m_35571_() == SkiesVillagers.NIGHTWATCHER && super.m_8045_();
    }

    public boolean m_183429_() {
        return true;
    }
}

