/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.commands;

import com.legacy.blue_skies.BlueSkies;
import com.legacy.blue_skies.capability.SkiesPlayer;
import com.legacy.blue_skies.network.PacketHandler;
import com.legacy.blue_skies.network.s_to_c.UpdateSupportersPacket;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;

public class BlueSkiesCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = Commands.m_82127_((String)"blue_skies");
        command.then(((LiteralArgumentBuilder)Commands.m_82127_((String)"refresh_supporters").requires(source -> source.m_6761_(2))).executes(BlueSkiesCommand::refreshSupporters));
        LiteralArgumentBuilder setProgression = (LiteralArgumentBuilder)Commands.m_82127_((String)"set_progression").requires(source -> source.m_6761_(2));
        setProgression.then(Commands.m_82127_((String)"everbright").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(context -> BlueSkiesCommand.setProgression((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), true))));
        setProgression.then(Commands.m_82127_((String)"everdawn").then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)0, (int)4)).executes(context -> BlueSkiesCommand.setProgression((CommandContext<CommandSourceStack>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"level"), false))));
        command.then((ArgumentBuilder)setProgression);
        LiteralArgumentBuilder setWeather = (LiteralArgumentBuilder)Commands.m_82127_((String)"weather").requires(source -> source.m_6761_(2));
        setWeather.then(Commands.m_82127_((String)"clear").executes(context -> dispatcher.execute("execute in minecraft:overworld run weather clear", (Object)((CommandSourceStack)context.getSource()))));
        setWeather.then(Commands.m_82127_((String)"rain").executes(context -> dispatcher.execute("execute in minecraft:overworld run weather rain", (Object)((CommandSourceStack)context.getSource()))));
        setWeather.then(Commands.m_82127_((String)"thunder").executes(context -> dispatcher.execute("execute in minecraft:overworld run weather thunder", (Object)((CommandSourceStack)context.getSource()))));
        command.then((ArgumentBuilder)setWeather);
        LiteralArgumentBuilder setLoreStatus = (LiteralArgumentBuilder)Commands.m_82127_((String)"set_lore_used").requires(source -> source.m_6761_(2));
        setLoreStatus.then(Commands.m_82129_((String)"used", (ArgumentType)BoolArgumentType.bool()).executes(context -> BlueSkiesCommand.setLoreStatus((CommandContext<CommandSourceStack>)context, BoolArgumentType.getBool((CommandContext)context, (String)"used"))));
        command.then((ArgumentBuilder)setLoreStatus);
        LiteralArgumentBuilder getMobCaps = (LiteralArgumentBuilder)Commands.m_82127_((String)"get_mob_caps").requires(source -> source.m_6761_(2));
        getMobCaps.executes(context -> BlueSkiesCommand.getMobCaps((CommandContext<CommandSourceStack>)context));
        command.then((ArgumentBuilder)getMobCaps);
        dispatcher.register(command);
    }

    private static int refreshSupporters(CommandContext<CommandSourceStack> context) {
        try {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Updating supporters list. This may take a moment to complete."), true);
            BlueSkies.ML_SUPPORTER.refresh();
            for (ServerLevel world : ((CommandSourceStack)context.getSource()).m_81377_().m_129785_()) {
                PacketHandler.sendToAllClients(new UpdateSupportersPacket(), (Level)world);
            }
            return 1;
        }
        catch (Throwable e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent("Failed to update the supporters list."));
            BlueSkies.LOGGER.error((Object)e);
            return 0;
        }
    }

    private static int setProgression(CommandContext<CommandSourceStack> context, int level, boolean isBright) {
        try {
            return SkiesPlayer.getIfPresent(((CommandSourceStack)context.getSource()).m_81375_(), player -> {
                try {
                    if (isBright) {
                        player.setBrightProgression((byte)level);
                    } else {
                        player.setDawnProgression((byte)level);
                    }
                    player.syncDataToClient();
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Updated progression for " + ((CommandSourceStack)context.getSource()).m_81375_().m_7755_().getString()), true);
                    return 1;
                }
                catch (CommandSyntaxException e) {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("That command needs to be run by a player."), true);
                    return 0;
                }
            }, () -> 0);
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("That command needs to be run by a player."), true);
            return 0;
        }
    }

    private static int setLoreStatus(CommandContext<CommandSourceStack> context, boolean usedLore) {
        try {
            return SkiesPlayer.getIfPresent(((CommandSourceStack)context.getSource()).m_81375_(), player -> {
                try {
                    player.setUsedBlueLore(usedLore);
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Updated lore status for " + ((CommandSourceStack)context.getSource()).m_81375_().m_7755_().getString()), true);
                    return 1;
                }
                catch (CommandSyntaxException e) {
                    ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("That command needs to be run by a player."), true);
                    return 0;
                }
            }, () -> 0);
        }
        catch (CommandSyntaxException e) {
            ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("That command needs to be run by a player."), true);
            return 0;
        }
    }

    private static int getMobCaps(CommandContext<CommandSourceStack> context) {
        try {
            NaturalSpawner.SpawnState manager = ((CommandSourceStack)context.getSource()).m_81372_().m_7726_().m_8485_();
            for (MobCategory classification : MobCategory.values()) {
                int spawnableChunkCount = manager.m_47126_();
                int cap = classification.m_21608_() * spawnableChunkCount / (int)Math.pow(17.0, 2.0);
                int count = manager.m_47148_().getInt((Object)classification);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent(String.format("%s %d / %d", classification.m_21607_(), count, cap)), true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }
}

