/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.particle;

import com.legacy.blue_skies.client.particle.CrusherDustParticle;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DustParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;

    protected DustParticle(ClientLevel world, double x, double y, double z, double dx, double dy, double dz, SpriteSet spriteSet) {
        super(world, x, y, z, dx, dy, dz);
        this.spriteSet = spriteSet;
        this.f_107215_ *= (double)this.getBaseVelocityMultiplier();
        this.f_107216_ *= 0.1;
        this.f_107217_ *= (double)this.getBaseVelocityMultiplier();
        this.f_107212_ += (double)(this.f_107223_.nextFloat() - this.f_107223_.nextFloat()) * 0.05;
        this.f_107213_ += (double)(this.f_107223_.nextFloat() - this.f_107223_.nextFloat()) * 0.05;
        this.f_107214_ += (double)(this.f_107223_.nextFloat() - this.f_107223_.nextFloat()) * 0.05;
        this.f_107663_ = (this.f_107223_.nextFloat() + 0.5f) * 0.5f;
        this.m_108335_(spriteSet);
    }

    public float getBaseVelocityMultiplier() {
        return 15.0f;
    }

    public float getTickVelocityMultiplier() {
        return 0.7f;
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        if (this.f_107230_ >= 0.0f) {
            super.m_5744_(buffer, renderInfo, partialTicks);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107230_ <= 0.0f) {
            this.m_107274_();
        } else {
            this.m_108339_(this.spriteSet);
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            float multiplier = this.getTickVelocityMultiplier();
            this.f_107215_ *= (double)multiplier;
            this.f_107217_ *= (double)multiplier;
            this.f_107216_ *= (double)0.95f;
            if (this.f_107230_ >= 0.0f) {
                this.f_107230_ -= 0.01f;
                this.f_107230_ *= 0.96f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Factory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public DustParticle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (type.getRegistryName().equals((Object)SkiesParticles.CRUSHER_DUST.getRegistryName())) {
                return new CrusherDustParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
            }
            return new DustParticle(world, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet);
        }
    }
}

