/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.passive;

import com.legacy.blue_skies.client.SkiesClientUtil;
import com.legacy.blue_skies.entities.passive.CrogreEntity;
import java.util.List;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class CrogreModel<T extends CrogreEntity>
extends AgeableListModel<T> {
    protected final ModelPart head;
    protected final ModelPart rightEye;
    protected final ModelPart leftEye;
    protected final ModelPart body;
    protected final ModelPart rightFrontLeg;
    protected final ModelPart leftFrontLeg;
    protected final ModelPart rightHindLeg;
    protected final ModelPart rightFoot;
    protected final ModelPart leftHindLeg;
    protected final ModelPart leftFoot;

    public CrogreModel(ModelPart model) {
        super(true, 10.0f, 3.35f);
        this.head = model.m_171324_("head");
        this.rightEye = this.head.m_171324_("right_eye");
        this.leftEye = this.head.m_171324_("left_eye");
        this.body = model.m_171324_("body");
        this.rightFrontLeg = model.m_171324_("right_front_leg");
        this.leftFrontLeg = model.m_171324_("left_front_leg");
        this.rightHindLeg = model.m_171324_("right_hind_leg");
        this.rightFoot = this.rightHindLeg.m_171324_("right_foot");
        this.leftHindLeg = model.m_171324_("left_hind_leg");
        this.leftFoot = this.leftHindLeg.m_171324_("left_foot");
    }

    public static LayerDefinition createBodyLayer(CubeDeformation size) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-6.0f, -4.0f, -6.95f, 12.0f, 7.0f, 7.0f), PartPose.m_171419_((float)0.0f, (float)19.0f, (float)-10.25f));
        head.m_171599_("right_eye", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171480_().m_171481_(-4.0f, -6.0f, -7.45f, 3.0f, 2.0f, 3.0f), PartPose.m_171419_((float)-2.0f, (float)0.0f, (float)4.5f));
        head.m_171599_("left_eye", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171481_(1.0f, -5.96f, -7.45f, 3.0f, 2.0f, 3.0f), PartPose.m_171419_((float)2.0f, (float)0.0f, (float)4.5f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-9.0f, -8.0f, -14.0f, 18.0f, 8.0f, 20.0f, size), PartPose.m_171423_((float)0.0f, (float)24.0f, (float)3.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171481_(-2.5f, -2.0f, -2.5f, 5.0f, 8.0f, 5.0f), PartPose.m_171419_((float)9.5f, (float)18.0f, (float)-7.5f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(0, 50).m_171480_().m_171481_(-2.5f, -2.0f, -2.5f, 5.0f, 8.0f, 5.0f), PartPose.m_171419_((float)-9.5f, (float)18.0f, (float)-7.5f));
        PartDefinition rightHindLeg = root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171480_().m_171481_(-3.5f, -4.4957f, -4.8497f, 5.0f, 7.0f, 8.0f), PartPose.m_171423_((float)-8.5f, (float)19.0f, (float)7.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        rightHindLeg.m_171599_("right_foot", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171480_().m_171481_(-3.0f, -0.2651f, -11.8006f, 5.0f, 2.0f, 12.0f), PartPose.m_171423_((float)-0.5f, (float)2.8f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftHindLeg = root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171481_(-1.5f, -4.4957f, -4.8497f, 5.0f, 7.0f, 8.0f), PartPose.m_171423_((float)8.5f, (float)19.0f, (float)7.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        leftHindLeg.m_171599_("left_foot", CubeListBuilder.m_171558_().m_171514_(0, 29).m_171481_(-2.0f, -0.2651f, -11.8006f, 5.0f, 2.0f, 12.0f), PartPose.m_171423_((float)0.5f, (float)2.8f, (float)3.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)96, (int)96);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body, this.rightFrontLeg, this.leftFrontLeg, this.leftHindLeg, this.rightHindLeg);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks - (float)((CrogreEntity)((Object)entityIn)).f_19797_;
        float jumpScale = ((CrogreEntity)((Object)entityIn)).getJumpingAnimationScale(f);
        jumpScale *= jumpScale;
        float swimScale = ((CrogreEntity)((Object)entityIn)).getSwimmingAnimationScale(f);
        swimScale *= swimScale;
        this.setRotationAngle(this.body, -0.0873f, 0.0f, 0.0f);
        this.setRotationAngle(this.rightHindLeg, -0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.rightFoot, 0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.leftHindLeg, -0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.leftFoot, 0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.leftFrontLeg, 0.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.rightFrontLeg, 0.0f, 0.0f, 0.0f);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = SkiesClientUtil.lockNum(netHeadYaw * ((float)Math.PI / 180), 0.45f);
        if (entityIn.m_20072_()) {
            this.leftFrontLeg.f_104205_ = 1.6f;
            this.rightFrontLeg.f_104205_ = -1.6f;
            this.leftFrontLeg.f_104203_ = -0.9f + 0.9f * swimScale;
            this.rightFrontLeg.f_104203_ = -0.9f + 0.9f * swimScale;
            this.rightHindLeg.f_104203_ = 1.0f + 0.9f * swimScale;
            this.leftHindLeg.f_104203_ = 1.0f + 0.9f * swimScale;
        } else {
            this.rightHindLeg.f_104203_ += 0.8f * jumpScale;
            this.leftHindLeg.f_104203_ += 0.8f * jumpScale;
            this.leftFrontLeg.f_104203_ += -(0.8f * jumpScale);
            this.rightFrontLeg.f_104203_ += -(0.8f * jumpScale);
        }
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

