/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.client.models.entities.hostile;

import com.legacy.blue_skies.client.SkiesClientUtil;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class StoneletModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private final ModelPart body;
    private final ModelPart lowerBody;
    private final ModelPart rightLeg;
    private final ModelPart rightLegLayer;
    private final ModelPart leftLeg;
    private final ModelPart leftLegLayer;
    private final ModelPart lowerBodyLayer;
    private final ModelPart head;
    private final ModelPart headLayer;
    private final ModelPart rightArm;
    private final ModelPart rightArmLayer;
    private final ModelPart leftArm;
    private final ModelPart leftArmLayer;
    private final ModelPart topDecal;
    private final ModelPart bodyLayer;
    protected boolean hideLayers = false;

    public StoneletModel(ModelPart model) {
        this(model, false);
    }

    public StoneletModel(ModelPart model, boolean hideLayersIn) {
        super(model);
        this.hideLayers = hideLayersIn;
        this.body = model.m_171324_("body");
        this.bodyLayer = this.body.m_171324_("body_layer");
        this.head = this.body.m_171324_("head");
        this.headLayer = this.head.m_171324_("head_layer");
        this.rightArm = this.body.m_171324_("right_arm");
        this.rightArmLayer = this.rightArm.m_171324_("right_arm_layer");
        this.leftArm = this.body.m_171324_("left_arm");
        this.leftArmLayer = this.leftArm.m_171324_("left_arm_layer");
        this.lowerBody = this.body.m_171324_("lower_body");
        this.lowerBodyLayer = this.lowerBody.m_171324_("lower_body_layer");
        this.rightLeg = this.lowerBody.m_171324_("right_leg");
        this.rightLegLayer = this.rightLeg.m_171324_("right_leg_layer");
        this.leftLeg = this.lowerBody.m_171324_("left_leg");
        this.leftLegLayer = this.leftLeg.m_171324_("left_leg_layer");
        this.topDecal = this.body.m_171324_("top_decal");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition root = mesh.m_171576_();
        CubeDeformation size = new CubeDeformation(0.5f);
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171481_(-8.0f, -10.0f, -7.0f, 16.0f, 10.0f, 13.0f), PartPose.m_171419_((float)0.25f, (float)8.0f, (float)0.0f));
        body.m_171599_("body_layer", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-8.0f, -10.0f, -7.0f, 16.0f, 10.0f, 13.0f, size), PartPose.f_171404_);
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(59, 42).m_171481_(-4.25f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f), PartPose.m_171419_((float)2.75f, (float)-5.0f, (float)-7.0f));
        head.m_171599_("head_layer", CubeListBuilder.m_171558_().m_171514_(59, 28).m_171488_(-4.25f, -4.0f, -6.0f, 8.0f, 8.0f, 6.0f, size), PartPose.f_171404_);
        PartDefinition lowerBody = body.m_171599_("lower_body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-6.0f, 0.0f, -4.5f, 12.0f, 7.0f, 9.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-0.5f));
        lowerBody.m_171599_("lower_body_layer", CubeListBuilder.m_171558_().m_171514_(43, 0).m_171488_(-6.0f, 0.0f, -4.5f, 12.0f, 7.0f, 9.0f, size), PartPose.f_171404_);
        PartDefinition rightArm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(108, 14).m_171481_(-5.0f, -2.0f, -2.5f, 5.0f, 9.0f, 5.0f), PartPose.m_171419_((float)-7.5f, (float)-6.0f, (float)-0.5f));
        rightArm.m_171599_("right_arm_layer", CubeListBuilder.m_171558_().m_171514_(108, 0).m_171488_(-5.0f, -2.0f, -2.5f, 5.0f, 9.0f, 5.0f, size), PartPose.f_171404_);
        PartDefinition leftArm = body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(92, 16).m_171481_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)7.5f, (float)-7.0f, (float)0.0f));
        leftArm.m_171599_("left_arm_layer", CubeListBuilder.m_171558_().m_171514_(92, 0).m_171488_(0.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, size), PartPose.f_171404_);
        PartDefinition rightLeg = lowerBody.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(108, 46).m_171481_(-2.0f, 0.0f, -2.5f, 5.0f, 13.0f, 5.0f), PartPose.m_171419_((float)-5.5f, (float)3.0f, (float)0.0f));
        rightLeg.m_171599_("right_leg_layer", CubeListBuilder.m_171558_().m_171514_(108, 28).m_171488_(-2.0f, 0.0f, -2.5f, 5.0f, 13.0f, 5.0f, size), PartPose.f_171404_);
        PartDefinition leftLeg = lowerBody.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(88, 48).m_171481_(-2.5f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f), PartPose.m_171419_((float)4.5f, (float)5.0f, (float)0.0f));
        leftLeg.m_171599_("left_leg_layer", CubeListBuilder.m_171558_().m_171514_(88, 32).m_171488_(-2.5f, 0.0f, -2.5f, 5.0f, 11.0f, 5.0f, size), PartPose.f_171404_);
        body.m_171599_("top_decal", CubeListBuilder.m_171558_().m_171514_(58, 57).m_171481_(-8.0f, -7.0f, 0.0f, 15.0f, 7.0f, 0.0f), PartPose.m_171419_((float)0.5f, (float)-10.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)128, (int)64);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (this.hideLayers) {
            this.bodyLayer.f_104207_ = false;
            this.lowerBodyLayer.f_104207_ = false;
            this.headLayer.f_104207_ = false;
            this.leftLegLayer.f_104207_ = false;
            this.rightLegLayer.f_104207_ = false;
            this.leftArmLayer.f_104207_ = false;
            this.rightArmLayer.f_104207_ = false;
            this.topDecal.f_104207_ = false;
        }
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.copyOnlyAngles(this.body, this.f_102810_);
        this.copyOnlyAngles(this.head, this.f_102808_);
        this.copyOnlyAngles(this.leftLeg, this.f_102814_);
        this.copyOnlyAngles(this.rightLeg, this.f_102813_);
        this.copyOnlyAngles(this.leftArm, this.f_102812_);
        this.copyOnlyAngles(this.rightArm, this.f_102811_);
        this.head.f_104204_ = SkiesClientUtil.lockNum(netHeadYaw * ((float)Math.PI / 180), 0.8f);
        this.lowerBody.f_104203_ = -this.body.f_104203_;
        this.lowerBody.f_104204_ = -this.body.f_104204_;
        this.lowerBody.f_104205_ = -this.body.f_104205_;
    }

    public Iterable<ModelPart> m_5608_() {
        return List.of(this.body);
    }

    public Iterable<ModelPart> m_5607_() {
        return List.of();
    }

    public void copyOnlyAngles(ModelPart model, ModelPart copyModel) {
        model.f_104203_ = copyModel.f_104203_;
        model.f_104204_ = copyModel.f_104204_;
        model.f_104205_ = copyModel.f_104205_;
    }

    public void setRotationAngle(ModelPart modelRenderer, float x, float y, float z) {
        modelRenderer.f_104203_ = x;
        modelRenderer.f_104204_ = y;
        modelRenderer.f_104205_ = z;
    }
}

