/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public interface IFluidLoggable
extends BucketPickup,
LiquidBlockContainer {
    public static final EnumProperty<FluidLogging> FLUIDLOGGED = EnumProperty.m_61587_((String)"fluidlogged", FluidLogging.class);

    default public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return state.m_61143_(FLUIDLOGGED) == FluidLogging.EMPTY && FluidLogging.isValid(fluid);
    }

    default public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (state.m_61143_(FLUIDLOGGED) == FluidLogging.EMPTY && FluidLogging.isValid(fluid)) {
            if (!level.m_5776_()) {
                level.m_7731_(pos, (BlockState)state.m_61124_(FLUIDLOGGED, (Comparable)((Object)FluidLogging.from(fluid))), 3);
                level.m_186469_(pos, fluid, fluid.m_6718_((LevelReader)level));
            }
            return true;
        }
        return false;
    }

    default public ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState state) {
        FluidLogging fluid = (FluidLogging)((Object)state.m_61143_(FLUIDLOGGED));
        if (fluid != FluidLogging.EMPTY) {
            level.m_7731_(pos, (BlockState)state.m_61124_(FLUIDLOGGED, (Comparable)((Object)FluidLogging.EMPTY)), 3);
            if (!state.m_60710_((LevelReader)level, pos)) {
                level.m_46961_(pos, true);
            }
            return new ItemStack((ItemLike)fluid.fluid.m_6859_());
        }
        return ItemStack.f_41583_;
    }

    default public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public static enum FluidLogging implements StringRepresentable
    {
        EMPTY(Fluids.f_76191_.m_76145_(), "empty"),
        WATER(Fluids.f_76193_.m_76068_(false), "water"),
        LAVA(Fluids.f_76195_.m_76068_(false), "lava");

        public final Fluid fluid;
        public final FluidState fluidState;
        private final String name;

        private FluidLogging(FluidState fluidState, String name) {
            this.fluid = fluidState.m_76152_();
            this.fluidState = fluidState;
            this.name = name;
        }

        public static FluidLogging from(Fluid fluid) {
            for (FluidLogging f : FluidLogging.values()) {
                if (!f.fluid.equals(fluid)) continue;
                return f;
            }
            return EMPTY;
        }

        public static boolean isValid(Fluid fluid) {
            for (FluidLogging f : FluidLogging.values()) {
                if (!f.fluid.equals(fluid)) continue;
                return true;
            }
            return false;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

