/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.blue_skies.blocks.construction;

import com.google.common.collect.ImmutableList;
import com.legacy.blue_skies.items.tools.AstrolabeItem;
import com.legacy.blue_skies.registries.SkiesParticles;
import com.legacy.blue_skies.registries.SkiesSounds;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StarEmitterBlock
extends Block {
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)5.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0), Block.m_49796_((double)7.0, (double)2.0, (double)7.0, (double)9.0, (double)5.0, (double)9.0)});
    private static final ImmutableList<Vec3i> HORIZONTAL_TELEPORT_POINTS = ImmutableList.of((Object)new Vec3i(0, 0, -1), (Object)new Vec3i(-1, 0, 0), (Object)new Vec3i(0, 0, 1), (Object)new Vec3i(1, 0, 0), (Object)new Vec3i(-1, 0, -1), (Object)new Vec3i(1, 0, -1), (Object)new Vec3i(-1, 0, 1), (Object)new Vec3i(1, 0, 1));
    private static final ImmutableList<Vec3i> TELEPORT_POINTS = new ImmutableList.Builder().addAll(HORIZONTAL_TELEPORT_POINTS).addAll(HORIZONTAL_TELEPORT_POINTS.stream().map(Vec3i::m_7495_).iterator()).addAll(HORIZONTAL_TELEPORT_POINTS.stream().map(Vec3i::m_7494_).iterator()).add((Object)new Vec3i(0, 1, 0)).build();

    public StarEmitterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void m_7100_(BlockState stateIn, Level level, BlockPos pos, Random rand) {
        level.m_7106_((ParticleOptions)SkiesParticles.STAR_GLIMMER, (double)pos.m_123341_() + 0.3 + rand.nextDouble() * 0.4, (double)pos.m_123342_() + 0.4 + rand.nextDouble() * 0.4, (double)pos.m_123343_() + 0.3 + rand.nextDouble() * 0.4, 0.0, 0.0, 0.0);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof AstrolabeItem) {
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            level.m_5594_((Player)null, pos, SkiesSounds.BLOCK_STAR_EMITTER_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.m_5661_((Component)new TranslatableComponent("gui.blue_skies.tooltip.astrolabe_pos_set"), true);
            AstrolabeItem.setTeleportPos(stack, pos);
            AstrolabeItem.setTeleportDimension(stack, (ResourceKey<Level>)level.m_46472_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static Optional<Vec3> findTeleportPoint(EntityType<?> entity, CollisionGetter level, BlockPos pos) {
        Optional<Vec3> optional = StarEmitterBlock.getAvailablePoints(entity, level, pos, true);
        return optional.isPresent() ? optional : StarEmitterBlock.getAvailablePoints(entity, level, pos, false);
    }

    private static Optional<Vec3> getAvailablePoints(EntityType<?> type, CollisionGetter level, BlockPos pos, boolean checkCanSpawn) {
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (Vec3i vector3i : TELEPORT_POINTS) {
            blockpos$mutable.m_122190_((Vec3i)pos).m_122193_(vector3i);
            Vec3 vector3d = DismountHelper.m_38441_(type, (CollisionGetter)level, (BlockPos)blockpos$mutable, (boolean)checkCanSpawn);
            if (vector3d == null) continue;
            return Optional.of(vector3d);
        }
        return Optional.empty();
    }
}

