/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.registry.SGItems;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkEvent;

public record UpdateBuildingToolPacket(BuildingToolMode mode, InteractionHand hand, Map<ToolModeProperty<?>, Object> properties, Optional<BlockPos> selectedPos, Optional<BlockState> selectedState) {
    public static void encoder(UpdateBuildingToolPacket packet, FriendlyByteBuf buff) {
        buff.m_130085_(packet.mode.getName());
        buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
        buff.writeInt(packet.properties.size());
        for (Map.Entry<ToolModeProperty<?>, Object> entry : packet.properties.entrySet()) {
            ToolModeProperty<?> property = entry.getKey();
            buff.m_130070_(property.getKey());
            buff.m_130070_(property.write(entry.getValue()));
        }
        buff.writeBoolean(packet.selectedPos.isPresent());
        if (packet.selectedPos.isPresent()) {
            buff.m_130064_(packet.selectedPos.get());
        }
        buff.writeBoolean(packet.selectedState.isPresent());
        if (packet.selectedState.isPresent()) {
            buff.m_130079_(NbtUtils.m_129202_((BlockState)packet.selectedState.get()));
        }
    }

    public static UpdateBuildingToolPacket decoder(FriendlyByteBuf buff) {
        BuildingToolMode mode = BuildingToolMode.REGISTRY.get(buff.m_130281_());
        InteractionHand hand = buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        HashMap properties = new HashMap();
        int propertiesSize = buff.readInt();
        for (int i = 0; i < propertiesSize; ++i) {
            String k = buff.m_130277_();
            String v = buff.m_130277_();
            ToolModeProperty<?> property = mode.getProperties().get(k);
            properties.put(property, property.read(v));
        }
        boolean isSelectedPosPresent = buff.readBoolean();
        Optional<BlockPos> selectedPos = Optional.ofNullable(isSelectedPosPresent ? buff.m_130135_() : null);
        boolean isSelectedStatePresent = buff.readBoolean();
        Optional<Object> selectedState = Optional.ofNullable(isSelectedStatePresent ? NbtUtils.m_129241_((CompoundTag)buff.m_130260_()) : null);
        return new UpdateBuildingToolPacket(mode, hand, properties, selectedPos, selectedState);
    }

    public static void handler(UpdateBuildingToolPacket packet, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            InteractionHand hand;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            ItemStack stack = player.m_21120_(hand = packet.hand);
            if (stack.m_150930_((Item)SGItems.BUILDING_TOOL.get())) {
                BuildingToolMode mode = packet.mode;
                if (BuildingToolItem.getMode(stack) != mode) {
                    BuildingToolItem.clearPoses(stack);
                }
                BuildingToolItem.setMode(stack, mode);
                for (Map.Entry<ToolModeProperty<?>, Object> entry : packet.properties.entrySet()) {
                    ToolModeProperty<?> prop = entry.getKey();
                    BuildingToolItem.setProperty(stack, prop, entry.getValue());
                }
                if (packet.selectedPos.isPresent() && mode instanceof BuildingToolMode.ForCorners) {
                    BuildingToolMode.ForCorners cornerMode = (BuildingToolMode.ForCorners)mode;
                    cornerMode.setPosition((Player)player, packet.selectedPos.get(), stack);
                }
                if (packet.selectedState.isPresent()) {
                    BuildingToolItem.setSelectedState(stack, packet.selectedState.get());
                }
                player.m_6674_(hand);
            }
        });
        context.get().setPacketHandled(true);
    }
}

