/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.biome_dictionary.BiomeDictionary;
import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.LootTableAlias;
import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.entity.GelCapability;
import com.legacy.structure_gel.core.capability.entity.GelEntityProvider;
import com.legacy.structure_gel.core.capability.entity.IGelEntity;
import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.network.PacketHandler;
import com.legacy.structure_gel.core.registry.SGItems;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

@Internal
public class SGCommonEvents {

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.FORGE)
    protected static class ForgeBus {
        protected ForgeBus() {
        }

        @SubscribeEvent
        protected static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            event.addCapability(StructureGelMod.locate("gel_entity"), (ICapabilityProvider)new GelEntityProvider());
        }

        @SubscribeEvent
        protected static void onEntityJoinLevel(EntityJoinWorldEvent event) {
            Entity entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                GelCapability.ifPresent(serverPlayer, gelPlayer -> gelPlayer.sendToClient(serverPlayer));
            }
        }

        @SubscribeEvent
        protected static void registerCommands(RegisterCommandsEvent event) {
            StructureGelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        protected static void onLogout(PlayerEvent.PlayerLoggedOutEvent event) {
            ActionHistory.clearHistory();
        }

        @SubscribeEvent
        protected static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            if (event.getItemStack().m_150930_((Item)SGItems.BUILDING_TOOL.get())) {
                event.setUseBlock(Event.Result.DENY);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="structure_gel", bus=Mod.EventBusSubscriber.Bus.MOD)
    protected static class ModBus {
        private static boolean SGRegistriesLoaded = false;

        protected ModBus() {
        }

        @SubscribeEvent
        protected static void registerCapability(RegisterCapabilitiesEvent event) {
            event.register(IGelEntity.class);
        }

        @SubscribeEvent
        protected static void loadConfigs(ModConfigEvent.Loading event) {
            if (event.getConfig().getFileName().contains("common") && !SGRegistriesLoaded) {
                BiomeDictionary.REGISTRY.init();
                LootTableAlias.REGISTRY.init();
                DataHandlerType.REGISTRY.init();
                DynamicSpawnerType.REGISTRY.init();
                try {
                    if (SGConfig.COMMON.shouldGuessBiomeDict()) {
                        StructureGelMod.log("Attempting to register unregistered biomes to the biome dictionary. This can be disabled via config", new Object[0]);
                        BiomeDictionary.makeGuess(SGConfig.COMMON.getIgnoredMods());
                    }
                }
                catch (Throwable e) {
                    StructureGelMod.logError("Encountered an issue while making assumptions for the biome dictionary. Please narrow down which mods cause a conflict here and report it to our issue tracker: https://gitlab.com/modding-legacy/structure-gel-api/-/issues", e);
                }
                SGRegistriesLoaded = true;
            }
        }

        @SubscribeEvent
        protected static void commonSetup(FMLCommonSetupEvent event) {
            if (!SGRegistriesLoaded) {
                StructureGelMod.logFatal("Structure Gel registry data never loaded! Many things could break because of this.", new Object[0]);
            }
            ModList modList = ModList.get();
            StructureGelMod.isLootrLoaded = modList.isLoaded("lootr");
            PacketHandler.register();
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        protected static void gatherData(GatherDataEvent event) {
            StructureRegistrar.REGISTRARS.values().forEach(StructureRegistrar::handle);
        }
    }
}

