/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.core.SGAccessor;
import com.legacy.structure_gel.core.registry.SGStructures;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.FeatureAccess;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class GelStructurePlacement
implements StructurePlacement {
    public static final Codec<GelStructurePlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(p -> p.spacing), (App)Codec.intRange((int)0, (int)4096).fieldOf("offset").forGetter(p -> p.offset), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(p -> Float.valueOf(p.probability)), (App)ExtraCodecs.f_144629_.fieldOf("seed").forGetter(p -> p.seed), (App)Codec.BOOL.fieldOf("allowed_near_spawn").forGetter(p -> p.allowedNearSpawn)).apply((Applicative)instance, GelStructurePlacement::new));
    protected final int spacing;
    protected final int offset;
    protected final float probability;
    protected final int seed;
    protected final boolean allowedNearSpawn;

    public GelStructurePlacement(int spacing, int offset, float probability, int seed, boolean allowedNearSpawn) {
        this.spacing = spacing;
        this.offset = Mth.m_14045_((int)offset, (int)0, (int)spacing);
        this.probability = probability;
        this.seed = seed;
        this.allowedNearSpawn = allowedNearSpawn;
    }

    public GelStructurePlacement(GelStructure<?> gelStructure) {
        this(gelStructure.getSpacing(), gelStructure.getOffset(), gelStructure.getProbability(), gelStructure.getSeed(), gelStructure.isAllowedNearWorldSpawn());
    }

    public boolean m_212129_(ChunkGenerator chunkGen, long levelSeed, int chunkX, int chunkZ) {
        Optional<ChunkPos> opGenPos = this.getFeatureChunk(chunkGen, levelSeed, chunkX, chunkZ);
        if (opGenPos.isPresent()) {
            ChunkPos genPos = opGenPos.get();
            return genPos.f_45578_ == chunkX && genPos.f_45579_ == chunkZ;
        }
        return false;
    }

    public Optional<ChunkPos> getFeatureChunk(ChunkGenerator chunkGen, long levelSeed, int chunkX, int chunkZ) {
        if (this.probability > 0.0f) {
            int gridX = (int)Math.floor((float)chunkX / (float)this.spacing) * this.spacing;
            int gridZ = (int)Math.floor((float)chunkZ / (float)this.spacing) * this.spacing;
            int offset = this.offset + 1;
            WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(levelSeed));
            rand.m_190058_(levelSeed, gridX, gridZ, this.seed);
            ChunkPos genPos = new ChunkPos(gridX + rand.nextInt(offset), gridZ + rand.nextInt(offset));
            if ((this.allowedNearSpawn || !this.isNearSpawn(genPos)) && (this.probability >= 1.0f || this.probabilityTest(genPos, levelSeed))) {
                return Optional.of(genPos);
            }
        }
        return Optional.empty();
    }

    protected boolean isNearSpawn(ChunkPos genPos) {
        int range = 12;
        return genPos.f_45578_ < range && genPos.f_45578_ > -range && genPos.f_45579_ < range && genPos.f_45579_ > -range;
    }

    protected boolean probabilityTest(ChunkPos genPos, long levelSeed) {
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(levelSeed));
        rand.m_190058_(levelSeed, genPos.f_45578_, genPos.f_45579_, this.seed);
        return rand.nextFloat() < this.probability;
    }

    public StructurePlacementType<?> m_203443_() {
        return SGStructures.StructurePlacementTypes.GEL_PLACEMENT;
    }

    protected BlockPos getLocatePos(ChunkPos chunkPos) {
        return new BlockPos(chunkPos.m_45604_(), 0, chunkPos.m_45605_());
    }

    @Nullable
    @Internal
    private Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> findNearest(Set<Holder<ConfiguredStructureFeature<?, ?>>> structures, ServerLevel level, ChunkGenerator chunkGen, StructureFeatureManager structureManager, int x, int z, int radius, boolean skipKnown) {
        int spacing = this.spacing;
        for (int dx = -radius; dx <= radius; ++dx) {
            boolean flag = dx == -radius || dx == radius;
            for (int dz = -radius; dz <= radius; ++dz) {
                boolean flag1;
                boolean bl = flag1 = dz == -radius || dz == radius;
                if (!flag && !flag1) continue;
                int cx = x + spacing * dx;
                int cz = z + spacing * dz;
                Optional<ChunkPos> opGenPos = this.getFeatureChunk(chunkGen, level.m_7328_(), cx, cz);
                if (!opGenPos.isPresent()) continue;
                ChunkPos genPos = opGenPos.get();
                for (Holder<ConfiguredStructureFeature<?, ?>> holder : structures) {
                    StructureCheckResult result = structureManager.m_207777_(genPos, (ConfiguredStructureFeature)holder.m_203334_(), skipKnown);
                    if (result == StructureCheckResult.START_NOT_PRESENT) continue;
                    if (!skipKnown && result == StructureCheckResult.START_PRESENT) {
                        return Pair.of((Object)this.getLocatePos(genPos), holder);
                    }
                    ChunkAccess chunkAccess = level.m_46819_(genPos.f_45578_, genPos.f_45579_, ChunkStatus.f_62315_);
                    StructureStart start = structureManager.m_207802_(SectionPos.m_175562_((ChunkAccess)chunkAccess), (ConfiguredStructureFeature)holder.m_203334_(), (FeatureAccess)chunkAccess);
                    if (start == null || !start.m_73603_()) continue;
                    if (skipKnown) {
                        if (!start.m_73606_()) continue;
                        structureManager.m_196674_(start);
                        return Pair.of((Object)this.getLocatePos(start.m_163625_()), holder);
                    }
                    return Pair.of((Object)this.getLocatePos(start.m_163625_()), holder);
                }
            }
        }
        return null;
    }

    @Nullable
    @Internal
    public static Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> findNearestMapFeature(ServerLevel level, HolderSet<ConfiguredStructureFeature<?, ?>> structureHolders, BlockPos origin, int radius, boolean skipKnown, ChunkGenerator chunkGen, @Nullable Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> oldNearest) {
        Set biomeSourceBiomes;
        Set structureBiomes = structureHolders.m_203614_().flatMap(csf -> ((ConfiguredStructureFeature)csf.m_203334_()).m_209752_().m_203614_()).collect(Collectors.toSet());
        if (!structureBiomes.isEmpty() && !Collections.disjoint(biomeSourceBiomes = chunkGen.m_62218_().m_207840_(), structureBiomes)) {
            Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> newNearest = null;
            Object2ObjectArrayMap structuresByPlacement = new Object2ObjectArrayMap();
            for (Holder holder : structureHolders) {
                if (biomeSourceBiomes.stream().noneMatch(arg_0 -> ((HolderSet)((ConfiguredStructureFeature)holder.m_203334_()).m_209752_()).m_203333_(arg_0))) continue;
                for (StructurePlacement structureplacement : SGAccessor.CHUNK_GENERATOR_GET_PLACEMENTS.invoke(chunkGen, holder)) {
                    structuresByPlacement.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
                }
            }
            block2: for (Map.Entry entry : structuresByPlacement.entrySet()) {
                StructurePlacement placement2 = (StructurePlacement)entry.getKey();
                if (!(placement2 instanceof GelStructurePlacement)) continue;
                GelStructurePlacement gelPlacement = (GelStructurePlacement)placement2;
                int originCX = SectionPos.m_123171_((int)origin.m_123341_());
                int originCZ = SectionPos.m_123171_((int)origin.m_123343_());
                for (int r = 0; r <= radius; ++r) {
                    Pair<BlockPos, Holder<ConfiguredStructureFeature<?, ?>>> found = gelPlacement.findNearest((Set)entry.getValue(), level, chunkGen, level.m_8595_(), originCX, originCZ, r, skipKnown);
                    if (found == null) continue;
                    newNearest = found;
                    continue block2;
                }
            }
            if (oldNearest == null) {
                return newNearest;
            }
            if (newNearest != null) {
                double oldDist = origin.m_123331_((Vec3i)oldNearest.getFirst());
                double newDist = origin.m_123331_((Vec3i)newNearest.getFirst());
                if (newDist < oldDist) {
                    return newNearest;
                }
            }
        }
        return oldNearest;
    }
}

