/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.biome_dictionary;

import com.google.common.collect.ImmutableSet;
import com.legacy.structure_gel.api.biome_dictionary.BiomeType;
import com.legacy.structure_gel.api.events.RegisterBiomeDictionaryTypeEvent;
import com.legacy.structure_gel.api.registry.SGRegistry;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class BiomeDictionary {
    public static final SGRegistry<ResourceLocation, BiomeType> REGISTRY = new SGRegistry<ResourceLocation, BiomeType>(StructureGelMod.locate("biome_dictionary"), () -> null, RegisterBiomeDictionaryTypeEvent::new){

        @Override
        protected void preInit() {
            this.forceRegister(EMPTY_NAME, EMPTY);
        }

        @Override
        public BiomeType register(ResourceLocation key, BiomeType value) throws IllegalStateException, IllegalArgumentException {
            if (EMPTY_NAME.equals((Object)key) || BiomeType.INTERNAL_NAME.equals((Object)key)) {
                throw new IllegalArgumentException("Cannot register a BiomeType under the name " + key + ".");
            }
            BiomeType contained = (BiomeType)this.get(key);
            if (contained != null) {
                contained.merge(value);
                return contained;
            }
            return super.register(key, value);
        }
    };
    private static final String bop = "biomesoplenty";
    private static final String nethercraft = "nethercraft";
    private static final String endergetic = "endergetic";
    private static final String rediscovered = "rediscovered";
    private static final String moo = "moolands";
    private static final String pagamos = "pagamos";
    private static final String glacidus = "glacidus";
    private static final String byg = "byg";
    private static final String aether = "aether";
    private static final Map<Holder<Biome>, ImmutableSet<BiomeType>> BIOME_TO_BIOMETYPE_CACHE = new HashMap<Holder<Biome>, ImmutableSet<BiomeType>>();
    protected static final ResourceLocation EMPTY_NAME = StructureGelMod.locate("empty");
    public static final BiomeType EMPTY = BiomeType.builder(EMPTY_NAME).immutable().build();
    public static final BiomeType ALL_BIOMES = BiomeDictionary.register(BiomeType.builder("all_biomes").biomes(ForgeRegistries.BIOMES.getKeys()));
    public static final Map<BiomeDictionary.Type, BiomeType> FORGE_TYPES = (Map)Util.m_137469_(new HashMap(), map -> BiomeDictionary.Type.getAll().forEach(type -> map.put(type, BiomeDictionary.register(BiomeType.builder(new ResourceLocation("forge", type.getName().toLowerCase(Locale.ENGLISH))).forgeTypes((BiomeDictionary.Type)type)))));
    public static final BiomeType FROZEN_OCEAN = BiomeDictionary.register(BiomeType.builder("frozen_ocean").biomes(Biomes.f_48211_, Biomes.f_48172_));
    public static final BiomeType COLD_OCEAN = BiomeDictionary.register(BiomeType.builder("cold_ocean").biomes(Biomes.f_48168_, Biomes.f_48171_));
    public static final BiomeType WARM_OCEAN = BiomeDictionary.register(BiomeType.builder("warm_ocean").biomes(Biomes.f_48166_));
    public static final BiomeType LUKEWARM_OCEAN = BiomeDictionary.register(BiomeType.builder("lukewarm_ocean").biomes(Biomes.f_48167_, Biomes.f_48170_));
    public static final BiomeType DEEP_OCEAN = BiomeDictionary.register(BiomeType.builder("deep_ocean").biomes(Biomes.f_48172_, Biomes.f_48171_, Biomes.f_48225_, Biomes.f_48170_));
    public static final BiomeType OCEAN = BiomeDictionary.register(BiomeType.builder("ocean").parents(FROZEN_OCEAN, COLD_OCEAN, LUKEWARM_OCEAN, WARM_OCEAN, DEEP_OCEAN).biomes(Biomes.f_48174_).biomes("byg", "dead_sea"));
    public static final BiomeType PLAINS = BiomeDictionary.register(BiomeType.builder("plains").biomes(Biomes.f_48202_, Biomes.f_48176_, Biomes.f_186754_).biomes("biomesoplenty", "grove_clearing", "steppe", "highland", "tundra", "lush_grassland", "jade_grassland", "shrubland", "wooded_scrubland", "lush_savanna", "scrubland", "flower_meadow", "prairie", "golden_prairie").biomes("byg", "allium_fields", "amaranth_fields", "meadow", "prairie", "prairie_clearing", "shrublands", "wooded_meadow"));
    public static final BiomeType SNOWY_PLAINS = BiomeDictionary.register(BiomeType.builder("snowy_plains").biomes(Biomes.f_186761_));
    public static final BiomeType DESERT = BiomeDictionary.register(BiomeType.builder("desert").biomes(Biomes.f_48203_).biomes("biomesoplenty", "xeric_shrubland", "outback", "lush_desert").biomes("byg", "dunes", "lush_red_desert", "mojave_desert", "red_desert", "red_desert_dunes"));
    public static final BiomeType SAVANNA = BiomeDictionary.register(BiomeType.builder("savanna").biomes(Biomes.f_48157_, Biomes.f_48158_).biomes("biomesoplenty", "brushland").biomes("byg", "baobab_savanna"));
    public static final BiomeType MOUNTAIN_SAVANNA = BiomeDictionary.register(BiomeType.builder("mountain_savanna").biomes(Biomes.f_186768_));
    public static final BiomeType FLOWERY = BiomeDictionary.register(BiomeType.builder("flowery").biomes(Biomes.f_48179_, Biomes.f_48176_, Biomes.f_186754_).biomes("biomesoplenty", "lavender_field", "lavender_forest", "lush_savanna", "flower_meadow").biomes("byg", "allium_fields", "amaranth_fields", "flowering_enchanted_grove", "flowering_grove", "flowering_meadow"));
    public static final BiomeType OAK_FOREST = BiomeDictionary.register(BiomeType.builder("oak_forest").biomes(Biomes.f_48205_).biomes("biomesoplenty", "maple_forest", "snowy_maple_forest", "orchard", "origin_hills", "rainforest", "silkglade_nest", "snowy_forest").biomes("byg", "deciduous_clearing", "deciduous_forest", "deciduous_forest_hills", "orchard", "red_oak_forest", "red_oak_forest_hills", "snowy_deciduous_clearing", "snowy_deciduous_forest", "snowy_deciduous_forest_hills", "woodlands"));
    public static final BiomeType BIRCH_FOREST = BiomeDictionary.register(BiomeType.builder("birch_forest").biomes(Biomes.f_48149_, Biomes.f_186762_).biomes("biomesoplenty", "boreal_forest", "rainbow_valley").biomes("byg", "aspen_clearing", "aspen_forest", "aspen_forest_hills"));
    public static final BiomeType SPRUCE_FOREST = BiomeDictionary.register(BiomeType.builder("spruce_forest").biomes(Biomes.f_48206_).biomes("biomesoplenty", "coniferous_lakes", "grove", "meadow", "meadow_forest", "jade_cliffs").biomes("byg", "blue_taiga", "blue_taiga_hills", "boreal_clearing", "boreal_forest", "boreal_forest_hills", "evergreen_clearing", "evergreen_hills", "evergreen_taiga"));
    public static final BiomeType SNOWY_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.builder("snowy_spruce_forest").biomes(Biomes.f_48152_, Biomes.f_186755_).biomes("byg", "apline_foothills", "snowy_blue_taiga", "snowy_blue_taiga_hills", "snowy_evergreen_clearing", "snowy_evergreen_hills", "snowy_evergreen_taiga"));
    public static final BiomeType LARGE_SPRUCE_FOREST = BiomeDictionary.register(BiomeType.builder("large_spruce_forest").biomes(Biomes.f_186763_, Biomes.f_186764_).biomes("byg", "blue_giant_taiga", "snowy_blue_giant_taiga"));
    public static final BiomeType BAMBOO_JUNGLE = BiomeDictionary.register(BiomeType.builder("bamboo_jungle").biomes(Biomes.f_48197_));
    public static final BiomeType JUNGLE = BiomeDictionary.register(BiomeType.builder("jungle").parents(BAMBOO_JUNGLE).biomes(Biomes.f_48222_, Biomes.f_186769_).biomes("biomesoplenty", "rainforest_cliffs").biomes("byg", "guiana_clearing", "guiana_shield"));
    public static final BiomeType DARK_FOREST = BiomeDictionary.register(BiomeType.builder("dark_forest").biomes(Biomes.f_48151_).biomes("byg", "ancient_forest", "ebony_woods", "ebony_hills", "flowering_ancient_forest"));
    public static final BiomeType CONIFEROUS_FOREST = BiomeDictionary.register(BiomeType.builder("coniferous_forest").biomes("biomesoplenty", "snowy_coniferous_forest", "coniferous_forest", "fir_clearing", "snowy_fir_clearing").biomes("byg", "coniferous_clearing", "coniferous_forest", "coniferous_forest_hills", "snowy_coniferous_clearing", "snowy_coniferous_forest", "snowy_coniferous_forest_hills"));
    public static final BiomeType REDWOOD_FOREST = BiomeDictionary.register(BiomeType.builder("redwood_forest").biomes("biomesoplenty", "redwood_forest", "redwood_forest_edge", "redwood_forest", "redwood_forest_hills", "redwood_hills").biomes("byg", "redwood_clearing", "redwood_mountains", "redwood_tropics"));
    public static final BiomeType AUTUMN_FOREST = BiomeDictionary.register(BiomeType.builder("autumn_forest").biomes("biomesoplenty", "maple_forest", "seasonal_forest", "seasonal_orchard", "seasonal_pumpkin_patch").biomes("byg", "maple_hills", "maple_taiga", "seasonal_birch_forest", "seasonal_birch_forest_hills", "seasonal_deciduous_clearing", "seasonal_deciduous_forest", "seasonal_deciduous_forest_hills", "seasonal_forest", "seasonal_forest_hills", "seasonal_giant_taiga", "seasonal_taiga", "seasonal_taiga_hills", "zelkova_clearing", "zelkova_forest", "zelkova_forest_hills"));
    public static final BiomeType CHERRY_FOREST = BiomeDictionary.register(BiomeType.builder("cherry_forest").biomes("biomesoplenty", "cherry_blossom_grove", "bamboo_blossom_grove").biomes("byg", "cherry_blossom_clearing", "cherry_blossom_forest", "skyris_highlands"));
    public static final BiomeType BAMBOO = BiomeDictionary.register(BiomeType.builder("bamboo").parents(BAMBOO_JUNGLE).biomes("biomesoplenty", "bamboo_blossom_grove").biomes("byg", "jacaranda_clearing", "jacaranda_forest", "jacaranda_forest_hills", "bamboo_forest", "crag_gardens"));
    public static final BiomeType MOUNTAIN = BiomeDictionary.register(BiomeType.builder("mountain").biomes(Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_, Biomes.f_186754_, Biomes.f_186755_, Biomes.f_186756_, Biomes.f_186758_, Biomes.f_186757_, Biomes.f_186759_).biomes("biomesoplenty", "steppe", "rainforest_cliffs", "highland_moor", "highland", "highland_crag", "shrubland_hills", "jade_cliffs").biomes("byg", "bluff_steeps", "cika_mountains", "crag_gardens", "dover_mountains", "grassland_plateau", "guiana_clearing", "guiana_shield", "redwood_mountains", "skyris_highlands", "wooded_grassland_plateau"));
    public static final BiomeType SNOWY_MOUNTAIN = BiomeDictionary.register(BiomeType.builder("snowy_mountain").biomes(Biomes.f_186756_, Biomes.f_186757_, Biomes.f_186755_).biomes("biomesoplenty", "alps", "alps_foothills").biomes("byg", "apls", "apline_foothills", "bluff_peaks", "bluff_steeps"));
    public static final BiomeType SWAMP = BiomeDictionary.register(BiomeType.builder("swamp").biomes(Biomes.f_48207_).biomes("biomesoplenty", "dead_swamp", "rainforest_floodplain", "bayou", "deep_bayou", "wetland", "lush_swamp", "bog", "wetland_marsh").biomes("byg", "bayou", "tundra_bog", "cold_swamplands", "cypress_swamplands", "glowshroom_bayou", "marshlands", "vibrant_swamplands"));
    public static final BiomeType MANGROVE = BiomeDictionary.register(BiomeType.builder("mangrove").biomes("biomesoplenty", "bayou_mangrove").biomes("byg", "coral_mangroves", "cypress_swamplands", "mangrove_marshes"));
    public static final BiomeType BADLANDS = BiomeDictionary.register(BiomeType.builder("badlands").biomes(Biomes.f_48159_, Biomes.f_186753_, Biomes.f_48194_).biomes("biomesoplenty", "outback").biomes("byg", "lush_red_desert", "red_desert", "red_desert_dunes", "red_rock_highlands", "red_rock_lowlands", "red_rock_mountains", "sierra_range", "sierra_valley", "wooded_red_rock_mountains"));
    public static final BiomeType MUSHROOM = BiomeDictionary.register(BiomeType.builder("mushroom").biomes(Biomes.f_48215_).biomes("biomesoplenty", "fungal_jungle", "overgrown_fungal_jungle").biomes("byg", "glowing_ancient_forest", "glowshroom_bayou"));
    public static final BiomeType FUNGAL = BiomeDictionary.register(BiomeType.builder("fungal").parents(MUSHROOM).biomes("biomesoplenty", "fungal_field").biomes("byg", "fungal_patch"));
    public static final BiomeType RIVER = BiomeDictionary.register(BiomeType.builder("river").biomes(Biomes.f_48208_, Biomes.f_48212_));
    public static final BiomeType LAKE = BiomeDictionary.register(BiomeType.builder("lake").biomes("biomesoplenty", "oasis", "grove_lakes").biomes("byg", "fresh_water_lake", "oasis", "frozen_lake", "great_lakes", "polluted_lake"));
    public static final BiomeType BEACH = BiomeDictionary.register(BiomeType.builder("beach").biomes(Biomes.f_48217_, Biomes.f_186760_).biomes("biomesoplenty", "tropic_beach").biomes("byg", "rainbow_beach", "snowy_black_beach", "white_beach"));
    public static final BiomeType WOODED = BiomeDictionary.register(BiomeType.builder("wooded").parents(OAK_FOREST, BIRCH_FOREST, SPRUCE_FOREST, SNOWY_SPRUCE_FOREST, DARK_FOREST, AUTUMN_FOREST, CHERRY_FOREST).biomes(Biomes.f_48179_).biomes("biomesoplenty", "seasonal_forest", "lavender_field", "tropical_rainforest", "dead_forest").biomes("byg", "jacaranda_forest", "the_black_forest", "black_forest_hills", "bluff_peaks", "bluff_steeps", "enchanted_forest", "enchanted_forest_hills", "flowering_meadow", "forest_fault", "glowing_ancient_forest", "great_lake_isles", "grove", "weeping_witch_forest", "weeping_witch_clearing", "wooded_grassland_plateau", "wooded_meadow", "wooded_red_rock_mountains"));
    public static final BiomeType LARGE_WOODED = BiomeDictionary.register(BiomeType.builder("large_wooded").parents(LARGE_SPRUCE_FOREST, JUNGLE, CONIFEROUS_FOREST, REDWOOD_FOREST).biomes("byg", "cika_wooded", "cika_mountains", "dover_mountains", "northern_forest"));
    public static final BiomeType SANDY = BiomeDictionary.register(BiomeType.builder("sandy").parents(DESERT, BEACH).biomes(Biomes.f_48199_, Biomes.f_48159_));
    public static final BiomeType GRAVELLY = BiomeDictionary.register(BiomeType.builder("gravelly").biomes(Biomes.f_186766_).biomes("biomesoplenty", "gravel_beach", "tundra_basin"));
    public static final BiomeType DIRTY = BiomeDictionary.register(BiomeType.builder("dirty").biomes(Biomes.f_186763_, Biomes.f_186764_).biomes("byg", "black_forest_clearing"));
    public static final BiomeType TROPICAL = BiomeDictionary.register(BiomeType.builder("tropical").biomes("biomesoplenty", "tropic_beach", "tropics", "tropic_plains", "rainforest", "tropical_rainforest", "rainforest_cliffs").biomes("byg", "tropical_fungal_forest", "tropical_fungal_rainforest_hills", "tropical_island", "tropical_rainforest", "tropical_rainforest_hills"));
    public static final BiomeType VOLCANIC = BiomeDictionary.register(BiomeType.builder("volcanic").biomes("biomesoplenty", "volcanic_plains", "volcano"));
    public static final BiomeType DEAD = BiomeDictionary.register(BiomeType.builder("dead").biomes(Biomes.f_48209_).biomes("biomesoplenty", "wooded_wasteland", "dry_boneyard", "burnt_forest", "dead_forest", "wasteland", "silkglade", "silkglade_nest", "xeric_shrubland", "brushland", "dead_swamp", "dryland").biomes("byg", "dead_sea"));
    public static final BiomeType SKY = BiomeDictionary.register(BiomeType.builder("sky").biomes("rediscovered", "skylands"));
    public static final BiomeType CAVE = BiomeDictionary.register(BiomeType.builder("cave").biomes(Biomes.f_151785_, Biomes.f_151784_));
    public static final BiomeType FROZEN = BiomeDictionary.register(BiomeType.builder("frozen").biomes(Biomes.f_48212_, Biomes.f_48182_, Biomes.f_186757_).parents(FROZEN_OCEAN).biomes("byg", "frozen_lake", "shattered_glacier"));
    public static final BiomeType SNOWY = BiomeDictionary.register(BiomeType.builder("snowy").parents(SNOWY_SPRUCE_FOREST, SNOWY_PLAINS, SNOWY_MOUNTAIN).biomes(Biomes.f_48212_, Biomes.f_48148_).biomes("biomesoplenty", "snowy_forest", "snowy_coniferous_forest", "snowy_fir_clearing", "muskeg", "alps", "alps_foothills", "snowy_black_beach", "snowy_blue_taiga", "snowy_blue_taiga_hills", "snowy_giant_blue_taiga", "snowy_coniferous_clearing", "snowy_coniferous_forest", "snowy_coniferous_forest_hills", "snowy_deciduous_clearing", "snowy_deciduous_forest", "snowy_deciduous_forest_hills", "snowy_evergreen_clearing", "snowy_evergreen_hills", "snowy_evergreen_taiga", "snowy_maple_forest", "snowy_rocky_black_beach"));
    public static final BiomeType COLD = BiomeDictionary.register(BiomeType.builder("cold").parents(SPRUCE_FOREST, LARGE_SPRUCE_FOREST, CONIFEROUS_FOREST).biomes(Biomes.f_186765_, Biomes.f_186766_, Biomes.f_186767_).biomes("biomesoplenty", "tundra", "tundra_bog", "tundra_basin").biomes("byg", "cold_swamplands", "lush_tundra", "rocky_beach"));
    public static final BiomeType NEUTRAL_TEMP = BiomeDictionary.register(BiomeType.builder("neutral_temp").parents(PLAINS, OAK_FOREST, BIRCH_FOREST, DARK_FOREST).biomes(Biomes.f_48179_));
    public static final BiomeType WARM = BiomeDictionary.register(BiomeType.builder("warm").parents(SWAMP, MANGROVE, JUNGLE, MUSHROOM, TROPICAL));
    public static final BiomeType HOT = BiomeDictionary.register(BiomeType.builder("hot").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, VOLCANIC));
    public static final BiomeType FIERY = BiomeDictionary.register(BiomeType.builder("fiery").biomes(Biomes.f_48209_, Biomes.f_48199_, Biomes.f_48175_).biomes("byg", "embur_bog"));
    public static final BiomeType HUMID = BiomeDictionary.register(BiomeType.builder("humid").parents(SWAMP, JUNGLE, TROPICAL));
    public static final BiomeType DRY = BiomeDictionary.register(BiomeType.builder("dry").parents(DESERT, BADLANDS, SAVANNA, MOUNTAIN_SAVANNA, DEAD).biomes("biomesoplenty", "dryland"));
    public static final BiomeType VOID = BiomeDictionary.register(BiomeType.builder("void").biomes(Biomes.f_48173_));
    public static final BiomeType MAGICAL = BiomeDictionary.register(BiomeType.builder("magical").biomes("biomesoplenty", "mystic_grove", "mystic_plains", "rainbow_hills").biomes("byg", "enchanted_forest", "enchanted_forest_hills", "enchanted_grove", "flowering_enchanted_grove"));
    public static final BiomeType SPOOKY = BiomeDictionary.register(BiomeType.builder("spooky").parents(DARK_FOREST).biomes("biomesoplenty", "ominous_woods", "ominous_mire", "pumpkin_patch", "silkglade_nest", "visceral_heap", "withered_abyss", "dryland").biomes("byg", "pumpkin_forest", "weeping_witch_forest", "weeping_witch_clearing"));
    public static final BiomeType RARE = BiomeDictionary.register(BiomeType.builder("rare").biomes(Biomes.f_48215_, Biomes.f_48182_).biomes("biomesoplenty", "mystic_grove", "origin_valley", "rainbow_hills").biomes("byg", "rainbow_beach", "tropical_island"));
    public static final BiomeType SPACE = BiomeDictionary.register(BiomeType.builder("space").biomes("glacidus", "glacidus"));
    public static final BiomeType PUMPKIN = BiomeDictionary.register(BiomeType.builder("pumpkin").biomes("biomesoplenty", "pumpkin_patch", "seasonal_pumpkin_patch").biomes("byg", "pumpkin_forest", "autumnal_valley", "cika_wooded", "cika_mountains"));
    public static final BiomeType OVERWORLD = BiomeDictionary.register(BiomeType.builder("overworld").biomes(new BiomeSource[]{MultiNoiseBiomeSource.Preset.f_187087_.m_187099_(BuiltinRegistries.f_123865_)}).parents(FORGE_TYPES.get(BiomeDictionary.Type.OVERWORLD)));
    public static final BiomeType OVERGROW_NETHER = BiomeDictionary.register(BiomeType.builder("overgrown_nether").biomes("biomesoplenty", "undergrowth"));
    public static final BiomeType WARPED = BiomeDictionary.register(BiomeType.builder("warped").biomes(Biomes.f_48201_).biomes("byg", "warped_desert"));
    public static final BiomeType CRIMSON = BiomeDictionary.register(BiomeType.builder("crimson").biomes(Biomes.f_48200_));
    public static final BiomeType NETHER_FOREST = BiomeDictionary.register(BiomeType.builder("nether_forest").biomes(Biomes.f_48200_, Biomes.f_48201_).biomes("nethercraft", "glowing_grove"));
    public static final BiomeType NETHER_FUNGAL = BiomeDictionary.register(BiomeType.builder("nether_fungal").biomes(Biomes.f_48200_, Biomes.f_48201_).biomes("nethercraft", "glowshroom_garden").biomes("byg", "glowstone_gardens"));
    public static final BiomeType NETHER_SANDY = BiomeDictionary.register(BiomeType.builder("nether_sandy").biomes(Biomes.f_48199_).biomes("nethercraft", "volcanic_rushes").biomes("byg", "warped_desert"));
    public static final BiomeType NETHER_EXTREME = BiomeDictionary.register(BiomeType.builder("nether_extreme").biomes(Biomes.f_48175_));
    public static final BiomeType NETHER_FLESHY = BiomeDictionary.register(BiomeType.builder("nether_fleshy").biomes("biomesoplenty", "visceral_heap"));
    public static final BiomeType THE_NETHER = BiomeDictionary.register(BiomeType.builder("the_nether").biomes(new BiomeSource[]{MultiNoiseBiomeSource.Preset.f_48512_.m_187099_(BuiltinRegistries.f_123865_)}).parents(OVERGROW_NETHER, WARPED, CRIMSON, NETHER_FOREST, NETHER_FUNGAL, NETHER_SANDY, NETHER_EXTREME, NETHER_FLESHY, FORGE_TYPES.get(BiomeDictionary.Type.NETHER)));
    public static final BiomeType OUTER_END_ISLAND = BiomeDictionary.register(BiomeType.builder("outer_end_island").biomes(Biomes.f_48164_, Biomes.f_48163_).biomes("endergetic", "poise_forest", "chorus_plains", "end_midlands", "end_highlands").biomes("byg", "ivis_fields"));
    public static final BiomeType OUTER_END = BiomeDictionary.register(BiomeType.builder("outer_end").biomes(Biomes.f_48165_, Biomes.f_48162_));
    public static final BiomeType THE_END = BiomeDictionary.register(BiomeType.builder("the_end").biomes(Biomes.f_48210_).biomes(new BiomeSource[]{new TheEndBiomeSource(BuiltinRegistries.f_123865_, 0L)}).parents(OUTER_END_ISLAND, FORGE_TYPES.get(BiomeDictionary.Type.END)));
    public static final BiomeType AETHER = BiomeDictionary.register(BiomeType.builder("aether").biomes("aether", "aether_skylands"));
    public static final BiomeType SKYLANDS = BiomeDictionary.register(BiomeType.builder("skylands").biomes("rediscovered", "skylands"));
    public static final BiomeType MOOLANDS = BiomeDictionary.register(BiomeType.builder("moolands").biomes("moolands", "awkward_heights"));
    public static final BiomeType PAGAMOS = BiomeDictionary.register(BiomeType.builder("pagamos").biomes("pagamos", "frozen_hell"));
    public static final BiomeType GLACIDUS = BiomeDictionary.register(BiomeType.builder("glacidus").biomes("glacidus", "glacidus"));
    public static final BiomeType GOOD_DREAM = BiomeDictionary.register(BiomeType.builder("good_dream"));
    public static final BiomeType NIGHTMARE = BiomeDictionary.register(BiomeType.builder("nightmare"));

    public static BiomeType register(BiomeType.Builder biomeTypeBuilder) {
        return BiomeDictionary.register(biomeTypeBuilder.build());
    }

    public static BiomeType register(BiomeType biomeType) {
        BIOME_TO_BIOMETYPE_CACHE.clear();
        return REGISTRY.register(biomeType.getRegistryName(), biomeType);
    }

    public static ImmutableSet<BiomeType> getAllTypes(Holder<Biome> biomeHolder) {
        return BIOME_TO_BIOMETYPE_CACHE.computeIfAbsent(biomeHolder, b -> {
            ImmutableSet.Builder types = ImmutableSet.builder();
            REGISTRY.getValues().stream().filter(type -> type.getAllValues().contains(biomeHolder)).forEach(arg_0 -> ((ImmutableSet.Builder)types).add(arg_0));
            return types.build();
        });
    }

    public static ImmutableSet<BiomeType> getAllTypes(ResourceKey<Biome> biomeKey) {
        Optional op = ForgeRegistries.BIOMES.getHolder(biomeKey);
        return op.isPresent() ? BiomeDictionary.getAllTypes((Holder<Biome>)((Holder)op.get())) : ImmutableSet.of();
    }

    public static ImmutableSet<BiomeType> getAllTypes(ResourceLocation biomeName) {
        Optional op = ForgeRegistries.BIOMES.getHolder(biomeName);
        return op.isPresent() ? BiomeDictionary.getAllTypes((Holder<Biome>)((Holder)op.get())) : ImmutableSet.of();
    }

    @Internal
    public static void makeGuess(List<? extends String> ignoredMods) {
        HashMap<ResourceLocation, List> newlyRegistered = new HashMap<ResourceLocation, List>();
        EnumMap<Biome.BiomeCategory, Function<Biome, BiomeType>> categoryToType = new EnumMap<Biome.BiomeCategory, Function<Biome, BiomeType>>(Biome.BiomeCategory.class);
        categoryToType.put(Biome.BiomeCategory.TAIGA, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_SPRUCE_FOREST : SPRUCE_FOREST);
        categoryToType.put(Biome.BiomeCategory.EXTREME_HILLS, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_MOUNTAIN : MOUNTAIN);
        categoryToType.put(Biome.BiomeCategory.JUNGLE, b -> JUNGLE);
        categoryToType.put(Biome.BiomeCategory.MESA, b -> BADLANDS);
        categoryToType.put(Biome.BiomeCategory.PLAINS, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_PLAINS : PLAINS);
        categoryToType.put(Biome.BiomeCategory.SAVANNA, b -> SAVANNA);
        categoryToType.put(Biome.BiomeCategory.ICY, b -> SNOWY);
        categoryToType.put(Biome.BiomeCategory.THEEND, b -> THE_END);
        categoryToType.put(Biome.BiomeCategory.BEACH, b -> BEACH);
        categoryToType.put(Biome.BiomeCategory.FOREST, b -> WOODED);
        categoryToType.put(Biome.BiomeCategory.OCEAN, b -> b.m_47530_() == Biome.Precipitation.SNOW ? FROZEN_OCEAN : OCEAN);
        categoryToType.put(Biome.BiomeCategory.DESERT, b -> DESERT);
        categoryToType.put(Biome.BiomeCategory.RIVER, b -> RIVER);
        categoryToType.put(Biome.BiomeCategory.SWAMP, b -> SWAMP);
        categoryToType.put(Biome.BiomeCategory.MUSHROOM, b -> MUSHROOM);
        categoryToType.put(Biome.BiomeCategory.NETHER, b -> THE_NETHER);
        HashMap<BiomeDictionary.Type, Function<Biome, BiomeType>> forgeToType = new HashMap<BiomeDictionary.Type, Function<Biome, BiomeType>>();
        forgeToType.put(BiomeDictionary.Type.BEACH, b -> BEACH);
        forgeToType.put(BiomeDictionary.Type.CONIFEROUS, b -> CONIFEROUS_FOREST);
        forgeToType.put(BiomeDictionary.Type.DEAD, b -> DEAD);
        forgeToType.put(BiomeDictionary.Type.DRY, b -> DRY);
        forgeToType.put(BiomeDictionary.Type.FOREST, b -> WOODED);
        forgeToType.put(BiomeDictionary.Type.HOT, b -> HOT);
        forgeToType.put(BiomeDictionary.Type.JUNGLE, b -> JUNGLE);
        forgeToType.put(BiomeDictionary.Type.MAGICAL, b -> MAGICAL);
        forgeToType.put(BiomeDictionary.Type.MESA, b -> BADLANDS);
        forgeToType.put(BiomeDictionary.Type.MOUNTAIN, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_MOUNTAIN : MOUNTAIN);
        forgeToType.put(BiomeDictionary.Type.MUSHROOM, b -> MUSHROOM);
        forgeToType.put(BiomeDictionary.Type.OCEAN, b -> b.m_47530_() == Biome.Precipitation.SNOW ? FROZEN_OCEAN : OCEAN);
        forgeToType.put(BiomeDictionary.Type.PLAINS, b -> b.m_47530_() == Biome.Precipitation.SNOW ? SNOWY_PLAINS : PLAINS);
        forgeToType.put(BiomeDictionary.Type.RARE, b -> RARE);
        forgeToType.put(BiomeDictionary.Type.RIVER, b -> RIVER);
        forgeToType.put(BiomeDictionary.Type.SANDY, b -> SANDY);
        forgeToType.put(BiomeDictionary.Type.SAVANNA, b -> SAVANNA);
        forgeToType.put(BiomeDictionary.Type.SNOWY, b -> SNOWY);
        forgeToType.put(BiomeDictionary.Type.SPOOKY, b -> SPOOKY);
        forgeToType.put(BiomeDictionary.Type.SWAMP, b -> SWAMP);
        forgeToType.put(BiomeDictionary.Type.VOID, b -> VOID);
        forgeToType.put(BiomeDictionary.Type.WASTELAND, b -> DEAD);
        forgeToType.put(BiomeDictionary.Type.OVERWORLD, b -> OVERWORLD);
        forgeToType.put(BiomeDictionary.Type.NETHER, b -> THE_NETHER);
        forgeToType.put(BiomeDictionary.Type.END, b -> THE_END);
        HashMap<String, BiomeType> nameToType = new HashMap<String, BiomeType>();
        nameToType.put("frozen", FROZEN);
        nameToType.put("snowy", SNOWY);
        nameToType.put("redwood", REDWOOD_FOREST);
        nameToType.put("coniferous", CONIFEROUS_FOREST);
        nameToType.put("bamboo", BAMBOO);
        nameToType.put("flower", FLOWERY);
        nameToType.put("tulip", FLOWERY);
        nameToType.put("orchid", FLOWERY);
        nameToType.put("dandelion", FLOWERY);
        nameToType.put("allium", FLOWERY);
        nameToType.put("poppy", FLOWERY);
        nameToType.put("daisy", FLOWERY);
        nameToType.put("lilac", FLOWERY);
        nameToType.put("peony", FLOWERY);
        nameToType.put("lavender", FLOWERY);
        nameToType.put("ocean", OCEAN);
        nameToType.put("river", RIVER);
        nameToType.put("beach", BEACH);
        nameToType.put("shroom", MUSHROOM);
        nameToType.put("fungal", FUNGAL);
        nameToType.put("seasonal", AUTUMN_FOREST);
        nameToType.put("autumn", AUTUMN_FOREST);
        nameToType.put("tropic", TROPICAL);
        nameToType.put("cave", CAVE);
        String hot = "hot";
        String warm = "warm";
        String frozen = "frozen";
        String cold = "cold";
        BiConsumer<BiomeType, Holder> addBiome = (type, holder) -> {
            type.addBiome((Holder<Biome>)holder);
            newlyRegistered.computeIfAbsent(((Biome)holder.m_203334_()).getRegistryName(), name -> new ArrayList()).add(type);
        };
        ForgeRegistries.BIOMES.getValues().stream().filter(biome -> {
            ResourceLocation name = biome.getRegistryName();
            return name != null && !ignoredMods.contains(name.m_135827_());
        }).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BIOMES).getHolder(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(holder -> !BiomeDictionary.getAllTypes((Holder<Biome>)holder).stream().filter(type -> !type.ignoreForGuess()).findAny().isPresent()).forEach(holder -> {
            float t;
            Biome biome = (Biome)holder.m_203334_();
            Function categoryFunc = (Function)categoryToType.get(Biome.m_204183_((Holder)holder));
            if (categoryFunc != null) {
                addBiome.accept((BiomeType)categoryFunc.apply(biome), (Holder)holder);
            }
            ResourceLocation registryName = biome.getRegistryName();
            String name = registryName.m_135815_();
            if (!ALL_BIOMES.m_203333_((Holder<Biome>)holder)) {
                ALL_BIOMES.add((Holder<Biome>)holder);
            }
            if ((t = biome.m_47554_()) <= 0.05f) {
                if (!name.contains(hot) && !name.contains(warm)) {
                    addBiome.accept(SNOWY, (Holder)holder);
                }
            } else if (t <= 0.25f) {
                if (!name.contains(hot) && !name.contains(warm)) {
                    addBiome.accept(COLD, (Holder)holder);
                }
            } else if (t <= 1.0f) {
                addBiome.accept(NEUTRAL_TEMP, (Holder)holder);
            } else if (t <= 1.5f) {
                if (!name.contains(frozen) && !name.contains(cold)) {
                    addBiome.accept(WARM, (Holder)holder);
                }
            } else if (!name.contains(frozen) && !name.contains(cold)) {
                addBiome.accept(HOT, (Holder)holder);
            }
            if (biome.m_47533_()) {
                addBiome.accept(HUMID, (Holder)holder);
            }
            switch (biome.m_47530_()) {
                case NONE: {
                    addBiome.accept(DRY, (Holder)holder);
                    break;
                }
                case SNOW: {
                    addBiome.accept(SNOWY, (Holder)holder);
                    break;
                }
            }
            net.minecraftforge.common.BiomeDictionary.getTypes((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)registryName)).forEach(type -> {
                Function biomeTypeGetter = (Function)forgeToType.get(type);
                if (biomeTypeGetter != null) {
                    addBiome.accept((BiomeType)biomeTypeGetter.apply(biome), (Holder)holder);
                }
            });
            nameToType.forEach((string, type) -> {
                if (name.contains((CharSequence)string)) {
                    addBiome.accept((BiomeType)type, (Holder)holder);
                }
            });
        });
        BIOME_TO_BIOMETYPE_CACHE.clear();
        newlyRegistered.forEach((name, types) -> StructureGelMod.log("Registered {} to [{}]", name, String.join((CharSequence)", ", types.stream().map(type -> type.getRegistryName().toString()).sorted().collect(Collectors.toSet()))));
    }
}

