/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.flagged_schema_block;

import bottomtextdanny.braincell.mod.network.BCPacket;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import bottomtextdanny.flagged_schema_block.ClientSchemaMakerEntry;
import bottomtextdanny.flagged_schema_block.FlaggedSchemaBlockEntity;
import bottomtextdanny.flagged_schema_block.MSGUpdateClientFlaggedSchemaBlock;
import bottomtextdanny.flagged_schema_block.SerializableSchemaMakerEntry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGUpdateServerFlaggedSchemaBlock
implements BCPacket<MSGUpdateServerFlaggedSchemaBlock> {
    private final long blockEntity;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private List<ClientSchemaMakerEntry> clientEntries;
    private Map<Block, SerializableSchemaMakerEntry> serverEntries;

    public MSGUpdateServerFlaggedSchemaBlock(long blockEntity, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int offsetX, int offsetY, int offsetZ) {
        this.blockEntity = blockEntity;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public void setClientEntries(List<ClientSchemaMakerEntry> clientEntries) {
        this.clientEntries = clientEntries;
    }

    public void serialize(FriendlyByteBuf stream) {
        stream.writeLong(this.blockEntity);
        stream.m_130130_(this.posX);
        stream.m_130130_(this.posY);
        stream.m_130130_(this.posZ);
        stream.m_130130_(this.sizeX);
        stream.m_130130_(this.sizeY);
        stream.m_130130_(this.sizeZ);
        stream.m_130130_(this.offsetX);
        stream.m_130130_(this.offsetY);
        stream.m_130130_(this.offsetZ);
        stream.m_130130_(this.clientEntries.size());
        for (ClientSchemaMakerEntry en : this.clientEntries) {
            boolean hasProperties = en.getProperties() != null;
            boolean hasFlags = en.getFlags() != null;
            stream.m_130130_(Registry.f_122824_.m_7447_((Object)en.getBlock()));
            stream.m_130070_(en.getName());
            stream.m_130130_(hasProperties ? en.getProperties().size() : -1);
            if (hasProperties) {
                en.getProperties().forEach(arg_0 -> ((FriendlyByteBuf)stream).m_130070_(arg_0));
            }
            stream.writeBoolean(hasFlags);
            if (!hasFlags) continue;
            stream.m_130089_(en.getFlags().toIntArray());
        }
    }

    public MSGUpdateServerFlaggedSchemaBlock deserialize(FriendlyByteBuf stream) {
        MSGUpdateServerFlaggedSchemaBlock packet = null;
        LinkedHashMap entryMap = null;
        try {
            packet = new MSGUpdateServerFlaggedSchemaBlock(stream.readLong(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_());
            LinkedHashMap local = Maps.newLinkedHashMap();
            int size = stream.m_130242_();
            for (int i = 0; i < size; ++i) {
                Block blockId = (Block)Registry.f_122824_.m_7942_(stream.m_130242_());
                String name = stream.m_130277_();
                ArrayList properties = Lists.newArrayList();
                int propertiesSize = stream.m_130242_();
                if (propertiesSize != -1) {
                    for (int j = 0; j < propertiesSize; ++j) {
                        properties.add(stream.m_130277_());
                    }
                }
                boolean hasFlags = stream.readBoolean();
                IntArrayList flags = new IntArrayList();
                if (hasFlags) {
                    int[] rawFlags = stream.m_130100_();
                    flags.addAll(Arrays.stream(rawFlags).boxed().toList());
                }
                local.put(blockId, new SerializableSchemaMakerEntry(name, properties, (IntList)flags));
            }
            entryMap = local;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (packet != null) {
            packet.serverEntries = entryMap;
        }
        return packet;
    }

    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        BlockEntity blockEntity;
        if (this.serverEntries != null && (blockEntity = world.m_7702_(BlockPos.m_122022_((long)this.blockEntity))) instanceof FlaggedSchemaBlockEntity) {
            FlaggedSchemaBlockEntity be = (FlaggedSchemaBlockEntity)blockEntity;
            be.setBoxPosition(this.posX, this.posY, this.posZ);
            be.setSize(this.sizeX, this.sizeY, this.sizeZ);
            be.setOffset(this.offsetX, this.offsetY, this.offsetZ);
            be.setEntryMap(this.serverEntries);
            MSGUpdateClientFlaggedSchemaBlock clientPacket = new MSGUpdateClientFlaggedSchemaBlock(this.blockEntity, this.posX, this.posY, this.posZ, this.sizeX, this.sizeY, this.sizeZ, this.offsetX, this.offsetY, this.offsetZ);
            clientPacket.setServerEntries(this.serverEntries);
            if (be.m_58904_() != null) {
                clientPacket.sendTo(PacketDistributor.TRACKING_CHUNK.with(() -> be.m_58904_().m_46745_(be.m_58899_())));
            }
        }
    }

    public LogicalSide side() {
        return LogicalSide.SERVER;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

