/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.flagged_schema_block;

import bottomtextdanny.braincell.mod.network.BCPacket;
import bottomtextdanny.dannys_expansion._base.network.DEPacketInitialization;
import bottomtextdanny.flagged_schema_block.FlaggedSchemaBlockEntity;
import bottomtextdanny.flagged_schema_block.SerializableSchemaMakerEntry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class MSGUpdateClientFlaggedSchemaBlock
implements BCPacket<MSGUpdateClientFlaggedSchemaBlock> {
    private final long blockEntity;
    private final int posX;
    private final int posY;
    private final int posZ;
    private final int sizeX;
    private final int sizeY;
    private final int sizeZ;
    private final int offsetX;
    private final int offsetY;
    private final int offsetZ;
    private Map<Block, SerializableSchemaMakerEntry> serverEntries;
    private Map<Block, SerializableSchemaMakerEntry> clientEntries;

    public MSGUpdateClientFlaggedSchemaBlock(long blockEntity, int posX, int posY, int posZ, int sizeX, int sizeY, int sizeZ, int offsetX, int offsetY, int offsetZ) {
        this.blockEntity = blockEntity;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.sizeX = sizeX;
        this.sizeY = sizeY;
        this.sizeZ = sizeZ;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
    }

    public void setServerEntries(Map<Block, SerializableSchemaMakerEntry> serverEntries) {
        this.serverEntries = serverEntries;
    }

    public void serialize(FriendlyByteBuf stream) {
        stream.writeLong(this.blockEntity);
        stream.m_130130_(this.posX);
        stream.m_130130_(this.posY);
        stream.m_130130_(this.posZ);
        stream.m_130130_(this.sizeX);
        stream.m_130130_(this.sizeY);
        stream.m_130130_(this.sizeZ);
        stream.m_130130_(this.offsetX);
        stream.m_130130_(this.offsetY);
        stream.m_130130_(this.offsetZ);
        stream.m_130130_(this.serverEntries.size());
        for (Map.Entry<Block, SerializableSchemaMakerEntry> en : this.serverEntries.entrySet()) {
            Block block = en.getKey();
            SerializableSchemaMakerEntry entry = en.getValue();
            boolean hasProperties = entry.properties() != null;
            boolean hasFlags = entry.flags() != null;
            stream.m_130130_(Registry.f_122824_.m_7447_((Object)block));
            stream.m_130070_(entry.name());
            stream.m_130130_(hasProperties ? entry.properties().size() : -1);
            if (hasProperties) {
                entry.properties().forEach(arg_0 -> ((FriendlyByteBuf)stream).m_130070_(arg_0));
            }
            stream.writeBoolean(hasFlags);
            if (!hasFlags) continue;
            stream.m_130089_(entry.flags().toIntArray());
        }
    }

    public MSGUpdateClientFlaggedSchemaBlock deserialize(FriendlyByteBuf stream) {
        MSGUpdateClientFlaggedSchemaBlock packet = null;
        IdentityHashMap entryMap = null;
        try {
            packet = new MSGUpdateClientFlaggedSchemaBlock(stream.readLong(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_(), stream.m_130242_());
            IdentityHashMap local = Maps.newIdentityHashMap();
            int size = stream.m_130242_();
            for (int i = 0; i < size; ++i) {
                Block blockId = (Block)Registry.f_122824_.m_7942_(stream.m_130242_());
                String name = stream.m_130277_();
                ArrayList properties = Lists.newArrayList();
                int propertiesSize = stream.m_130242_();
                if (propertiesSize != -1) {
                    for (int j = 0; j < propertiesSize; ++j) {
                        properties.add(stream.m_130277_());
                    }
                }
                boolean hasFlags = stream.readBoolean();
                IntArrayList flags = new IntArrayList();
                if (hasFlags) {
                    int[] rawFlags = stream.m_130100_();
                    flags.addAll(Arrays.stream(rawFlags).boxed().toList());
                }
                local.put(blockId, new SerializableSchemaMakerEntry(name, properties, (IntList)flags));
            }
            entryMap = local;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (packet != null) {
            packet.clientEntries = entryMap;
        }
        return packet;
    }

    public void postDeserialization(NetworkEvent.Context ctx, Level world) {
        BlockEntity blockEntity;
        if (this.clientEntries != null && (blockEntity = world.m_7702_(BlockPos.m_122022_((long)this.blockEntity))) instanceof FlaggedSchemaBlockEntity) {
            FlaggedSchemaBlockEntity be = (FlaggedSchemaBlockEntity)blockEntity;
            be.setBoxPosition(this.posX, this.posY, this.posZ);
            be.setSize(this.sizeX, this.sizeY, this.sizeZ);
            be.setOffset(this.offsetX, this.offsetY, this.offsetZ);
            be.setEntryMap(this.clientEntries);
        }
    }

    public LogicalSide side() {
        return LogicalSide.CLIENT;
    }

    public SimpleChannel mainChannel() {
        return DEPacketInitialization.CHANNEL;
    }
}

