/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.flagged_schema_block;

import bottomtextdanny.braincell.mod.PropertyMap;
import bottomtextdanny.braincell.mod.gui.BCScreen;
import bottomtextdanny.braincell.mod.gui.EditableText;
import bottomtextdanny.flagged_schema_block.ClientSchemaMakerEntry;
import bottomtextdanny.flagged_schema_block.FlaggedEntriesWidget;
import bottomtextdanny.flagged_schema_block.FlaggedSchemaBlockEntity;
import bottomtextdanny.flagged_schema_block.MSGUpdateServerFlaggedSchemaBlock;
import bottomtextdanny.flagged_schema_block.SerializableSchemaMakerEntry;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableInt;

public class FlaggedSchemaScreen
extends BCScreen {
    private static final Gson PARSER = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    private static final Component C_POSITION = new TranslatableComponent("flagged_schema_maker.position");
    private static final Component C_SIZE = new TranslatableComponent("flagged_schema_maker.size");
    private static final Component C_OFFSET = new TranslatableComponent("flagged_schema_maker.offset");
    private static final Component C_TITLE = new TranslatableComponent("flagged_schema");
    private static final Component C_SAVE = new TranslatableComponent("flagged_schema_maker.save");
    private static final Component C_PARSE = new TranslatableComponent("flagged_schema_maker.parse");
    private EditableText posXEdit;
    private EditableText posYEdit;
    private EditableText posZEdit;
    private EditableText sizeXEdit;
    private EditableText sizeYEdit;
    private EditableText sizeZEdit;
    private EditableText offsetXEdit;
    private EditableText offsetYEdit;
    private EditableText offsetZEdit;
    private Button saveButton;
    private Button parseToClipboardButton;
    private FlaggedEntriesWidget entriesWidget;
    private final FlaggedSchemaBlockEntity blockEntity;
    private List<ClientSchemaMakerEntry> fakeEntries;

    public FlaggedSchemaScreen(FlaggedSchemaBlockEntity blockEntity) {
        super(C_TITLE);
        this.f_96541_ = Minecraft.m_91087_();
        this.blockEntity = blockEntity;
        this.fakeEntries = FlaggedSchemaScreen.createClientEntries(blockEntity);
    }

    protected void m_7856_() {
        super.m_7856_();
        Function<String, String> intProcessor = this.integerInput(511);
        Function<String, String> signedIntProcessor = this.signedIntegerInput(511);
        int widthBy3 = this.f_96543_ / 3;
        int buttonPosOffsetY = 24;
        int buttonSizeOffsetY = 104;
        int buttonOffsetOffsetY = 184;
        int buttonsOffsetY = 256;
        this.posXEdit = new EditableText(this.f_96547_, 0, buttonPosOffsetY, 80, (Component)new TextComponent("X"));
        this.posXEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxPosX()));
        this.posXEdit.setTextProcessor(signedIntProcessor);
        this.m_7787_((GuiEventListener)this.posXEdit);
        this.posYEdit = new EditableText(this.f_96547_, 0, buttonPosOffsetY + 20, 80, (Component)new TextComponent("Y"));
        this.posYEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxPosY()));
        this.posYEdit.setTextProcessor(signedIntProcessor);
        this.m_7787_((GuiEventListener)this.posYEdit);
        this.posZEdit = new EditableText(this.f_96547_, 0, buttonPosOffsetY + 40, 80, (Component)new TextComponent("Z"));
        this.posZEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxPosZ()));
        this.posZEdit.setTextProcessor(signedIntProcessor);
        this.m_7787_((GuiEventListener)this.posZEdit);
        this.sizeXEdit = new EditableText(this.f_96547_, 0, buttonSizeOffsetY, 80, (Component)new TextComponent("X"));
        this.sizeXEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxSizeX()));
        this.sizeXEdit.setTextProcessor(intProcessor);
        this.m_7787_((GuiEventListener)this.sizeXEdit);
        this.sizeYEdit = new EditableText(this.f_96547_, 0, buttonSizeOffsetY + 20, 80, (Component)new TextComponent("Y"));
        this.sizeYEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxSizeY()));
        this.sizeYEdit.setTextProcessor(intProcessor);
        this.m_7787_((GuiEventListener)this.sizeYEdit);
        this.sizeZEdit = new EditableText(this.f_96547_, 0, buttonSizeOffsetY + 40, 80, (Component)new TextComponent("Z"));
        this.sizeZEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxSizeZ()));
        this.sizeZEdit.setTextProcessor(intProcessor);
        this.m_7787_((GuiEventListener)this.sizeZEdit);
        this.offsetXEdit = new EditableText(this.f_96547_, 0, buttonOffsetOffsetY, 80, (Component)new TextComponent("X"));
        this.offsetXEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxOffsetX()));
        this.offsetXEdit.setTextProcessor(signedIntProcessor);
        this.m_7787_((GuiEventListener)this.offsetXEdit);
        this.offsetYEdit = new EditableText(this.f_96547_, 0, buttonOffsetOffsetY + 20, 80, (Component)new TextComponent("Y"));
        this.offsetYEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxOffsetY()));
        this.offsetYEdit.setTextProcessor(signedIntProcessor);
        this.m_7787_((GuiEventListener)this.offsetYEdit);
        this.offsetZEdit = new EditableText(this.f_96547_, 0, buttonOffsetOffsetY + 40, 80, (Component)new TextComponent("Z"));
        this.offsetZEdit.setCurrentText(Integer.toString(this.blockEntity.getBoxOffsetZ()));
        this.offsetZEdit.setTextProcessor(signedIntProcessor);
        this.m_7787_((GuiEventListener)this.offsetZEdit);
        this.saveButton = new Button(0, buttonsOffsetY, 40, 20, C_SAVE, b -> this.save());
        this.m_7787_((GuiEventListener)this.saveButton);
        this.parseToClipboardButton = new Button(0, this.f_96544_ - 20, Math.min(120, widthBy3), 20, C_PARSE, b -> this.copyAsJSON());
        this.m_7787_((GuiEventListener)this.parseToClipboardButton);
        this.entriesWidget = new FlaggedEntriesWidget(widthBy3, 0, widthBy3, this.f_96544_, this.fakeEntries);
        this.m_7787_((GuiEventListener)this.entriesWidget);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String posX = this.posXEdit.getCurrentText();
        String posY = this.posYEdit.getCurrentText();
        String posZ = this.posZEdit.getCurrentText();
        String sizeX = this.sizeXEdit.getCurrentText();
        String sizeY = this.sizeYEdit.getCurrentText();
        String sizeZ = this.sizeZEdit.getCurrentText();
        String offsetX = this.offsetXEdit.getCurrentText();
        String offsetY = this.offsetYEdit.getCurrentText();
        String offsetZ = this.offsetZEdit.getCurrentText();
        List<ClientSchemaMakerEntry> entries = this.entriesWidget.getEntries();
        int entryIndex = this.entriesWidget.getEntryPointer();
        this.m_6575_(minecraft, width, height);
        this.posXEdit.setCurrentText(posX);
        this.posYEdit.setCurrentText(posY);
        this.posZEdit.setCurrentText(posZ);
        this.sizeXEdit.setCurrentText(sizeX);
        this.sizeYEdit.setCurrentText(sizeY);
        this.sizeZEdit.setCurrentText(sizeZ);
        this.offsetXEdit.setCurrentText(offsetX);
        this.offsetYEdit.setCurrentText(offsetY);
        this.offsetZEdit.setCurrentText(offsetZ);
        this.entriesWidget.setEntries(entries);
        this.entriesWidget.setEntryPointer(entryIndex);
    }

    public void copyAsJSON() {
        this.save();
        if (this.blockEntity.m_58904_() == null) {
            return;
        }
        int posX = this.getInteger(this.posXEdit);
        int posY = this.getInteger(this.posYEdit);
        int posZ = this.getInteger(this.posZEdit);
        int sizeX = this.getInteger(this.sizeXEdit);
        int sizeY = this.getInteger(this.sizeYEdit);
        int sizeZ = this.getInteger(this.sizeZEdit);
        int offsetX = this.getInteger(this.offsetXEdit);
        int offsetY = this.getInteger(this.offsetYEdit);
        int offsetZ = this.getInteger(this.offsetZEdit);
        JsonObject root = new JsonObject();
        JsonArray baseSerial = new JsonArray();
        JsonArray entriesSerial = new JsonArray();
        JsonArray propertyEntriesSerial = new JsonArray();
        JsonArray blockPositionsSerial = new JsonArray();
        root.add("ba", (JsonElement)baseSerial);
        root.add("en", (JsonElement)entriesSerial);
        root.add("prop", (JsonElement)propertyEntriesSerial);
        root.add("bp", (JsonElement)blockPositionsSerial);
        baseSerial.add((Number)posX);
        baseSerial.add((Number)posY);
        baseSerial.add((Number)posZ);
        baseSerial.add((Number)sizeX);
        baseSerial.add((Number)sizeY);
        baseSerial.add((Number)sizeZ);
        baseSerial.add((Number)offsetX);
        baseSerial.add((Number)offsetY);
        baseSerial.add((Number)offsetZ);
        List<ClientSchemaMakerEntry> entries = this.entriesWidget.getEntries();
        for (ClientSchemaMakerEntry en2 : entries) {
            JsonObject entrySerial = new JsonObject();
            JsonArray flagArr = new JsonArray();
            entrySerial.add("na", (JsonElement)new JsonPrimitive(en2.getName()));
            entrySerial.add("fl", (JsonElement)flagArr);
            if (en2.getFlags() != null) {
                int[] flagIntArray;
                for (int flag : flagIntArray = en2.getFlags().toIntArray()) {
                    flagArr.add((Number)flag);
                }
            }
            entriesSerial.add((JsonElement)entrySerial);
        }
        HashBiMap indexedProperties = HashBiMap.create((int)32);
        IdentityHashMap propertyEntries = Maps.newIdentityHashMap();
        BlockPos startPos = this.blockEntity.m_58899_().m_142082_(posX, posY, posZ);
        BlockPos offsetPos = BlockPos.f_121853_.m_142022_(Math.floor(((double)sizeX - 1.0) / 2.0) + (double)offsetX, (double)offsetY, Math.floor(((double)sizeZ - 1.0) / 2.0) + (double)offsetZ);
        BlockPos.MutableBlockPos worldPos = new BlockPos.MutableBlockPos();
        for (int x = 0; x <= sizeX; ++x) {
            for (int z = 0; z <= sizeZ; ++z) {
                for (int y = 0; y <= sizeY; ++y) {
                    worldPos.m_122178_(x + startPos.m_123341_(), y + startPos.m_123342_(), z + startPos.m_123343_());
                    BlockState blockState = this.blockEntity.m_58904_().m_8055_((BlockPos)worldPos);
                    ClientSchemaMakerEntry lEntry = this.entriesWidget.getEntryByBlock(blockState.m_60734_());
                    if (lEntry == null) continue;
                    LinkedList propertyIndices = Lists.newLinkedList();
                    if (lEntry.getProperties() != null) {
                        for (String s : lEntry.getProperties()) {
                            PropertyData data;
                            Property asProperty = PropertyMap.getProperty((String)s);
                            if (asProperty == null || !blockState.m_61138_(asProperty)) continue;
                            String propertyValue = FlaggedSchemaScreen.forceGetName(asProperty, blockState.m_61143_(asProperty));
                            if (!indexedProperties.containsKey((Object)asProperty)) {
                                indexedProperties.put((Object)asProperty, (Object)indexedProperties.size());
                            }
                            if (!propertyEntries.containsKey(asProperty)) {
                                data = new PropertyData(s, Maps.newHashMap());
                                propertyEntries.put(asProperty, data);
                            } else {
                                data = (PropertyData)propertyEntries.get(asProperty);
                            }
                            if (!data.values().containsKey(propertyValue)) {
                                data.values().put(propertyValue, data.values().size());
                            }
                            propertyIndices.add((Integer)indexedProperties.get((Object)asProperty));
                            propertyIndices.add(data.values().get(propertyValue));
                        }
                    }
                    JsonArray posSerial = new JsonArray();
                    posSerial.add((Number)(x - offsetPos.m_123341_()));
                    posSerial.add((Number)(y - offsetPos.m_123342_()));
                    posSerial.add((Number)(z - offsetPos.m_123343_()));
                    posSerial.add((Number)lEntry.getIndex());
                    for (Integer i : propertyIndices) {
                        posSerial.add((Number)i);
                    }
                    blockPositionsSerial.add((JsonElement)posSerial);
                }
            }
        }
        ArrayList sorted = Lists.newArrayList();
        sorted.addAll(indexedProperties.entrySet());
        sorted.sort(Comparator.comparingInt(Map.Entry::getValue));
        sorted.forEach(en -> {
            JsonObject propertyObject = new JsonObject();
            JsonArray valuesArr = new JsonArray();
            PropertyData data = (PropertyData)propertyEntries.get(en.getKey());
            data.values().entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).forEach(value -> valuesArr.add((JsonElement)new JsonPrimitive((String)value.getKey())));
            propertyObject.add("id", (JsonElement)new JsonPrimitive(data.name));
            propertyObject.add("val", (JsonElement)valuesArr);
            propertyEntriesSerial.add((JsonElement)propertyObject);
        });
        String parsed = PARSER.toJson((JsonElement)root);
        Minecraft.m_91087_().f_91068_.m_90911_(parsed);
    }

    private static <T extends Comparable<T>> String forceGetName(Property<T> property, Object value) {
        return property.m_6940_((Comparable)value);
    }

    public void save() {
        this.entriesWidget.onSave();
        int posX = this.getInteger(this.posXEdit);
        int posY = this.getInteger(this.posYEdit);
        int posZ = this.getInteger(this.posZEdit);
        int sizeX = this.getInteger(this.sizeXEdit);
        int sizeY = this.getInteger(this.sizeYEdit);
        int sizeZ = this.getInteger(this.sizeZEdit);
        int offsetX = this.getInteger(this.offsetXEdit);
        int offsetY = this.getInteger(this.offsetYEdit);
        int offsetZ = this.getInteger(this.offsetZEdit);
        MSGUpdateServerFlaggedSchemaBlock packet = new MSGUpdateServerFlaggedSchemaBlock(this.blockEntity.m_58899_().m_121878_(), posX, posY, posZ, sizeX, sizeY, sizeZ, offsetX, offsetY, offsetZ);
        packet.setClientEntries(this.entriesWidget.getEntries());
        packet.sendToServer();
    }

    private static List<ClientSchemaMakerEntry> createClientEntries(FlaggedSchemaBlockEntity blockEntity) {
        Map<Block, SerializableSchemaMakerEntry> original = blockEntity.getEntries();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)original.size());
        MutableInt counter = new MutableInt();
        original.forEach((block, entry) -> {
            ClientSchemaMakerEntry lEntry = new ClientSchemaMakerEntry();
            lEntry.setIndex(counter.getAndIncrement());
            lEntry.setBlock((Block)block);
            lEntry.setName(entry.name());
            lEntry.setFlags(IntList.of((int[])entry.flags().toIntArray()));
            lEntry.setProperties(new ArrayList<String>(entry.properties()));
            list.add(lEntry);
        });
        return list;
    }

    private int getInteger(EditableText text) {
        if (text == null || text.getCurrentText().isEmpty()) {
            return 0;
        }
        if (text.getCurrentText().length() == 1 && !Character.isDigit(text.getCurrentText().charAt(0))) {
            return 0;
        }
        return Integer.parseInt(text.getCurrentText());
    }

    public void m_7861_() {
        this.f_96541_.f_91068_.m_90926_(false);
    }

    public void m_96624_() {
        super.m_96624_();
        this.entriesWidget.tick();
        this.posXEdit.tick();
        this.posYEdit.tick();
        this.posZEdit.tick();
        this.sizeXEdit.tick();
        this.sizeYEdit.tick();
        this.sizeZEdit.tick();
        this.offsetXEdit.tick();
        this.offsetYEdit.tick();
        this.offsetZEdit.tick();
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float tickOffset) {
        this.m_7333_(pose);
        int widthBy2 = this.f_96543_ / 3;
        String label = this.f_96547_.m_92834_(C_POSITION.getString(), widthBy2);
        this.entriesWidget.m_6305_(pose, mouseX, mouseY, tickOffset);
        FlaggedSchemaScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)label, (int)0, (int)10, (int)-4144960);
        this.posXEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.posYEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.posZEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        label = this.f_96547_.m_92834_(C_SIZE.getString(), widthBy2);
        FlaggedSchemaScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)label, (int)0, (int)90, (int)-4144960);
        this.sizeXEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.sizeYEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.sizeZEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        label = this.f_96547_.m_92834_(C_OFFSET.getString(), widthBy2);
        FlaggedSchemaScreen.m_93236_((PoseStack)pose, (Font)this.f_96547_, (String)label, (int)0, (int)170, (int)-4144960);
        this.offsetXEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.offsetYEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.offsetZEdit.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.saveButton.m_6305_(pose, mouseX, mouseY, tickOffset);
        this.parseToClipboardButton.m_6305_(pose, mouseX, mouseY, tickOffset);
        super.m_6305_(pose, mouseX, mouseY, tickOffset);
    }

    private Function<String, String> integerInput(int maxValue) {
        return str -> {
            String parsed = "";
            try {
                StringBuilder builder = new StringBuilder();
                str.chars().filter(Character::isDigit).forEach(i -> builder.append((char)i));
                parsed = String.valueOf(Math.min(maxValue, Integer.valueOf(builder.toString(), 10)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return parsed;
        };
    }

    private Function<String, String> signedIntegerInput(int maxValue) {
        return str -> {
            String parsed = "";
            try {
                StringBuilder builder = new StringBuilder();
                MutableInt counter = new MutableInt();
                str.chars().boxed().filter(i -> {
                    int index = counter.getAndIncrement();
                    return index == 0 && ((char)i.intValue() == '-' || (char)i.intValue() == '+') || Character.isDigit(i);
                }).forEach(i -> builder.append((char)i.intValue()));
                parsed = builder.toString();
                if (parsed.length() > 1 || !parsed.isEmpty() && Character.isDigit(parsed.charAt(0))) {
                    parsed = String.valueOf(Math.min(maxValue, Integer.parseInt(parsed)));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return parsed;
        };
    }

    public boolean m_7043_() {
        return false;
    }

    private record PropertyData(String name, Map<String, Integer> values) {
    }
}

