/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.flagged_schema_block;

import bottomtextdanny.dannys_expansion.tables.DEBlockEntities;
import bottomtextdanny.flagged_schema_block.FlaggedSchemaScreen;
import bottomtextdanny.flagged_schema_block.SerializableSchemaMakerEntry;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeBlockEntity;

public class FlaggedSchemaBlockEntity
extends BlockEntity {
    private String T_SHOW = "show";
    private String T_POSITION = "posi";
    private String T_ENTRIES = "entr";
    private String T_BLOCK_ID = "bk";
    private int boxPosX = 1;
    private int boxPosY = 0;
    private int boxPosZ = 1;
    private int boxSizeX = 5;
    private int boxSizeY = 5;
    private int boxSizeZ = 5;
    private int boxOffsetX = 0;
    private int boxOffsetY = 0;
    private int boxOffsetZ = 0;
    private boolean show = true;
    private Map<Block, SerializableSchemaMakerEntry> entries = Maps.newIdentityHashMap();

    public FlaggedSchemaBlockEntity(BlockPos position, BlockState blockState) {
        super((BlockEntityType)DEBlockEntities.FLAGGED_SCHEMA_BLOCK.get(), position, blockState);
    }

    protected void m_183515_(CompoundTag tagMap) {
        ListTag serializedEntries = new ListTag();
        tagMap.m_128379_(this.T_SHOW, this.show);
        tagMap.m_128385_(this.T_POSITION, new int[]{this.boxPosX, this.boxPosY, this.boxPosZ, this.boxSizeX, this.boxSizeY, this.boxSizeZ, this.boxOffsetX, this.boxOffsetY, this.boxOffsetZ});
        this.entries.forEach((block, entry) -> {
            CompoundTag entryTag = entry.getTag();
            entryTag.m_128405_(this.T_BLOCK_ID, Registry.f_122824_.m_7447_(block));
            serializedEntries.add((Object)entryTag);
        });
        tagMap.m_128365_(this.T_ENTRIES, (Tag)serializedEntries);
        super.m_183515_(tagMap);
    }

    public void m_142466_(CompoundTag tagMap) {
        int[] position = tagMap.m_128465_(this.T_POSITION);
        this.boxPosX = position[0];
        this.boxPosY = position[1];
        this.boxPosZ = position[2];
        this.boxSizeX = position[3];
        this.boxSizeY = position[4];
        this.boxSizeZ = position[5];
        this.boxOffsetX = position[6];
        this.boxOffsetY = position[7];
        this.boxOffsetZ = position[8];
        this.show = tagMap.m_128471_(this.T_SHOW);
        this.entries = Maps.newIdentityHashMap();
        ListTag serializedEntries = tagMap.m_128437_(this.T_ENTRIES, 10);
        serializedEntries.stream().map(t -> (CompoundTag)t).forEach(tag -> {
            Block block = (Block)Registry.f_122824_.m_7942_(tag.m_128451_(this.T_BLOCK_ID));
            this.entries.put(block, SerializableSchemaMakerEntry.fromCompoundTag(tag));
        });
        super.m_142466_(tagMap);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public boolean usedBy(Player player) {
        if (!player.m_36337_()) {
            return false;
        }
        if (player.m_20193_().f_46443_) {
            this.setClientScreen();
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    private void setClientScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new FlaggedSchemaScreen(this));
    }

    public void setEntryMap(Map<Block, SerializableSchemaMakerEntry> entries) {
        this.entries = entries;
    }

    public AABB getRenderBoundingBox() {
        return IForgeBlockEntity.INFINITE_EXTENT_AABB;
    }

    public void setBoxPosition(int x, int y, int z) {
        this.boxPosX = x;
        this.boxPosY = y;
        this.boxPosZ = z;
    }

    public void setSize(int x, int y, int z) {
        this.boxSizeX = x;
        this.boxSizeY = y;
        this.boxSizeZ = z;
    }

    public void setOffset(int x, int y, int z) {
        this.boxOffsetX = x;
        this.boxOffsetY = y;
        this.boxOffsetZ = z;
    }

    public Map<Block, SerializableSchemaMakerEntry> getEntries() {
        return this.entries;
    }

    public int getBoxPosX() {
        return this.boxPosX;
    }

    public int getBoxPosY() {
        return this.boxPosY;
    }

    public int getBoxPosZ() {
        return this.boxPosZ;
    }

    public int getBoxSizeX() {
        return this.boxSizeX;
    }

    public int getBoxSizeY() {
        return this.boxSizeY;
    }

    public int getBoxSizeZ() {
        return this.boxSizeZ;
    }

    public int getBoxOffsetX() {
        return this.boxOffsetX;
    }

    public int getBoxOffsetY() {
        return this.boxOffsetY;
    }

    public int getBoxOffsetZ() {
        return this.boxOffsetZ;
    }
}

