/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.flagged_schema_block;

import bottomtextdanny.braincell.base.BCCharacterUtil;
import bottomtextdanny.braincell.mod.PropertyMap;
import bottomtextdanny.braincell.mod.gui.BCSelectable;
import bottomtextdanny.braincell.mod.gui.BCSelector;
import bottomtextdanny.braincell.mod.gui.EditableText;
import bottomtextdanny.braincell.mod.gui.ListingBox;
import bottomtextdanny.braincell.mod.gui.TickableComponent;
import bottomtextdanny.flagged_schema_block.ClientSchemaMakerEntry;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.mutable.MutableInt;

public class FlaggedEntriesWidget
extends AbstractWidget
implements BCSelector,
BCSelectable,
TickableComponent {
    public static int ENTRY_HEIGHT = 32;
    public static int ENTRY_HEIGHT_D2 = ENTRY_HEIGHT / 2;
    public static int ENTRY_SPACING = 2;
    public static int BORDER_WIDTH = 1;
    public static int BORDER_OFFSET = BORDER_WIDTH * 2;
    private static final Component C_TITLE = new TranslatableComponent("flagged_schema_maker.entries");
    private static final Component C_DELETE = new TranslatableComponent("flagged_schema_maker.delete");
    private static final Component C_ADD = new TranslatableComponent("flagged_schema_maker.add");
    private static final Component C_BLOCK_ID = new TranslatableComponent("flagged_schema_maker.block_id");
    private static final Component C_NAME = new TranslatableComponent("flagged_schema_maker.name");
    private static final Component C_FLAGS = new TranslatableComponent("flagged_schema_maker.flags");
    private static final Component C_PROPS = new TranslatableComponent("flagged_schema_maker.properties");
    private final Map<Block, ClientSchemaMakerEntry> usedBlocks;
    private List<ClientSchemaMakerEntry> entries;
    private BCSelector screen;
    private BCSelectable selected;
    private final List<BCSelectable> selectables;
    private final EditableText blockIdBox;
    private final EditableText nameBox;
    private final EditableText flagsBox;
    private final ListingBox propertiesBox;
    private final Button deleteButton;
    private final Button addButton;
    private final int fontHeightD2;
    private int entryPixelOffset;
    private int entryPointer = -1;
    private int newEntryBlockId = 1;

    public FlaggedEntriesWidget(int x, int y, int width, int height, List<ClientSchemaMakerEntry> entries) {
        super(x, y, width, height, C_TITLE);
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.fontHeightD2 = 9 / 2;
        this.usedBlocks = Maps.newIdentityHashMap();
        this.setEntries(entries);
        this.blockIdBox = new EditableText(Minecraft.m_91087_().f_91062_, x + width + 1, 44, width, C_BLOCK_ID);
        this.blockIdBox.setKeyActor((string, key) -> {
            if (this.isEntrySelected() && key == 257 || key == 335) {
                boolean valid = false;
                try {
                    valid = ResourceLocation.m_135830_((String)string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (valid) {
                    ResourceLocation loc = new ResourceLocation(string);
                    Registry.f_122824_.m_6612_(loc).ifPresent(block -> {
                        if (!this.usedBlocks.containsKey(block)) {
                            this.usedBlocks.remove(this.selectedEntry().getBlock());
                            this.selectedEntry().setBlock((Block)block);
                            this.usedBlocks.put((Block)block, this.selectedEntry());
                        }
                    });
                }
            }
        });
        this.blockIdBox.setColorProcessor(string -> {
            boolean valid = false;
            try {
                valid = ResourceLocation.m_135830_((String)string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!valid) {
                return -57344;
            }
            ResourceLocation loc = new ResourceLocation(string);
            if (Registry.f_122824_.m_7804_(loc)) {
                Block block = (Block)Registry.f_122824_.m_7745_(loc);
                return this.selectedEntry().getBlock() == block || !this.usedBlocks.containsKey(Registry.f_122824_.m_7745_(loc)) ? -14614784 : Short.MIN_VALUE;
            }
            return -57344;
        });
        this.blockIdBox.setWordSeparator(BCCharacterUtil.metadataSeparator());
        this.blockIdBox.attachToSelector((BCSelector)this);
        this.nameBox = new EditableText(Minecraft.m_91087_().f_91062_, x + width + 1, 84, width, C_NAME);
        this.nameBox.setTextProcessor(string -> {
            StringBuilder builder = new StringBuilder();
            string.chars().forEach(i -> {
                char ch = (char)i;
                if (ch == '_' || ch == '-' || ch >= 'a' && ch <= 'z' || ch >= '0' && ch <= '9') {
                    builder.append(ch);
                }
            });
            return builder.toString();
        });
        this.nameBox.setKeyActor((string, key) -> {
            if (this.isEntrySelected() && key == 257 || key == 335) {
                this.selectedEntry().setName((String)string);
            }
        });
        this.nameBox.attachToSelector((BCSelector)this);
        this.flagsBox = new EditableText(Minecraft.m_91087_().f_91062_, x + width + 1, 124, width, C_FLAGS);
        this.flagsBox.setTextProcessor(string -> {
            StringBuilder builder = new StringBuilder();
            string.chars().forEach(i -> {
                char ch = (char)i;
                if (Character.isDigit(ch) || ch == ' ' || ch == ',') {
                    builder.append(ch);
                }
            });
            return builder.toString();
        });
        this.flagsBox.setKeyActor((string, key) -> {
            if (this.isEntrySelected() && key == 257 || key == 335) {
                IntArrayList flagSet = new IntArrayList();
                StringBuilder builder = new StringBuilder();
                MutableInt counter = new MutableInt(0);
                string.chars().forEach(arg_0 -> FlaggedEntriesWidget.lambda$new$8(builder, counter, string, (IntList)flagSet, arg_0));
                this.selectedEntry().setFlags((IntList)flagSet);
            }
        });
        this.flagsBox.attachToSelector((BCSelector)this);
        this.propertiesBox = new ListingBox(Minecraft.m_91087_().f_91062_, x + width + 1, 164, width, C_FLAGS, false);
        this.propertiesBox.setValidator(string -> this.isEntrySelected() && PropertyMap.has((String)string));
        this.propertiesBox.setColorProcessor(string -> {
            if (this.isEntrySelected() && PropertyMap.has((String)string)) {
                return this.propertiesBox.isDuplicate(string) ? Short.MIN_VALUE : -14614784;
            }
            return -57344;
        });
        this.propertiesBox.attachToSelector((BCSelector)this);
        this.deleteButton = new Button(x + width + 1, 0, 40, 20, C_DELETE, b -> {
            if (this.isEntrySelected()) {
                this.deleteEntry(this.entryPointer);
            }
        }){

            public boolean m_142518_() {
                return super.m_142518_() && FlaggedEntriesWidget.this.isEntrySelected();
            }
        };
        this.selectables = List.of(this.blockIdBox, this.nameBox, this.flagsBox, this.propertiesBox);
        this.addButton = new Button(x - 40, y + height - 40, 40, 20, C_ADD, b -> {
            Block block = (Block)Registry.f_122824_.m_7942_(this.newEntryBlockId);
            while (this.usedBlocks.containsKey(block)) {
                this.newEntryBlockId = (this.newEntryBlockId + 1) % Registry.f_122824_.m_183450_();
                block = (Block)Registry.f_122824_.m_7942_(this.newEntryBlockId);
            }
            ClientSchemaMakerEntry newEntry = new ClientSchemaMakerEntry(block);
            newEntry.setIndex(entries.size());
            entries.add(newEntry);
            this.usedBlocks.put(block, newEntry);
        });
    }

    public void m_6305_(PoseStack pose, int x, int y, float tickOffset) {
        super.m_6305_(pose, x, y, tickOffset);
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        Font font = Minecraft.m_91087_().f_91062_;
        FlaggedEntriesWidget.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-14671840);
        StringBuilder nameBuilder = new StringBuilder();
        int startX = this.f_93620_ + BORDER_WIDTH;
        int endX = this.f_93620_ + this.f_93618_ - BORDER_WIDTH;
        int displayIndex = this.entryPixelOffset / ENTRY_HEIGHT;
        int displayOffset = -(this.entryPixelOffset % ENTRY_HEIGHT) + BORDER_WIDTH;
        int entriesDisplayed = Math.min(this.maxDisplayableEntries(), this.entries.size() - displayIndex);
        int indexDelta = 0;
        for (int i = 0; i < entriesDisplayed; ++i) {
            int extraSpacing;
            int lIndex = displayIndex + indexDelta;
            boolean lSelected = this.entryPointer == lIndex;
            int borderColor = lSelected ? -1 : -16777216;
            int entryY = this.f_93621_ + displayOffset + indexDelta * ENTRY_HEIGHT;
            ClientSchemaMakerEntry entry = this.entries.get(lIndex);
            Item asItem = entry.getBlock().m_5456_();
            FlaggedEntriesWidget.m_93172_((PoseStack)pose, (int)startX, (int)entryY, (int)endX, (int)(entryY + ENTRY_HEIGHT), (int)borderColor);
            FlaggedEntriesWidget.m_93172_((PoseStack)pose, (int)(startX + BORDER_WIDTH), (int)(entryY + BORDER_WIDTH), (int)(endX - BORDER_WIDTH), (int)(entryY + ENTRY_HEIGHT - BORDER_WIDTH), (int)-12566464);
            if (asItem != null && asItem != Items.f_41852_) {
                itemRenderer.m_115123_(new ItemStack((ItemLike)asItem.m_5456_()), startX + ENTRY_SPACING, entryY + ENTRY_HEIGHT_D2 - 8);
                extraSpacing = 16;
            } else {
                extraSpacing = 0;
            }
            nameBuilder.append(entry.getBlock().m_49954_().getString());
            nameBuilder.append(" *");
            nameBuilder.append(entry.getName());
            font.m_92883_(pose, font.m_92834_(nameBuilder.toString(), this.f_93618_ - (ENTRY_SPACING * 2 + extraSpacing) - BORDER_OFFSET), (float)(startX + ENTRY_SPACING * 2 + extraSpacing), (float)(entryY + ENTRY_HEIGHT_D2 - this.fontHeightD2), -1);
            nameBuilder.setLength(0);
            ++indexDelta;
        }
        FlaggedEntriesWidget.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + 1), (int)-1);
        FlaggedEntriesWidget.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)(this.f_93621_ + this.f_93619_ - 1), (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-1);
        FlaggedEntriesWidget.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + this.f_93619_), (int)-1);
        FlaggedEntriesWidget.m_93172_((PoseStack)pose, (int)(this.f_93620_ + this.f_93618_ - 1), (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-1);
        this.executeByChildren(l -> {
            if (l instanceof Widget) {
                Widget widget = (Widget)l;
                widget.m_6305_(pose, x, y, tickOffset);
            }
        });
    }

    public void tick() {
        this.executeByChildren(l -> {
            if (l instanceof TickableComponent) {
                TickableComponent t = (TickableComponent)l;
                t.tick();
            }
        });
    }

    public void m_94757_(double x, double y) {
        super.m_94757_(x, y);
        this.executeByChildren(l -> l.m_94757_(x, y));
    }

    public boolean m_6375_(double x, double y, int mod) {
        if (this.isSelected()) {
            if (this.inbounds(x, y) && y != (double)this.f_93621_ && y != (double)(this.f_93621_ + this.f_93619_)) {
                int displayIndex = this.entryPixelOffset / ENTRY_HEIGHT;
                int displayOffset = -(this.entryPixelOffset % ENTRY_HEIGHT) + BORDER_WIDTH;
                int entriesDisplayed = Math.min(this.maxDisplayableEntries(), this.entries.size() - displayIndex);
                int indexDelta = 0;
                for (int i = 0; i < entriesDisplayed; ++i) {
                    int lIndex = displayIndex + indexDelta;
                    if (this.inboundEntry(x, y, displayOffset + indexDelta * ENTRY_HEIGHT)) {
                        if (this.entryPointer == lIndex) break;
                        this.setEntryPointer(lIndex);
                        this.m_7435_(Minecraft.m_91087_().m_91106_());
                        break;
                    }
                    ++indexDelta;
                }
            }
            this.handleSelection(x, y, this.selectables);
            this.executeByChildren(l -> l.m_6375_(x, y, mod));
        }
        return false;
    }

    public boolean m_6348_(double x, double y, int mod) {
        this.executeByChildren(l -> l.m_6348_(x, y, mod));
        return super.m_6348_(x, y, mod);
    }

    public boolean m_7979_(double xStart, double yStart, int mod, double xEnd, double yEnd) {
        this.executeByChildren(l -> l.m_7979_(xStart, yStart, mod, xEnd, yEnd));
        return super.m_7979_(xStart, yStart, mod, xEnd, yEnd);
    }

    public boolean m_6050_(double x, double y, double offset) {
        this.setEntryPixelOffset(this.entryPixelOffset - (int)(offset * 5.0));
        this.executeByChildren(l -> l.m_6050_(x, y, offset));
        return super.m_6050_(x, y, offset);
    }

    public boolean m_7933_(int key, int p_94746_, int p_94747_) {
        this.executeByChildren(l -> {
            if (l instanceof EditableText) {
                l.m_7933_(key, p_94746_, p_94747_);
            }
        });
        return super.m_7933_(key, p_94746_, p_94747_);
    }

    public boolean m_7920_(int key, int p_94751_, int p_94752_) {
        this.executeByChildren(l -> l.m_7920_(key, p_94751_, p_94752_));
        return super.m_7920_(key, p_94751_, p_94752_);
    }

    public boolean m_5534_(char key, int p_94733_) {
        if (this.selected != null) {
            this.selected.m_5534_(key, p_94733_);
        }
        return super.m_5534_(key, p_94733_);
    }

    public boolean shouldBeSelected(int x, int y) {
        return this.inbounds(x, y);
    }

    public void onSelection() {
    }

    public void onDeselection() {
        this.entryPointer = -1;
    }

    private void forceDataUpdate() {
        this.blockIdBox.runKeyActor(257);
        this.nameBox.runKeyActor(257);
        this.flagsBox.runKeyActor(257);
        this.propertiesBox.runKeyActor(257);
    }

    public void onSave() {
        if (this.isEntrySelected()) {
            this.forceDataUpdate();
        }
    }

    public void attachToSelector(BCSelector selector) {
        this.screen = selector;
    }

    public void setEntryPointer(int entryPointer) {
        this.changeSelected(null);
        if (this.entries.isEmpty()) {
            this.entryPointer = -1;
        } else {
            boolean changed;
            int old = this.entryPointer;
            int newPointer = Mth.m_14045_((int)entryPointer, (int)0, (int)(this.entries.size() - 1));
            boolean bl = changed = old >= 0 && old < this.entries.size() && old != newPointer;
            if (changed) {
                this.forceDataUpdate();
            }
            this.entryPointer = newPointer;
            ClientSchemaMakerEntry entry = this.selectedEntry();
            this.blockIdBox.setCurrentText(entry.getBlock().getRegistryName().toString());
            this.nameBox.setCurrentText(entry.getName());
            if (entry.getFlags() != null) {
                this.flagsBox.setCurrentText(String.join((CharSequence)", ", entry.getFlags().intStream().mapToObj(Integer::toString).toList()));
            } else {
                this.flagsBox.setCurrentText("");
            }
            if (entry.getProperties() != null) {
                this.propertiesBox.setNewContents(entry.getProperties());
            } else {
                this.propertiesBox.setNewContents((List)Lists.newArrayList());
                entry.setProperties(this.propertiesBox.getContents());
            }
            this.propertiesBox.setCurrentText("");
        }
    }

    public void setEntryPixelOffset(int entryPixelOffset) {
        this.entryPixelOffset = Mth.m_14045_((int)entryPixelOffset, (int)0, (int)Math.max(0, this.entries.size() * ENTRY_HEIGHT - (this.f_93619_ - BORDER_OFFSET)));
    }

    public void setSelected(BCSelectable selectable) {
        this.selected = selectable;
    }

    public void setEntries(List<ClientSchemaMakerEntry> entries) {
        this.entries = entries;
        this.entryPointer = -1;
        this.updateBlockMapToList();
    }

    public void updateBlockMapToList() {
        if (!this.usedBlocks.isEmpty()) {
            this.usedBlocks.clear();
        }
        this.entries.forEach(en -> this.usedBlocks.put(en.getBlock(), (ClientSchemaMakerEntry)en));
    }

    public void deleteEntry(int index) {
        this.entries.remove(index);
        for (int i = index; i < this.entries.size(); ++i) {
            ClientSchemaMakerEntry entry = this.entries.get(i);
            entry.setIndex(entry.getIndex() - 1);
        }
        if (this.entryPointer >= index) {
            this.setEntryPointer(this.entryPointer - 1);
        }
    }

    public void m_142291_(NarrationElementOutput out) {
        out.m_169146_(NarratedElementType.TITLE, C_TITLE);
    }

    public BCSelector selector() {
        return this.screen;
    }

    public BCSelectable selected() {
        return this.selected;
    }

    public List<ClientSchemaMakerEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public ClientSchemaMakerEntry getEntryByBlock(Block block) {
        if (this.usedBlocks.containsKey(block)) {
            return this.usedBlocks.get(block);
        }
        return null;
    }

    private int maxDisplayableEntries() {
        return (this.f_93621_ + this.f_93619_ - BORDER_OFFSET) % ENTRY_HEIGHT + 1;
    }

    private ClientSchemaMakerEntry selectedEntry() {
        return this.entries.get(this.entryPointer);
    }

    private boolean inbounds(double x, double y) {
        return x >= (double)this.f_93620_ && x < (double)(this.f_93620_ + this.f_93618_) && y >= (double)this.f_93621_ && y < (double)(this.f_93621_ + this.f_93619_);
    }

    private boolean inboundEntry(double x, double y, double entryY) {
        return x >= (double)(this.f_93620_ + BORDER_WIDTH) && x < (double)(this.f_93620_ + this.f_93618_ - BORDER_WIDTH) && y >= entryY && y < entryY + (double)ENTRY_HEIGHT;
    }

    private boolean isEntrySelected() {
        return this.entryPointer >= 0;
    }

    public int getEntryPointer() {
        return this.entryPointer;
    }

    private void executeByChildren(Consumer<GuiEventListener> actor) {
        actor.accept((GuiEventListener)this.addButton);
        if (this.isSelected() && this.isEntrySelected()) {
            actor.accept((GuiEventListener)this.deleteButton);
            actor.accept((GuiEventListener)this.blockIdBox);
            actor.accept((GuiEventListener)this.nameBox);
            actor.accept((GuiEventListener)this.flagsBox);
            actor.accept((GuiEventListener)this.propertiesBox);
        }
    }

    private static /* synthetic */ void lambda$new$8(StringBuilder builder, MutableInt counter, String string, IntList flagSet, int i) {
        char ch = (char)i;
        boolean build = true;
        if (Character.isDigit(ch)) {
            builder.append(ch);
            build = false;
        }
        if (counter.getValue() == string.length() - 1) {
            build = true;
        }
        counter.increment();
        if (build) {
            try {
                flagSet.add(Integer.parseInt(builder.toString()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            builder.setLength(0);
        }
    }
}

