/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator._gen.DannyGenerator;
import bottomtextdanny.de_json_generator.types.base.GeneratorWMother;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class TokenGenerator
extends GeneratorWMother<TokenGenerator> {
    public TokenGenerator(String name, String motherName) {
        super(name, motherName);
        DannyGenerator.DOORS.add(name);
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = TokenGenerator.createBlockstate(this.name);
        String template = TokenGenerator.getTemplate("blockstates", "door");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = TokenGenerator.createBlockModel(this.name + "_bottom");
        String template = TokenGenerator.getTemplate("blockmodels", "door_bottom");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
        json = TokenGenerator.createBlockModel(this.name + "_bottom_hinge");
        template = TokenGenerator.getTemplate("blockmodels", "door_bottom_hinge");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
        json = TokenGenerator.createBlockModel(this.name + "_top");
        template = TokenGenerator.getTemplate("blockmodels", "door_top");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
        json = TokenGenerator.createBlockModel(this.name + "_top_hinge");
        template = TokenGenerator.getTemplate("blockmodels", "door_top_hinge");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = TokenGenerator.createItemModel(this.name);
        String template = TokenGenerator.getTemplate("itemmodels", "simple_item");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

