/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator.types.base.Generator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;

public class TallPlantGenerator
extends Generator<TallPlantGenerator> {
    public TallPlantGenerator(String name) {
        super(name);
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = TallPlantGenerator.createBlockstate(this.name);
        String template = TallPlantGenerator.getTemplate("blockstates", "tall_plant");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        template = P_NAME.matcher(template).replaceAll(Matcher.quoteReplacement(this.name));
        writer.write(template);
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = TallPlantGenerator.createBlockModel(this.name + "_bottom");
        String template = TallPlantGenerator.getTemplate("blockmodels", "tall_plant_bottom");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(P_NAME.matcher(template).replaceAll(Matcher.quoteReplacement(this.name)));
        writer.close();
        json = TallPlantGenerator.createBlockModel(this.name + "_top");
        template = TallPlantGenerator.getTemplate("blockmodels", "tall_plant_top");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(P_NAME.matcher(template).replaceAll(Matcher.quoteReplacement(this.name)));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = TallPlantGenerator.createItemModel(this.name);
        String template = TallPlantGenerator.getTemplate("itemmodels", "block_item_baked");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name + "_top"));
        writer.close();
    }
}

