/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator._gen.DannyGenerator;
import bottomtextdanny.de_json_generator.types.base.GeneratorWMother;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;

public class SlabGenerator
extends GeneratorWMother<SlabGenerator> {
    public SlabGenerator(String name, String motherName) {
        super(name, motherName);
        DannyGenerator.SLABS.add(name);
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = SlabGenerator.createBlockstate(this.name);
        String template = SlabGenerator.getTemplate("blockstates", "slab");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        template = P_NAME.matcher(template).replaceAll(Matcher.quoteReplacement(this.name));
        writer.write(P_WHOLE.matcher(template).replaceAll(Matcher.quoteReplacement(this.motherName)));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = SlabGenerator.createBlockModel(this.name);
        String template = SlabGenerator.getTemplate("blockmodels", "slab");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(P_WHOLE.matcher(template).replaceAll(Matcher.quoteReplacement(this.motherName)));
        writer.close();
        json = SlabGenerator.createBlockModel(this.name + "_top");
        template = SlabGenerator.getTemplate("blockmodels", "slab_top");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(P_WHOLE.matcher(template).replaceAll(Matcher.quoteReplacement(this.motherName)));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = SlabGenerator.createItemModel(this.name);
        String template = SlabGenerator.getTemplate("itemmodels", "block_item");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

