/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator._gen.DannyGenerator;
import bottomtextdanny.de_json_generator.types.base.GeneratorWMother;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.regex.Matcher;

public class FenceGenerator
extends GeneratorWMother<FenceGenerator> {
    public FenceGenerator(String name, String motherName) {
        super(name, motherName);
        DannyGenerator.FENCES.add(name);
        DannyGenerator.FORGE_FENCES.add(name);
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = FenceGenerator.createBlockstate(this.name);
        String template = FenceGenerator.getTemplate("blockstates", "fence");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = FenceGenerator.createBlockModel(this.name + "_side");
        String template = FenceGenerator.getTemplate("blockmodels", "fence_side");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(P_WHOLE.matcher(template).replaceAll(Matcher.quoteReplacement(this.motherName)));
        writer.close();
        json = FenceGenerator.createBlockModel(this.name + "_post");
        template = FenceGenerator.getTemplate("blockmodels", "fence_post");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(P_WHOLE.matcher(template).replaceAll(Matcher.quoteReplacement(this.motherName)));
        writer.close();
        json = FenceGenerator.createBlockModel(this.name + "_inventory");
        template = FenceGenerator.getTemplate("blockmodels", "fence_inventory");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(P_WHOLE.matcher(template).replaceAll(Matcher.quoteReplacement(this.motherName)));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = FenceGenerator.createItemModel(this.name);
        String template = FenceGenerator.getTemplate("itemmodels", "fence");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

