/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator._gen.DannyGenerator;
import bottomtextdanny.de_json_generator.types.base.GeneratorWMother;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class DoorGenerator
extends GeneratorWMother<DoorGenerator> {
    public DoorGenerator(String name, String motherName) {
        super(name, motherName);
        DannyGenerator.DOORS.add(name);
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = DoorGenerator.createBlockstate(this.name);
        String template = DoorGenerator.getTemplate("blockstates", "door");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = DoorGenerator.createBlockModel(this.name + "_bottom");
        String template = DoorGenerator.getTemplate("blockmodels", "door_bottom");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
        json = DoorGenerator.createBlockModel(this.name + "_bottom_hinge");
        template = DoorGenerator.getTemplate("blockmodels", "door_bottom_hinge");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
        json = DoorGenerator.createBlockModel(this.name + "_top");
        template = DoorGenerator.getTemplate("blockmodels", "door_top");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
        json = DoorGenerator.createBlockModel(this.name + "_top_hinge");
        template = DoorGenerator.getTemplate("blockmodels", "door_top_hinge");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = DoorGenerator.createItemModel(this.name);
        String template = DoorGenerator.getTemplate("itemmodels", "simple_item");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

