/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator.SimpleBlockstate;
import bottomtextdanny.de_json_generator.types.base.Generator;
import bottomtextdanny.de_json_generator.types.blockmodel.IGenBlockModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ComplexGenerator
extends Generator<ComplexGenerator> {
    private String itemModel;
    private SimpleBlockstate customBlockstate = SimpleBlockstate.NORMAL;
    private final IGenBlockModel<?> model;

    public ComplexGenerator(String name, IGenBlockModel<?> model) {
        super(name);
        this.model = model.setNameRemote(name);
        this.itemModel = "block_item";
    }

    public ComplexGenerator blockstate(SimpleBlockstate customBlockstate) {
        this.customBlockstate = customBlockstate;
        return this;
    }

    public ComplexGenerator itemModel(String itemModel) {
        this.itemModel = itemModel;
        return this;
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = ComplexGenerator.createBlockstate(this.name);
        String template = ComplexGenerator.getTemplate("blockstates", this.customBlockstate.getDir());
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        this.model.generate();
    }

    public void generateItemModel() throws IOException {
        File json = ComplexGenerator.createItemModel(this.name);
        String template = ComplexGenerator.getTemplate("itemmodels", this.itemModel);
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

