/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.braincell.base.pair.Pair;
import bottomtextdanny.de_json_generator.types.base.Generator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Optional;

public class ColumnGenerator
extends Generator<ColumnGenerator> {
    private final String sideName;
    private final String endName;
    private Optional<Pair<String, String>> ids = Optional.of(Pair.of((Object)"dannys_expansion", (Object)"dannys_expansion"));

    public ColumnGenerator(String name, String endName, String sideName) {
        super(name);
        this.sideName = sideName;
        this.endName = endName;
    }

    public static ColumnGenerator oneFaced(String name) {
        return new ColumnGenerator(name, name, name);
    }

    public static ColumnGenerator classic(String name) {
        return new ColumnGenerator(name, name + "_end", name + "_side");
    }

    public ColumnGenerator inferIDs(String id1, String id2) {
        this.ids = Optional.of(Pair.of((Object)id1, (Object)id2));
        return this;
    }

    public String getSideName() {
        return this.sideName;
    }

    public String getEndName() {
        return this.endName;
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = ColumnGenerator.createBlockstate(this.name);
        String template = ColumnGenerator.getTemplate("blockstates", "column");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = ColumnGenerator.createBlockModel(this.name);
        String template = ColumnGenerator.getTemplate("blockmodels", "column");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_IDend", (String)this.ids.get().left()).replaceAll("_Bend", this.endName).replaceAll("_IDside", (String)this.ids.get().right()).replaceAll("_Bside", this.sideName));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = ColumnGenerator.createItemModel(this.name);
        String template = ColumnGenerator.getTemplate("itemmodels", "block_item");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

