/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator._gen.DannyGenerator;
import bottomtextdanny.de_json_generator.types.base.GeneratorWMother;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class ButtonGenerator
extends GeneratorWMother<ButtonGenerator> {
    public ButtonGenerator(String name, String motherName) {
        super(name, motherName);
        DannyGenerator.BUTTONS.add(name);
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockModel();
        this.generateBlockstate();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = ButtonGenerator.createBlockstate(this.name);
        String template = ButtonGenerator.getTemplate("blockstates", "button");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = ButtonGenerator.createBlockModel(this.name);
        String template = ButtonGenerator.getTemplate("blockmodels", "button");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_whole", this.motherName));
        writer.close();
        json = ButtonGenerator.createBlockModel(this.name + "_pressed");
        template = ButtonGenerator.getTemplate("blockmodels", "button_pressed");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_whole", this.motherName));
        writer.close();
        json = ButtonGenerator.createBlockModel(this.name + "_inventory");
        template = ButtonGenerator.getTemplate("blockmodels", "button_inventory");
        writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_whole", this.motherName));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = ButtonGenerator.createItemModel(this.name);
        String template = ButtonGenerator.getTemplate("itemmodels", "button");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

