/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.types;

import bottomtextdanny.de_json_generator._gen.DannyGenerator;
import bottomtextdanny.de_json_generator.types.base.Generator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class BuiltinGenerator
extends Generator<BuiltinGenerator> {
    private String itemModel = "block_item";
    private final String particle;
    private String particleID = "dannys_expansion";

    public BuiltinGenerator(String name) {
        super(name);
        this.particle = name;
        DannyGenerator.GUARDED_BY_PIGLINS.add(name);
        DannyGenerator.FORGE_CHESTS.add(name);
    }

    public BuiltinGenerator(String name, String particle) {
        super(name);
        this.particle = particle;
    }

    public BuiltinGenerator setItemModelTemplate(String newItemModel) {
        this.itemModel = newItemModel;
        return this;
    }

    public BuiltinGenerator itemModelTemplateNamedSame() {
        this.itemModel = this.name;
        return this;
    }

    public BuiltinGenerator particleMCID() {
        this.particleID = "minecraft";
        return this;
    }

    @Override
    public void generate() throws IOException {
        this.generateBlockstate();
        this.generateBlockModel();
        this.generateItemModel();
    }

    public void generateBlockstate() throws IOException {
        File json = BuiltinGenerator.createBlockstate(this.name);
        String template = BuiltinGenerator.getTemplate("blockstates", "s_blockstate");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }

    public void generateBlockModel() throws IOException {
        File json = BuiltinGenerator.createBlockModel(this.name);
        String template = BuiltinGenerator.getTemplate("blockmodels", "invisible");
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_particle", this.particle).replaceAll("_IDparticle", this.particleID));
        writer.close();
    }

    public void generateItemModel() throws IOException {
        File json = BuiltinGenerator.createItemModel(this.name);
        String template = BuiltinGenerator.getTemplate("itemmodels", this.itemModel);
        BufferedWriter writer = new BufferedWriter(new FileWriter(json));
        writer.write(template.replaceAll("_name", this.name));
        writer.close();
    }
}

