/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.jsonBakers.itemmodel;

import bottomtextdanny.de_json_generator.jsonBakers.JsonBaker;
import bottomtextdanny.de_json_generator.jsonBakers.itemmodel.MatrixModifier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class ItemModel<T extends ItemModel<T>>
extends JsonBaker<T> {
    public static final String THIRD_PERSON_RIGHT_HAND = "thirdperson_righthand";
    public static final String THIRD_PERSON_LEFT_HAND = "thirdperson_lefthand";
    public static final String FIRST_PERSON_RIGHT_HAND = "firstperson_righthand";
    public static final String FIRST_PERSON_LEFT_HAND = "firstperson_lefthand";
    public static final String GROUND = "ground";
    public static final String FIXED = "fixed";
    public static final String GUI = "gui";
    public MatrixModifier thirdPersonRightHand = new MatrixModifier("thirdperson_righthand");
    public MatrixModifier thirdPersonLeftHand = new MatrixModifier("thirdperson_lefthand");
    public MatrixModifier firstPersonRightHand = new MatrixModifier("firstperson_righthand");
    public MatrixModifier firstPersonLeftHand = new MatrixModifier("firstperson_lefthand");
    public MatrixModifier ground = new MatrixModifier("ground");
    public MatrixModifier fixed = new MatrixModifier("fixed");
    public MatrixModifier gui = new MatrixModifier("gui");
    protected LinkedHashMap<String, MatrixModifier> matrices;
    protected String parent;
    protected final ArrayList<String> layers = new ArrayList(0);

    public ItemModel(String parent) {
        this.parent = parent;
        this.matrices = new LinkedHashMap(0);
        this.matrices.put(THIRD_PERSON_RIGHT_HAND, this.thirdPersonRightHand);
        this.matrices.put(THIRD_PERSON_LEFT_HAND, this.thirdPersonLeftHand);
        this.matrices.put(FIRST_PERSON_RIGHT_HAND, this.firstPersonRightHand);
        this.matrices.put(FIRST_PERSON_LEFT_HAND, this.firstPersonLeftHand);
        this.matrices.put(GROUND, this.ground);
        this.matrices.put(FIXED, this.fixed);
        this.matrices.put(GUI, this.gui);
    }

    public T layers(String ... layerTextureDirs) {
        this.layers.addAll(Arrays.asList(layerTextureDirs));
        return (T)this;
    }

    public ArrayList<String> getLayers() {
        return this.layers;
    }

    public Map<String, MatrixModifier> getMatrices() {
        return this.matrices;
    }

    public T setScaleMatrix(String id, float x, float y, float z) {
        this.getMatrices().get(id).scale(x, y, z);
        return (T)this;
    }

    public T setRotationMatrix(String id, float x, float y, float z) {
        this.getMatrices().get(id).rotation(x, y, z);
        return (T)this;
    }

    public T setTranslationMatrix(String id, float x, float y, float z) {
        this.getMatrices().get(id).translation(x, y, z);
        return (T)this;
    }

    public T setParent(String parent) {
        this.parent = parent;
        return (T)this;
    }

    public boolean isTemplate() {
        return false;
    }

    @Override
    public T bake() {
        JsonObject textures = new JsonObject();
        JsonObject display = new JsonObject();
        boolean[] validator = new boolean[]{false};
        this.jsonObj.add("parent", (JsonElement)this.cString(this.parent));
        for (int i = 0; i < this.layers.size(); ++i) {
            textures.add("layer" + i, (JsonElement)this.cString(this.layers.get(i)));
        }
        this.matrices.forEach((s, matrixModifier) -> {
            if (matrixModifier.isModified()) {
                validator[0] = true;
                display.add(matrixModifier.getName(), matrixModifier.bake().decode());
            }
        });
        if (!this.layers.isEmpty()) {
            this.jsonObj.add("textures", (JsonElement)textures);
        }
        if (validator[0]) {
            this.jsonObj.add("display", (JsonElement)display);
        }
        return (T)this;
    }
}

