/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator.jsonBakers;

import bottomtextdanny.de_json_generator.jsonBakers.JsonBaker;
import bottomtextdanny.de_json_generator.jsonBakers.JsonDecoder;
import bottomtextdanny.de_json_generator.jsonBakers.mojValue.MojValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;

public interface JsonUtilsBackend {
    default public MojValue constant(float constant) {
        return new MojValue((JsonElement)new JsonPrimitive((Number)Float.valueOf(constant)));
    }

    default public MojValue uniform(float min, float max) {
        JsonObject object = new JsonObject();
        object.add("val1", (JsonElement)new JsonPrimitive((Number)Float.valueOf(min)));
        object.add("val2", (JsonElement)new JsonPrimitive((Number)Float.valueOf(max)));
        return new MojValue((JsonElement)object);
    }

    default public JsonPrimitive cBool(boolean b) {
        return new JsonPrimitive(Boolean.valueOf(b));
    }

    default public JsonPrimitive cString(String str) {
        return new JsonPrimitive(str);
    }

    default public JsonPrimitive cFloat(float f) {
        return new JsonPrimitive((Number)Float.valueOf(f));
    }

    default public JsonPrimitive cInt(int i) {
        return new JsonPrimitive((Number)i);
    }

    default public JsonArray cStringArray(String ... aObj) {
        JsonArray objectArray = new JsonArray();
        for (String dec : aObj) {
            objectArray.add(dec);
        }
        return objectArray;
    }

    default public JsonArray cFloatArray(float ... aObj) {
        JsonArray objectArray = new JsonArray();
        for (float dec : aObj) {
            objectArray.add((JsonElement)this.cFloat(dec));
        }
        return objectArray;
    }

    default public <T extends String> JsonArray cStringCollection(Collection<T> objCol) {
        JsonArray objectArray = new JsonArray();
        objCol.forEach(obj -> objectArray.add(obj));
        return objectArray;
    }

    default public <T extends JsonDecoder> JsonArray cObjectArray(T ... aObj) {
        JsonArray objectArray = new JsonArray();
        for (T dec : aObj) {
            objectArray.add(((JsonDecoder)dec).decode());
        }
        return objectArray;
    }

    default public <T extends JsonObject> JsonArray cObjectJsonArray(T ... aObj) {
        JsonArray objectArray = new JsonArray();
        for (T dec : aObj) {
            objectArray.add(dec);
        }
        return objectArray;
    }

    default public <T extends JsonObject> JsonArray cObjectJsonCollection(Collection<T> objCol) {
        JsonArray objectArray = new JsonArray();
        objCol.forEach(obj -> objectArray.add((JsonElement)obj));
        return objectArray;
    }

    default public <T extends JsonDecoder> JsonArray cObjectCollection(Collection<T> objCol) {
        JsonArray objectArray = new JsonArray();
        objCol.forEach(obj -> objectArray.add(obj.decode()));
        return objectArray;
    }

    default public <T extends JsonBaker> JsonArray cObjectArrayBake(T ... aObj) {
        JsonArray objectArray = new JsonArray();
        for (T dec : aObj) {
            objectArray.add(((JsonDecoder)((JsonBaker)dec).bake()).decode());
        }
        return objectArray;
    }

    default public <T extends JsonBaker> JsonArray cObjectCollectionBake(Collection<T> objCol) {
        JsonArray objectArray = new JsonArray();
        objCol.forEach(obj -> objectArray.add(((JsonDecoder)obj.bake()).decode()));
        return objectArray;
    }
}

