/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator._gen;

import bottomtextdanny.de_json_generator.GenUtils;
import bottomtextdanny.de_json_generator.ParticleMetadataGenerator;
import bottomtextdanny.de_json_generator.SoundMetadataGenerator;
import bottomtextdanny.de_json_generator.TagBuffer;
import bottomtextdanny.de_json_generator._gen.BlockGenerator;
import bottomtextdanny.de_json_generator._gen.LazyRecipesGenerator;
import bottomtextdanny.de_json_generator.jsonBakers.itemmodel.FreeItemModel;
import bottomtextdanny.de_json_generator.jsonBakers.itemmodel.ItemModel;
import bottomtextdanny.de_json_generator.types.BuiltinGenerator;
import bottomtextdanny.de_json_generator.types.ButtonGenerator;
import bottomtextdanny.de_json_generator.types.ChestGenerator;
import bottomtextdanny.de_json_generator.types.DoorGenerator;
import bottomtextdanny.de_json_generator.types.FullblockGenerator;
import bottomtextdanny.de_json_generator.types.PressurePlateGenerator;
import bottomtextdanny.de_json_generator.types.SlabGenerator;
import bottomtextdanny.de_json_generator.types.StairsGenerator;
import bottomtextdanny.de_json_generator.types.TrapdoorGenerator;
import bottomtextdanny.de_json_generator.types.base.GeneratorUtils;
import bottomtextdanny.de_json_generator.types.extension.BlockDropGenExt;
import bottomtextdanny.de_json_generator.types.extension.GrassLikeDropGenExt;
import bottomtextdanny.de_json_generator.types.extension.SilkOrElseDropGenExt;
import bottomtextdanny.de_json_generator.types.extension.TagGenExt;
import bottomtextdanny.de_json_generator.types.extension.WoodGenExt;
import bottomtextdanny.de_json_generator.types.item.ItemGenerator;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;

public class DannyGenerator
extends GenUtils
implements GeneratorUtils {
    public static Set<TagBuffer> TAGS = new HashSet<TagBuffer>();
    public static final TagBuffer EMOSSENCE_PLACEABLE_ON = new TagBuffer("dannys_expansion", "blocks", "emossence_placeable_on");
    public static final TagBuffer PLANKS = new TagBuffer("minecraft", "items&blocks", "planks");
    public static final TagBuffer FENCES = new TagBuffer("minecraft", "items&blocks", "fences");
    public static final TagBuffer WALLS = new TagBuffer("minecraft", "items&blocks", "walls");
    public static final TagBuffer WOODEN_FENCES = new TagBuffer("minecraft", "items&blocks", "wooden_fences");
    public static final TagBuffer FENCE_GATES = new TagBuffer("minecraft", "items&blocks", "fence_gates");
    public static final TagBuffer SLABS = new TagBuffer("minecraft", "items&blocks", "slabs");
    public static final TagBuffer WOODEN_SLABS = new TagBuffer("minecraft", "items&blocks", "wooden_slabs");
    public static final TagBuffer STAIRS = new TagBuffer("minecraft", "items&blocks", "stairs");
    public static final TagBuffer WOODEN_STAIRS = new TagBuffer("minecraft", "items&blocks", "wooden_stairs");
    public static final TagBuffer DOORS = new TagBuffer("minecraft", "items&blocks", "doors");
    public static final TagBuffer WOODEN_DOORS = new TagBuffer("minecraft", "items&blocks", "wooden_doors");
    public static final TagBuffer BUTTONS = new TagBuffer("minecraft", "items&blocks", "buttons");
    public static final TagBuffer WOODEN_BUTTONS = new TagBuffer("minecraft", "items&blocks", "wooden_buttons");
    public static final TagBuffer PRESSURE_PLATES = new TagBuffer("minecraft", "items&blocks", "pressure_plates");
    public static final TagBuffer WOODEN_PRESSURE_PLATES = new TagBuffer("minecraft", "items&blocks", "wooden_pressure_plates");
    public static final TagBuffer TRAPDOORS = new TagBuffer("minecraft", "items&blocks", "trapdoors");
    public static final TagBuffer WOODEN_TRAPDOORS = new TagBuffer("minecraft", "items&blocks", "wooden_trapdoors");
    public static final TagBuffer FLOWER_POTS = new TagBuffer("minecraft", "blocks", "flower_pots");
    public static final TagBuffer STANDING_SIGNS = new TagBuffer("minecraft", "blocks", "standing_signs");
    public static final TagBuffer WALL_SIGNS = new TagBuffer("minecraft", "blocks", "wall_signs");
    public static final TagBuffer SIGNS = new TagBuffer("minecraft", "items", "signs");
    public static final TagBuffer GUARDED_BY_PIGLINS = new TagBuffer("minecraft", "blocks", "guarded_by_piglins");
    public static final TagBuffer DRAGON_IMMUNE = new TagBuffer("minecraft", "blocks", "dragon_immune");
    public static final TagBuffer BOATS = new TagBuffer("minecraft", "items", "boats");
    public static final TagBuffer ARROWS = new TagBuffer("minecraft", "items", "arrows");
    public static final TagBuffer FORGE_FENCES = new TagBuffer("forge", "items&blocks", "fences");
    public static final TagBuffer FORGE_WOODEN_FENCES = new TagBuffer("forge", "items&blocks/fences", "wooden");
    public static final TagBuffer FORGE_FENCE_GATES = new TagBuffer("forge", "items&blocks", "fence_gates");
    public static final TagBuffer FORGE_WOODEN_FENCE_GATES = new TagBuffer("forge", "items&blocks/fence_gates", "wooden");
    public static final TagBuffer FORGE_CHESTS = new TagBuffer("forge", "items&blocks", "chests");
    public static final TagBuffer FORGE_WOODEN_CHESTS = new TagBuffer("forge", "items&blocks/chests", "wooden");
    public static final TagBuffer FORGE_TRAPPED_CHESTS = new TagBuffer("forge", "items&blocks/chests", "trapped");
    public static final TagBuffer FORGE_MUSHROOMS = new TagBuffer("forge", "items", "mushrooms");
    public static final TagBuffer ENDERGETIC_ENDER_FIRE_BASES = new TagBuffer("endergetic", "blocks", "ender_fire_base_blocks");
    public static final BlockDropGenExt BLOCK_DROP = new BlockDropGenExt();
    public static final SilkOrElseDropGenExt SILK_OR_ELSE = new SilkOrElseDropGenExt();
    public static final GrassLikeDropGenExt GRASS_LIKE_DROP = new GrassLikeDropGenExt();
    public static final WoodGenExt WOODEN_FURNITURE = new WoodGenExt();

    public static void main(String[] args) throws IOException {
        BlockGenerator.gen();
        LazyRecipesGenerator.gen();
        ((FullblockGenerator)new FullblockGenerator("ice_bricks").with(BLOCK_DROP)).generate();
        ((FullblockGenerator)((FullblockGenerator)new FullblockGenerator("weak_ice").with(BLOCK_DROP)).with(DannyGenerator.ext_loottable("blocks", DannyGenerator.lt_silktouch_only()))).generate();
        ((SlabGenerator)((SlabGenerator)new SlabGenerator("ice_brick_slab", "ice_bricks").with(DannyGenerator.ext_recipe(DannyGenerator.rs_slab("dannys_expansion:ice_bricks")))).with(BLOCK_DROP)).generate();
        ((StairsGenerator)((StairsGenerator)new StairsGenerator("ice_brick_stairs", "ice_bricks").with(DannyGenerator.ext_recipe(DannyGenerator.rs_stairs("dannys_expansion:ice_bricks")))).with(BLOCK_DROP)).generate();
        ((DoorGenerator)((DoorGenerator)new DoorGenerator("ice_door", "ice_bricks").with(DannyGenerator.ext_loottable("blocks", DannyGenerator.lt_double()))).with(DannyGenerator.ext_recipe(DannyGenerator.rs_door("dannys_expansion:ice_bricks")))).generate();
        ((TrapdoorGenerator)((TrapdoorGenerator)new TrapdoorGenerator("ice_trapdoor", "ice_bricks").with(BLOCK_DROP)).with(DannyGenerator.ext_recipe(DannyGenerator.rs_trapdoor("dannys_expansion:ice_bricks")))).generate();
        ((ChestGenerator)((ChestGenerator)new ChestGenerator("ice_chest", "ice_bricks").materialID("dannys_expansion:ice_bricks")).with(BLOCK_DROP)).generate();
        ((ChestGenerator)((ChestGenerator)new ChestGenerator("trapped_ice_chest", "ice_bricks").materialID("dannys_expansion:ice_chest")).trapped().with(BLOCK_DROP)).generate();
        ((ButtonGenerator)new ButtonGenerator("ice_button", "ice_bricks").with(BLOCK_DROP)).generate();
        ((PressurePlateGenerator)new PressurePlateGenerator("ice_pressure_plate", "ice_bricks").with(BLOCK_DROP)).generate();
        new FullblockGenerator("plant_matter").generate();
        ((BuiltinGenerator)((BuiltinGenerator)((BuiltinGenerator)new BuiltinGenerator("workbench", "oak_planks").itemModelTemplateNamedSame().particleMCID().with(BLOCK_DROP)).with(DannyGenerator.ext_recipe(DannyGenerator.recipe(" B ", "XXX", "X X").keys(DannyGenerator.keyItem('B', "minecraft:book"), DannyGenerator.keyTag('X', "minecraft:planks"))))).with(DannyGenerator.ext_loottable("blocks", DannyGenerator.lt_by_blockstate(DannyGenerator.map().put("workbench_part", "main"))))).generate();
        DannyGenerator.automateBasicItems();
        TAGS.forEach(TagBuffer::bake);
        ParticleMetadataGenerator.generate();
        SoundMetadataGenerator.generate();
    }

    public static boolean objStringEquals(JsonObject obj, String key, String compareTo) {
        if (obj.has(key)) {
            return obj.get(key).getAsString().equals(compareTo);
        }
        return false;
    }

    public static String objGetStr(JsonObject obj, String key) {
        if (obj.has(key)) {
            return obj.get(key).getAsString();
        }
        return null;
    }

    public static boolean objStringEquals(JsonObject obj, String key, String ... compareTo) {
        for (String equalKey : compareTo) {
            if (!obj.has(key)) continue;
            return obj.get(key).getAsString().equals(compareTo);
        }
        return false;
    }

    public static void automateBasicItems() throws IOException {
        DannyGenerator.g_item("_t_handheld_18", (ItemModel)DannyGenerator.m_handheld18(DannyGenerator.im_template("item/generated")).bake()).generate();
        DannyGenerator.g_sword("eclipse", DannyGenerator.danny("item/_t_handheld_32"));
        DannyGenerator.g_big_bow("equinox", DannyGenerator.danny("item/_t_bow_32"));
        File namesFile = new File("C:/Users/pc/minecraft mod/DannysExpansion/src/main/resources/assets/item_list.json");
        JsonParser parser = new JsonParser();
        JsonReader jsonReader = new JsonReader((Reader)new FileReader(namesFile));
        jsonReader.setLenient(true);
        JsonObject namesObject = (JsonObject)parser.parse(jsonReader);
        JsonArray namesArray = namesObject.getAsJsonArray("objects");
        namesArray.forEach(asElement -> {
            JsonObject object = asElement.getAsJsonObject();
            String itemName = object.get("name").getAsString();
            try {
                if (DannyGenerator.objStringEquals(object, "type", "accessory")) {
                    DannyGenerator.g_item(DannyGenerator.im_simple_item(itemName)).generate();
                } else if (DannyGenerator.objStringEquals(object, "type", "spawn_egg")) {
                    DannyGenerator.g_item(itemName, ((FreeItemModel)DannyGenerator.im_free_dir().setParent("item/template_spawn_egg")).bake()).generate();
                } else if (DannyGenerator.objStringEquals(object, "type", "kite")) {
                    DannyGenerator.g_item(itemName, ((FreeItemModel)DannyGenerator.im_free_dir().setParent("builtin/entity")).bake()).generate();
                } else if (DannyGenerator.objStringEquals(object, "type", "bullet") || DannyGenerator.objStringEquals(object, "type", "material")) {
                    DannyGenerator.g_item(DannyGenerator.im_simple_item(itemName)).generate();
                } else if (DannyGenerator.objStringEquals(object, "type", "arrow")) {
                    ((ItemGenerator)DannyGenerator.g_item(DannyGenerator.im_simple_item(itemName)).with(TagGenExt.of(ARROWS))).generate();
                } else if (DannyGenerator.objStringEquals(object, "type", "boat")) {
                    ((ItemGenerator)((ItemGenerator)DannyGenerator.g_item(DannyGenerator.im_simple_item(itemName)).with(TagGenExt.of(BOATS))).with(DannyGenerator.ext_recipe(DannyGenerator.recipe("X X", "XXX").keys(DannyGenerator.keyItem('X', DannyGenerator.objGetStr(object, "recipe_material_id"))).result(DannyGenerator.result())))).generate();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static String deWrap(String path) {
        return "dannys_expansion:" + path;
    }
}

