/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator;

import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.de_json_generator.jsonBakers.JsonUtilsMiddleEnd;
import bottomtextdanny.de_json_generator.jsonBakers.SoundMetadata;
import bottomtextdanny.de_json_generator.jsonBakers.SoundMetadataBaker;
import bottomtextdanny.de_json_generator.types.base.Generator;
import bottomtextdanny.de_json_generator.types.base.GeneratorUtils;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class SoundMetadataGenerator {
    public static void generate() throws IOException {
        LinkedList<SoundMetadata> dataList = SoundMetadataGenerator.collectData();
        try {
            File file = Generator.createSoundMetadata();
            SoundMetadataBaker baker = new SoundMetadataBaker(dataList);
            BufferedWriter writer = new BufferedWriter(new FileWriter(file));
            writer.write(JsonUtilsMiddleEnd.parse(baker.bake().decode()));
            writer.close();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LinkedList<SoundMetadata> collectData() {
        LinkedList list = Lists.newLinkedList();
        String source = GeneratorUtils.getClassSource(DESounds.class);
        String[] lines = source.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            SoundMetadata bakingData;
            String line = lines[i];
            if (line.isEmpty() || (bakingData = SoundMetadataGenerator.getDataOffLine(line)) == null) continue;
            list.add(bakingData);
        }
        return list;
    }

    @Nullable
    public static SoundMetadata getDataOffLine(String line) {
        if (!line.contains("public static final Wrap")) {
            return null;
        }
        boolean[] bool = new boolean[1];
        String key = SoundMetadataGenerator.getFirstMatchingString(line, data -> {
            if (!bool[0]) {
                if (data.current == '\"') {
                    bool[0] = true;
                    return true;
                }
                return false;
            }
            if (data.current != '\"') {
                return true;
            }
            if (bool[0]) {
                bool[0] = false;
                return true;
            }
            return false;
        });
        String spriteNumber = SoundMetadataGenerator.getFirstMatchingString(line, data -> SoundMetadataGenerator.isDigit(data.current));
        System.out.println(spriteNumber);
        if (key == null || spriteNumber == null) {
            return null;
        }
        return new SoundMetadata(key.substring(1, key.length() - 1), Integer.parseInt(spriteNumber));
    }

    @Nullable
    public static String getFirstMatchingString(String base, Predicate<StringPredicateData> predicate) {
        byte[] bytes = base.getBytes();
        int firstIndex = -1;
        int secondIndex = -1;
        for (int i = 0; i < bytes.length; ++i) {
            char ch = (char)bytes[i];
            if (predicate.test(new StringPredicateData(base, i, ch))) {
                if (firstIndex == -1) {
                    firstIndex = i;
                }
                secondIndex = i;
                continue;
            }
            if (firstIndex != -1) break;
        }
        if (firstIndex == -1) {
            return null;
        }
        return base.substring(firstIndex, secondIndex + 1);
    }

    public static boolean isDigit(char character) {
        return character >= '0' && character <= '9';
    }

    record StringPredicateData(String base, int index, char current) {
    }
}

