/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.de_json_generator;

import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import bottomtextdanny.de_json_generator.jsonBakers.JsonUtilsMiddleEnd;
import bottomtextdanny.de_json_generator.jsonBakers.ParticleMetadataBaker;
import bottomtextdanny.de_json_generator.types.base.Generator;
import bottomtextdanny.de_json_generator.types.base.GeneratorUtils;
import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public class ParticleMetadataGenerator
implements GeneratorUtils {
    public static void generate() throws IOException {
        LinkedList<Data> dataList = ParticleMetadataGenerator.collectData();
        try {
            for (Data data : dataList) {
                LinkedList textureEntryList = Lists.newLinkedList();
                int parsedSpriteNumber = Integer.parseInt(data.spriteNumber) + 1;
                for (int i = 0; i < parsedSpriteNumber; ++i) {
                    textureEntryList.add("dannys_expansion:" + data.key + "_" + i);
                }
                File file = Generator.createParticleMetadata(data.key.substring(data.key.indexOf(58) + 1));
                ParticleMetadataBaker baker = new ParticleMetadataBaker(textureEntryList);
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(JsonUtilsMiddleEnd.parse(baker.bake().decode()));
                writer.close();
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static LinkedList<Data> collectData() {
        LinkedList list = Lists.newLinkedList();
        String source = GeneratorUtils.getClassSource(DEParticles.class);
        String[] lines = source.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            Data bakingData;
            String line = lines[i];
            if (line.isEmpty() || (bakingData = ParticleMetadataGenerator.getDataOfField(line)) == null) continue;
            list.add(bakingData);
        }
        return list;
    }

    @Nullable
    public static Data getDataOfField(String line) {
        if (!line.contains("public static final Wrap")) {
            return null;
        }
        boolean[] bool = new boolean[1];
        String key = ParticleMetadataGenerator.getFirstMatchingString(line, data -> {
            if (!bool[0]) {
                if (data.current == '\"') {
                    bool[0] = true;
                    return true;
                }
                return false;
            }
            if (data.current != '\"') {
                return true;
            }
            bool[0] = false;
            return true;
        });
        String spriteNumber = ParticleMetadataGenerator.getFirstMatchingString(line, data -> ParticleMetadataGenerator.isDigit(data.current));
        if (key == null || spriteNumber == null) {
            return null;
        }
        return new Data(key.substring(1, key.length() - 1), spriteNumber);
    }

    @Nullable
    public static String getFirstMatchingString(String base, Predicate<StringPredicateData> predicate) {
        byte[] bytes = base.getBytes();
        int firstIndex = -1;
        int secondIndex = -1;
        for (int i = 0; i < bytes.length; ++i) {
            char ch = (char)bytes[i];
            if (predicate.test(new StringPredicateData(base, i, ch))) {
                if (firstIndex == -1) {
                    firstIndex = i;
                }
                secondIndex = i;
                continue;
            }
            if (firstIndex != -1) break;
        }
        if (firstIndex == -1) {
            return null;
        }
        return base.substring(firstIndex, secondIndex + 1);
    }

    public static boolean isDigit(char character) {
        return character >= '0' && character <= '9';
    }

    record Data(String key, String spriteNumber) {
    }

    record StringPredicateData(String base, int index, char current) {
    }
}

