/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.tables;

import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelPhaseModule;
import bottomtextdanny.dannys_expansion.content.entities._modules.phase_affected_provider.AttributeTransformer;
import bottomtextdanny.dannys_expansion.content.entities.mob.hollow_armor.HollowArmor;
import bottomtextdanny.dannys_expansion.tables.DEEntities;
import com.google.common.collect.ImmutableMap;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class PhaseAttributeTransformers {
    private static final AttributeTransformer<?>[] EMPTY_TRANSFORMER_ARRAY = new AttributeTransformer[0];
    private static final int POST_ENDER_DRAGON = 0;
    private final ImmutableMap<EntityType<?>, AttributeTransformer<?>[]> lookupTable;

    public PhaseAttributeTransformers() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.populateLookup(builder);
        this.lookupTable = builder.build();
    }

    private void populateLookup(ImmutableMap.Builder<EntityType<?>, AttributeTransformer<?>[]> builder) {
        AttributeTransformer[] current = new AttributeTransformer[LevelPhaseModule.Phase.values().length - 1];
        current[0] = new AttributeTransformer<HollowArmor>(Attributes.f_22276_, (phase, entity, value) -> value * 1.25);
        builder.put((Object)((EntityType)DEEntities.HOLLOW_ARMOR.get()), (Object)current);
    }

    public AttributeTransformer<?>[] getTransformersForType(EntityType<?> type) {
        return (AttributeTransformer[])this.lookupTable.getOrDefault(type, EMPTY_TRANSFORMER_ARRAY);
    }
}

