/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.structures.anglerstreasure;

import bottomtextdanny.braincell.base.Axis2D;
import bottomtextdanny.braincell.base.BCRandomUtil;
import bottomtextdanny.braincell.mod._base.plotter.BoxPlotter;
import bottomtextdanny.braincell.mod._base.plotter.CustomFillerPlotter;
import bottomtextdanny.braincell.mod._base.plotter.DeferredPlotter;
import bottomtextdanny.braincell.mod._base.plotter.DeferredPlotters;
import bottomtextdanny.braincell.mod._base.plotter.IntBox;
import bottomtextdanny.braincell.mod._base.plotter.PlanePlotter;
import bottomtextdanny.braincell.mod._base.plotter.Plotter;
import bottomtextdanny.braincell.mod._base.plotter.SchemaPlotter;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterData;
import bottomtextdanny.braincell.mod._base.plotter.iterator.PlotterIterator;
import bottomtextdanny.braincell.mod._base.plotter.iterator_support.PlotterIterators;
import bottomtextdanny.braincell.mod._base.plotter.iterator_support.PlotterPredicates;
import bottomtextdanny.braincell.mod._base.plotter.schema.FlagsEntry;
import bottomtextdanny.braincell.mod._base.plotter.schema.Schema;
import bottomtextdanny.braincell.mod._base.plotter.schema.SchemaGetter;
import bottomtextdanny.braincell.mod._base.plotter.schema.SchemaManager;
import bottomtextdanny.braincell.mod._base.plotter.schema.SchemaMemo;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BlockFamilies;
import net.minecraft.data.BlockFamily;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.ScatteredFeaturePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;

public class AnglersTreasurePiece
extends ScatteredFeaturePiece {
    public static final SchemaMemo ROOF_SCH = SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/roof_0"));
    public static final List<SchemaMemo> FLOOR_DEFORMATIONS = List.of(SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/floor_deformation_0")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/floor_deformation_1")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/floor_deformation_2")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/floor_deformation_3")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/floor_deformation_4")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/floor_deformation_5")));
    public static final List<SchemaMemo> LANTERN_HANGS = List.of(SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/lantern_hang_0")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/lantern_hang_1")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/lantern_hang_2")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/lantern_hang_3")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/lantern_hang_4")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/lantern_hang_5")));
    public static final List<SchemaMemo> ARCS = List.of(SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/arc_0")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/arc_1")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/arc_2")), SchemaManager.parseStatically((ResourceLocation)SchemaMemo.schDir((String)"dannys_expansion", (String)"cave_treasure/arc_3")));
    public static final SchemaGetter ARC = (lvl, r) -> ((SchemaMemo)BCRandomUtil.randomOf(ARCS, (RandomGenerator)r)).getSchema();
    public static final SchemaGetter LANTERN_HANG = (lvl, r) -> ((SchemaMemo)BCRandomUtil.randomOf(LANTERN_HANGS, (RandomGenerator)r)).getSchema();
    public static final SchemaGetter FLOOR_DEFORMATION = (lvl, r) -> ((SchemaMemo)BCRandomUtil.randomOf(FLOOR_DEFORMATIONS, (RandomGenerator)r)).getSchema();
    public static final SchemaGetter ROOF = SchemaGetter.of((Schema)ROOF_SCH.getSchema());

    public AnglersTreasurePiece(Random random, int x, int z) {
        super(null, x, 64, z, 7, 7, 9, Direction.NORTH);
    }

    public AnglersTreasurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag nbt) {
        super(null, nbt);
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator chunkGen, Random rand, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        if (!this.m_72803_((LevelAccessor)world, boundingBox, 0)) {
            return;
        }
        if ((pos = new BlockPos(pos.m_123341_(), chunkGen.m_142647_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.OCEAN_FLOOR, (LevelHeightAccessor)world) + 3 + rand.nextInt(5), pos.m_123343_())).m_123342_() + 6 > chunkGen.m_6337_()) {
            return;
        }
        AnglersTreasurePiece.makePlot((LevelAccessor)world, pos);
    }

    public static void makePlot(LevelAccessor level, BlockPos root) {
        SchemaPlotter arcPlot = new SchemaPlotter(level, ARC);
        arcPlot.modify(0, AnglersTreasurePiece.arcSolver(BlockFamilies.f_175912_));
        BoxPlotter roomCube = new BoxPlotter(level, new IntBox(-3, 0, -5, 4, 6, 5));
        roomCube.modify(0, PlotterIterators.place((BlockState)Blocks.f_50016_.m_49966_()));
        SchemaPlotter roof = new SchemaPlotter(level, ROOF);
        roomCube.addChild(Vec3i.f_123288_.m_142082_(0, roomCube.getBox().y2, 0), (Plotter)roof);
        roof.modify(0, AnglersTreasurePiece.roofSolver(Blocks.f_50705_.m_49966_(), Blocks.f_152556_.m_49966_(), Blocks.f_152552_.m_49966_(), Blocks.f_152555_.m_49966_()));
        PlanePlotter floor = new PlanePlotter(level, roomCube.getBox().getPlane(Direction.Axis.Y).expand(Axis2D.X, -1));
        roomCube.addChild(Vec3i.f_123288_.m_142082_(0, roomCube.getBox().y1, 0), (Plotter)floor);
        floor.modify(0, PlotterIterators.place((BlockState)Blocks.f_50705_.m_49966_()));
        SchemaPlotter floorDeformer = new SchemaPlotter(level, FLOOR_DEFORMATION);
        floorDeformer.modify(0, (PlotterIterator)PlotterIterators.ifBlockState((Predicate)PlotterPredicates.bsIs((Block)Blocks.f_50705_), (PlotterIterator)PlotterIterators.place((BlockState)Blocks.f_50398_.m_49966_())));
        floor.modify(0, (PlotterIterator)PlotterIterators.randomly((float)0.2f, (PlotterIterator)PlotterIterators.decorate((Plotter)floorDeformer)));
        CustomFillerPlotter cobblestoneLayer = new CustomFillerPlotter(level, roomCube.getBox().layerIterable(1, true, true));
        roomCube.addChild(Vec3i.f_123288_, (Plotter)cobblestoneLayer);
        cobblestoneLayer.modify(0, AnglersTreasurePiece.outerLayer());
        IntBox box = roomCube.getBox();
        DeferredPlotter pillar = new DeferredPlotter(level, DeferredPlotters.pillarUntilBlocked((Direction)Direction.DOWN, (Predicate)PlotterPredicates.bpBlockState((LevelAccessor)level, PlotterPredicates.bsHasTag((TagKey)BlockTags.f_13061_).negate()), (int)60, (int)0, (int)0, (int)0, (int)0));
        roomCube.addChild(Vec3i.f_123288_.m_142082_(box.x1, 5, box.z1), (Plotter)pillar);
        pillar.modify(0, PlotterIterators.place((BlockState)Blocks.f_49999_.m_49966_()));
        pillar = new DeferredPlotter(level, DeferredPlotters.pillarUntilBlocked((Direction)Direction.DOWN, (Predicate)PlotterPredicates.bpBlockState((LevelAccessor)level, PlotterPredicates.bsHasTag((TagKey)BlockTags.f_13061_).negate()), (int)60, (int)0, (int)0, (int)0, (int)0));
        roomCube.addChild(Vec3i.f_123288_.m_142082_(box.x2, 5, box.z1), (Plotter)pillar);
        pillar.modify(0, PlotterIterators.place((BlockState)Blocks.f_49999_.m_49966_()));
        pillar = new DeferredPlotter(level, DeferredPlotters.pillarUntilBlocked((Direction)Direction.DOWN, (Predicate)PlotterPredicates.bpBlockState((LevelAccessor)level, PlotterPredicates.bsHasTag((TagKey)BlockTags.f_13061_).negate()), (int)60, (int)0, (int)0, (int)0, (int)0));
        roomCube.addChild(Vec3i.f_123288_.m_142082_(box.x1, 5, box.z2), (Plotter)pillar);
        pillar.modify(0, PlotterIterators.place((BlockState)Blocks.f_49999_.m_49966_()));
        pillar = new DeferredPlotter(level, DeferredPlotters.pillarUntilBlocked((Direction)Direction.DOWN, (Predicate)PlotterPredicates.bpBlockState((LevelAccessor)level, PlotterPredicates.bsHasTag((TagKey)BlockTags.f_13061_).negate()), (int)60, (int)0, (int)0, (int)0, (int)0));
        roomCube.addChild(Vec3i.f_123288_.m_142082_(box.x2, 5, box.z2), (Plotter)pillar);
        pillar.modify(0, PlotterIterators.place((BlockState)Blocks.f_49999_.m_49966_()));
        pillar = new DeferredPlotter(level, DeferredPlotters.pillarUntilBlocked((Direction)Direction.DOWN, (Predicate)PlotterPredicates.bpBlockState((LevelAccessor)level, PlotterPredicates.bsHasTag((TagKey)BlockTags.f_13061_).negate()), (int)60, (int)0, (int)0, (int)1, (int)1));
        roomCube.addChild(Vec3i.f_123288_.m_142082_(box.x1, 5, -1), (Plotter)pillar);
        pillar.modify(0, PlotterIterators.place((BlockState)Blocks.f_49999_.m_49966_()));
        pillar = new DeferredPlotter(level, DeferredPlotters.pillarUntilBlocked((Direction)Direction.DOWN, (Predicate)PlotterPredicates.bpBlockState((LevelAccessor)level, PlotterPredicates.bsHasTag((TagKey)BlockTags.f_13061_).negate()), (int)60, (int)0, (int)0, (int)1, (int)1));
        roomCube.addChild(Vec3i.f_123288_.m_142082_(box.x2 - 1, 5, -1), (Plotter)pillar);
        pillar.modify(0, PlotterIterators.place((BlockState)Blocks.f_49999_.m_49966_()));
        Plotter.compute((Plotter)roomCube, (BlockPos)root, (Rotation)Rotation.NONE);
    }

    private static PlotterIterator<PlotterData> outerLayer() {
        return PlotterIterators.ifBlockState((Predicate)PlotterPredicates.bsHasTag((TagKey)BlockTags.f_13061_), (PlotterIterator)PlotterIterators.ifBlockState((Predicate)PlotterPredicates.bsIs((Block)Blocks.f_152550_), (PlotterIterator)PlotterIterators.place((BlockState)Blocks.f_152551_.m_49966_())).orElse(PlotterIterators.place((BlockState)Blocks.f_50652_.m_49966_())));
    }

    private static PlotterIterator<SchemaPlotter.Data> roofSolver(BlockState base, BlockState stairs, BlockState imperfection, BlockState randomBump) {
        return data -> {
            FlagsEntry entry = data.flags();
            int flag = entry.firstFlag();
            if (flag == 0) {
                data.setState(base);
            } else if (flag == 3) {
                AnglersTreasurePiece.outerLayer().accept(data);
            } else if (data.random().nextFloat() < 0.05f) {
                data.setState(data.infer(imperfection));
            } else if (flag == 1) {
                data.setState(data.infer(stairs));
            } else if (flag == 2) {
                if (data.random().nextFloat() < 0.85f) {
                    data.setState(data.infer(randomBump));
                } else {
                    data.setState(data.infer(stairs));
                }
            }
        };
    }

    private static PlotterIterator<SchemaPlotter.Data> arcSolver(BlockFamily family) {
        Block stairs = family.m_175952_(BlockFamily.Variant.STAIRS);
        Block slab = family.m_175952_(BlockFamily.Variant.SLAB);
        return data -> {
            FlagsEntry entry = data.flags();
            int flag = entry.firstFlag();
            if (flag == 0) {
                data.setState(data.infer(stairs.m_49966_()));
            } else if (flag == 1) {
                data.setState(data.infer(slab.m_49966_()));
            }
        };
    }
}

