/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.items.gun;

import bottomtextdanny.braincell.base.vector.DistanceCalc3;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.gun_rendering.GunRenderingManager;
import bottomtextdanny.dannys_expansion._base.gun_rendering.ScopeRenderingData;
import bottomtextdanny.dannys_expansion._base.gun_rendering.SimpleGunModelRenderer;
import bottomtextdanny.dannys_expansion._util.EntityUtil;
import bottomtextdanny.dannys_expansion._util.tooltip.StringSuppliers;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipBlock;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipCondition;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipData;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipTable;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipWriter;
import bottomtextdanny.dannys_expansion.content._client.model.guns.ShootingStarModel;
import bottomtextdanny.dannys_expansion.content.entities.projectile.bullet.AbstractBullet;
import bottomtextdanny.dannys_expansion.content.items.bullet.BulletItem;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import bottomtextdanny.dannys_expansion.content.items.gun.ScopingGun;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables.items.DEItems;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ShootingStarItem
extends GunItem<BulletItem>
implements ScopingGun {
    public static final float RECOIL = 22.0f;
    public static final float MAX_RECOIL = 30.0f;
    public static final float DAMAGE = 12.0f;
    public static final float ADDITIONAL_BULLET_SPEED = 3.0f;
    public static final int FIRE_RATE = 22;
    public static final float SCOPING_SENS = 0.2f;
    public static final float SCOPING_ZOOM = 0.3f;
    public static final float SCOPING_MOVEMENT = 0.2f;

    public ShootingStarItem(Item.Properties properties) {
        super(BulletItem.class, properties);
    }

    @Override
    public TooltipWriter createTooltipInfo() {
        return TooltipTable.builder().block(TooltipWriter.component((Component)new TextComponent(""))).block(TooltipBlock.builder().header(TooltipWriter.trans("description.dannys_expansion.statistics", (MutableComponent)StringSuppliers.translatable("description.dannys_expansion.gun"), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}))).add((Component)TooltipData.DAMAGE.message(StringSuppliers.float_(12.0f)).m_130940_(ChatFormatting.DARK_GREEN)).add((Component)TooltipData.RATE_OF_FIRE.message(StringSuppliers.ticksToSeconds(22.0f)).m_130940_(ChatFormatting.DARK_GREEN)).add(TooltipBlock.builder().condition(TooltipCondition.HOLD_SHIFT).add((Component)TooltipData.ADDITIONAL_BULLET_SPEED.message(StringSuppliers.float_(3.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.BULLET_SPEED_MULTIPLIER.message(StringSuppliers.float_(1.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.RECOIL.message(StringSuppliers.float_(22.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.MAX_RECOIL.message(StringSuppliers.float_(30.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.SCOPING_ZOOM.message(StringSuppliers.float_(0.3f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.SCOPING_SENSIBILITY_MULTIPLIER.message(StringSuppliers.float_(0.2f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.SCOPING_MOVEMENT.message(StringSuppliers.float_(0.2f)).m_130940_(ChatFormatting.DARK_GRAY)).build()).build()).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderRegistry() {
        Connection.doClientSide(() -> {
            GunRenderingManager gunRenderData = DannysExpansion.client().getGunRenderData();
            gunRenderData.putRenderer(this, SimpleGunModelRenderer.create(new ResourceLocation("dannys_expansion", "textures/models/item/shooting_star.png"), new ShootingStarModel()));
            gunRenderData.putScopeResources(this, new ScopeRenderingData(new ResourceLocation[]{new ResourceLocation("dannys_expansion", "textures/gui/scope/shooting_star_outer.png"), new ResourceLocation("dannys_expansion", "textures/gui/scope/shooting_star_inner.png"), new ResourceLocation("dannys_expansion", "textures/gui/scope/shooting_star_crosshair.png")}, 320));
        });
    }

    @Override
    public void shotWithBullet(Player player, ItemStack stack, PlayerGunModule module, ItemStack bulletStack, BulletItem bulletItem) {
        float movement = (float)DistanceCalc3.EUCLIDEAN.distance(player.f_19790_, player.f_19791_, player.f_19792_, player.m_20185_(), player.m_20186_(), player.m_20189_());
        float dispersion = this.baseDispersionFactor(player, module.getRecoil(), movement);
        float mult = this.getMotionMultiplier(player);
        if (!player.m_7500_()) {
            bulletStack.m_41774_(1);
        }
        bulletItem.onShot(player, player.f_19853_);
        this.applyCooldown(player);
        if (module.getGunScoping() == ItemStack.f_41583_) {
            mult *= 4.0f;
        }
        if (!player.f_19853_.f_46443_) {
            AbstractBullet bullet = bulletItem.setupBullet(bulletStack, player.f_19853_, player, (GunItem)this, 60);
            bullet.addBulletDamage(12.0f);
            bullet.addBulletSpeed(3.0f);
            bullet.setupForGun(player, dispersion);
            EntityUtil.playEyeSound((Entity)player, (SoundEvent)DESounds.IS_SHOOTING_STAR_SHOT.get(), 1.4f, 1.0f + this.random.nextFloat() * 0.1f);
        } else {
            this.setCameraRecoil(player, 12.0f * mult, 0.2f * mult, 0.89f);
        }
        player.m_146926_(player.m_146909_() - 1.5f * mult);
        player.m_146922_((float)((double)player.m_146908_() + this.random.nextGaussian() * 1.5 * (double)mult));
        this.setRecoil(player, 22.0f * mult, 30.0f * mult, 0.25f * mult, 0.87f);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack p_150902_) {
        return super.m_142422_(p_150902_);
    }

    @Override
    public BulletItem getDefaultBullet() {
        return (BulletItem)DEItems.BULLET.get();
    }

    @Override
    public int cooldown() {
        return 22;
    }

    @Override
    public float scopingMovementSpeed(ItemStack stack, Player playerEntity) {
        return 0.2f;
    }

    @Override
    public float scopingSensMult() {
        return 0.2f;
    }

    @Override
    public float scopingFov() {
        return 0.3f;
    }

    @Override
    public float dispersionFactor(Player player, float recoil, float movement) {
        float mult = this.getMotionMultiplier(player);
        float addition = 0.0f;
        if (!this.isScoping(player)) {
            addition = 18.0f * mult;
        } else {
            mult = 0.0f;
        }
        return (Mth.m_14036_((float)(recoil * 0.75f), (float)0.0f, (float)800.0f) + Mth.m_14036_((float)(movement * 16.0f), (float)0.0f, (float)60.0f)) * mult * 0.35f + addition;
    }
}

