/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.items.gun;

import bottomtextdanny.braincell.base.vector.DistanceCalc3;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.gun_rendering.SimpleGunModelRenderer;
import bottomtextdanny.dannys_expansion._util.EntityUtil;
import bottomtextdanny.dannys_expansion._util.tooltip.StringSuppliers;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipBlock;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipCondition;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipData;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipTable;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipWriter;
import bottomtextdanny.dannys_expansion.content._client.model.guns.MusketModel;
import bottomtextdanny.dannys_expansion.content.entities.projectile.bullet.AbstractBullet;
import bottomtextdanny.dannys_expansion.content.items.bullet.BulletItem;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables.items.DEItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class MusketItem
extends GunItem<BulletItem> {
    public static final float RECOIL = 50.0f;
    public static final float MAX_RECOIL = 90.0f;
    public static final float DAMAGE = 9.5f;
    public static final float ADDITIONAL_BULLET_SPEED = 3.0f;
    public static final int FIRE_RATE = 24;

    public MusketItem(Item.Properties properties) {
        super(BulletItem.class, properties);
    }

    @Override
    public TooltipWriter createTooltipInfo() {
        return TooltipTable.builder().block(TooltipWriter.component((Component)new TextComponent(""))).block(TooltipBlock.builder().header(TooltipWriter.trans("description.dannys_expansion.statistics", (MutableComponent)StringSuppliers.translatable("description.dannys_expansion.gun"), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}))).add((Component)TooltipData.DAMAGE.message(StringSuppliers.float_(9.5f)).m_130940_(ChatFormatting.DARK_GREEN)).add((Component)TooltipData.RATE_OF_FIRE.message(StringSuppliers.ticksToSeconds(24.0f)).m_130940_(ChatFormatting.DARK_GREEN)).add(TooltipBlock.builder().condition(TooltipCondition.HOLD_SHIFT).add((Component)TooltipData.ADDITIONAL_BULLET_SPEED.message(StringSuppliers.float_(3.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.BULLET_SPEED_MULTIPLIER.message(StringSuppliers.float_(1.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.RECOIL.message(StringSuppliers.float_(50.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.MAX_RECOIL.message(StringSuppliers.float_(90.0f)).m_130940_(ChatFormatting.DARK_GRAY)).build()).build()).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderRegistry() {
        Connection.doClientSide(() -> DannysExpansion.client().getGunRenderData().putRenderer(this, SimpleGunModelRenderer.create(new ResourceLocation("dannys_expansion", "textures/models/item/musket.png"), new MusketModel())));
    }

    @Override
    public void shotWithBullet(Player player, ItemStack stack, PlayerGunModule capability, ItemStack bulletStack, BulletItem bulletItem) {
        float movement = (float)DistanceCalc3.EUCLIDEAN.distance(player.f_19790_, player.f_19791_, player.f_19792_, player.m_20185_(), player.m_20186_(), player.m_20189_());
        float dispersion = this.baseDispersionFactor(player, capability.getRecoil(), movement);
        float mult = this.getMotionMultiplier(player);
        if (!player.m_7500_()) {
            bulletStack.m_41774_(1);
        }
        bulletItem.onShot(player, player.f_19853_);
        this.applyCooldown(player);
        if (!player.f_19853_.f_46443_) {
            AbstractBullet bullet = bulletItem.setupBullet(bulletStack, player.f_19853_, player, (GunItem)this, 60);
            bullet.addBulletDamage(9.5f);
            bullet.addBulletSpeed(3.0f);
            bullet.setupForGun(player, dispersion);
            EntityUtil.playEyeSound((Entity)player, (SoundEvent)DESounds.IS_MUSKET_SHOT.get(), 1.0f, 1.0f + this.random.nextFloat() * 0.1f);
        } else {
            this.setCameraRecoil(player, 35.0f, 0.3f * mult, 0.89f);
        }
        player.m_146926_(player.m_146909_() - 3.0f);
        player.m_146922_((float)((double)player.m_146908_() + this.random.nextGaussian() * 3.0));
        this.setRecoil(player, 50.0f * mult, 90.0f, 0.5f, 0.87f);
    }

    @Override
    public int cooldown() {
        return 24;
    }

    @Override
    public BulletItem getDefaultBullet() {
        return (BulletItem)DEItems.BULLET.get();
    }

    @Override
    public float dispersionFactor(Player player, float recoil, float movement) {
        float mult = this.getMotionMultiplier(player);
        return (Mth.m_14036_((float)((recoil - 10.0f) * 0.25f), (float)0.0f, (float)25.0f) + Mth.m_14036_((float)(movement * 7.0f), (float)0.0f, (float)60.0f)) * mult;
    }
}

