/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.items.gun;

import bottomtextdanny.braincell.mod.capability.player.BCAccessoryModule;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.gun_rendering.GunClientData;
import bottomtextdanny.dannys_expansion._base.network.servertoclient.MSGCShootGun;
import bottomtextdanny.dannys_expansion._util.EntityUtil;
import bottomtextdanny.dannys_expansion._util._client.CMC;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipWriter;
import bottomtextdanny.dannys_expansion.content.items.bullet.Ammo;
import bottomtextdanny.dannys_expansion.content.items.gun.GunModelLoader;
import bottomtextdanny.dannys_expansion.content.items.gun.ScopingGun;
import bottomtextdanny.dannys_expansion.tables.DEMiniAttributes;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DERenderProperties;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.network.PacketDistributor;

public abstract class GunItem<E extends Ammo>
extends Item
implements GunModelLoader {
    public static final float MAX_ACCURACY = 10.0f;
    public static final float MAX_CADENCE = 10.0f;
    public Random random = new Random();
    private final Multimap<Attribute, AttributeModifier> attributeModifiers;
    private WeakReference<TooltipWriter> tooltipInfo;
    protected final Class<E> bulletClazz;

    public GunItem(Class<E> bulletClazz, Item.Properties properties) {
        super(properties.m_41487_(1));
        this.bulletClazz = bulletClazz;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", 9999999.0, AttributeModifier.Operation.ADDITION));
        this.attributeModifiers = builder.build();
        Connection.doClientSide(() -> this.renderRegistry());
        this.tooltipInfo = new WeakReference<Object>(null);
    }

    @Nonnull
    public TooltipWriter createTooltipInfo() {
        return (spacing, stack, level, tooltip, flag) -> {};
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract void renderRegistry();

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(DERenderProperties.GUN);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void baseShoot(Player player, ItemStack stack, InteractionHand hand) {
        PlayerGunModule gunModule;
        if (player.m_21211_() != ItemStack.f_41583_) {
            return;
        }
        if (!player.f_19853_.f_46443_ && (gunModule = PlayerHelper.gunModule(player)).getGunCooldownTicks() <= 0) {
            int handIdx = hand.ordinal();
            if (this.usageTime() > 0) {
                this.shootFirstCallout(player, stack, gunModule);
                if (gunModule.getGunUseTicks() < 0 || gunModule.getGunUseTicks() >= this.usageTime() && this.usageParameter(player, stack, hand, gunModule)) {
                    gunModule.setGunUseTicks(0);
                    handIdx += 256;
                }
                new MSGCShootGun(player.m_142049_(), handIdx).sendTo(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
            } else {
                this.shootFirstCallout(player, stack, gunModule);
                new MSGCShootGun(player.m_142049_(), handIdx).sendTo(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player));
            }
        }
    }

    public boolean usageParameter(Player player, ItemStack stack, InteractionHand hand, PlayerGunModule capability) {
        return false;
    }

    public void shootFirstCallout(Player player, ItemStack stack, PlayerGunModule capability) {
        Connection.doClientSide(() -> {
            GunClientData clientData = DannysExpansion.client().getGunData();
            if (this.usageTime() <= 0 && player == CMC.player()) {
                clientData.rollDirection = this.random.nextBoolean() ? 1 : -1;
            }
        });
        player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
        ItemStack bulletStack = this.tryToGetBullet(this.bulletClazz, player);
        if (bulletStack != null) {
            this.shotWithBullet(player, stack, capability, bulletStack, (Ammo)bulletStack.m_41720_());
        } else {
            this.failShoot(player, stack);
        }
    }

    public void shotWithBullet(Player player, ItemStack stack, PlayerGunModule capability, ItemStack bulletStack, E bulletItem) {
    }

    public float getMotionMultiplier(Player player) {
        float mult = 1.0f;
        if (player.m_6144_() && player.m_20096_()) {
            mult = 0.75f;
        }
        if (player.m_6067_()) {
            mult = 1.333f;
        }
        return mult;
    }

    public void usageTick(Player player, PlayerGunModule module, ItemStack stack, int progress) {
    }

    public int cooldown() {
        return 5;
    }

    public int usageTime() {
        return 0;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.MAINHAND ? this.attributeModifiers : super.m_7167_(equipmentSlot);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        GunItem gunItem;
        if (!worldIn.f_46443_ && (gunItem = this) instanceof ScopingGun) {
            ScopingGun scopingGun = (ScopingGun)((Object)gunItem);
            PlayerGunModule gunModule = PlayerHelper.gunModule(playerIn);
            ItemStack itemstack = playerIn.m_21120_(handIn);
            return scopingGun.scopingAction(itemstack, playerIn, gunModule, handIn) ? InteractionResultHolder.m_19090_((Object)itemstack) : InteractionResultHolder.m_19100_((Object)itemstack);
        }
        return super.m_7203_(worldIn, playerIn, handIn);
    }

    public ItemStack tryToGetBullet(Class<E> clazz, Player player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!clazz.isAssignableFrom(itemstack.m_41720_().getClass())) continue;
            ItemStack itemstack1 = itemstack;
            return itemstack1;
        }
        if (player.m_7500_()) {
            return new ItemStack(this.getDefaultBullet());
        }
        return null;
    }

    public void failShoot(Player player, ItemStack stack) {
        this.setVisualRecoil(player, 2.0f, 0.3f, 0.8f);
        EntityUtil.playEyeSound((Entity)player, (SoundEvent)DESounds.IS_OUT_OF_AMMO.get(), 0.8f, 1.0f + this.random.nextFloat() * 0.1f);
    }

    public void setRecoil(Player player, float recoil, float recoilMax, float recoilSub, float recoilMult) {
        PlayerGunModule gunModule = PlayerHelper.gunModule(player);
        gunModule.setRecoilSubstract(recoilSub);
        gunModule.setRecoilMultiplier(recoilMult);
        gunModule.setRecoil(Math.min(gunModule.getRecoil() + recoil, recoilMax));
        Connection.doClientSide(() -> this.setClientRecoil(player, recoil, recoilMax, recoilSub, recoilMult));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientRecoil(Player player, float recoil, float recoilMax, float recoilSub, float recoilMult) {
        if (player instanceof LocalPlayer) {
            GunClientData clientData = DannysExpansion.client().getGunData();
            clientData.recoil = recoil;
            clientData.recoilSubtract = recoilSub;
            clientData.recoilMult = recoilMult;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void updateClientDispersion(Player player, float recoilParam, float movementParam) {
        GunClientData clientData = DannysExpansion.client().getGunData();
        clientData.dispersion = (double)this.baseDispersionFactor(player, recoilParam, movementParam) + this.getExtraCrosshairDegrees(player);
    }

    public void setVisualRecoil(Player player, float recoil, float recoilSubstraction, float recoilMult) {
        Connection.doClientSide(() -> this.setCameraRecoil(player, recoil, recoilSubstraction, recoilMult));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void setCameraRecoil(Player player, float recoil, float recoilSubstraction, float recoilMult) {
        if (player instanceof LocalPlayer) {
            GunClientData clientData = DannysExpansion.client().getGunData();
            clientData.pitchRecoil = recoil;
            clientData.pitchRecoilSubtract = recoilSubstraction;
            clientData.pitchRecoilMult = recoilMult;
        }
    }

    public void applyCooldown(Player player) {
        PlayerGunModule gunModule = PlayerHelper.gunModule(player);
        BCAccessoryModule accessoryModule = PlayerHelper.braincellAccessoryModule(player);
        gunModule.setGunCooldownTicks((int)((float)this.cooldown() * ((1.0f - accessoryModule.getLesserModifier(DEMiniAttributes.GUN_CADENCE) / 10.0f) / 2.0f + 0.5f)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getExtraCrosshairDegrees(Player player) {
        return 0.0;
    }

    public abstract E getDefaultBullet();

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        TooltipWriter writerCache = (TooltipWriter)this.tooltipInfo.get();
        if (writerCache != null) {
            writerCache.write(0, stack, worldIn, tooltip, flag);
        } else {
            TooltipWriter writer = this.createTooltipInfo();
            this.tooltipInfo = new WeakReference<TooltipWriter>(writer);
            writer.write(0, stack, worldIn, tooltip, flag);
        }
    }

    protected float baseDispersionFactor(Player player, float recoil, float movement) {
        BCAccessoryModule accessoryModule = PlayerHelper.braincellAccessoryModule(player);
        return this.dispersionFactor(player, recoil, movement) * (1.0f - accessoryModule.getLesserModifier(DEMiniAttributes.GUN_ACCURACY) / 10.0f / 2.0f + 0.5f);
    }

    protected abstract float dispersionFactor(Player var1, float var2, float var3);
}

