/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.items.gun;

import bottomtextdanny.braincell.base.vector.DistanceCalc3;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.DannysExpansion;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerGunModule;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.gun_rendering.SimpleGunModelRenderer;
import bottomtextdanny.dannys_expansion._util.EntityUtil;
import bottomtextdanny.dannys_expansion._util.tooltip.StringSuppliers;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipBlock;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipCondition;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipData;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipTable;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipWriter;
import bottomtextdanny.dannys_expansion.content._client.model.guns.GolemHandgunModel;
import bottomtextdanny.dannys_expansion.content.entities.projectile.bullet.AbstractBullet;
import bottomtextdanny.dannys_expansion.content.items.bullet.BulletItem;
import bottomtextdanny.dannys_expansion.content.items.gun.GunItem;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables.items.DEItems;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GolemHandgunItem
extends GunItem<BulletItem> {
    public static final float RECOIL = 70.0f;
    public static final float MAX_RECOIL = 105.0f;
    public static final float DAMAGE = 10.0f;
    public static final float ADDITIONAL_BULLET_SPEED = 1.2f;
    public static final int FIRE_RATE = 10;
    public static final int DELAY = 6;

    public GolemHandgunItem(Item.Properties properties) {
        super(BulletItem.class, properties);
    }

    @Override
    public TooltipWriter createTooltipInfo() {
        return TooltipTable.builder().block(TooltipWriter.component((Component)new TextComponent(""))).block(TooltipBlock.builder().header(TooltipWriter.trans("description.dannys_expansion.statistics", (MutableComponent)StringSuppliers.translatable("description.dannys_expansion.gun"), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}))).add((Component)TooltipData.DELAY.message(StringSuppliers.ticksToSeconds(6.0f)).m_130940_(ChatFormatting.DARK_GREEN)).add((Component)TooltipData.DAMAGE.message(StringSuppliers.float_(10.0f)).m_130940_(ChatFormatting.DARK_GREEN)).add((Component)TooltipData.RATE_OF_FIRE.message(StringSuppliers.ticksToSeconds(10.0f)).m_130940_(ChatFormatting.DARK_GREEN)).add(TooltipBlock.builder().condition(TooltipCondition.HOLD_SHIFT).add((Component)TooltipData.ADDITIONAL_BULLET_SPEED.message(StringSuppliers.float_(1.2f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.BULLET_SPEED_MULTIPLIER.message(StringSuppliers.float_(1.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.RECOIL.message(StringSuppliers.float_(70.0f)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.MAX_RECOIL.message(StringSuppliers.float_(105.0f)).m_130940_(ChatFormatting.DARK_GRAY)).build()).build()).build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void renderRegistry() {
        Connection.doClientSide(() -> DannysExpansion.client().getGunRenderData().putRenderer(this, SimpleGunModelRenderer.create(new ResourceLocation("dannys_expansion", "textures/models/item/golem_handgun.png"), new GolemHandgunModel())));
    }

    @Override
    public void shotWithBullet(Player player, ItemStack stack, PlayerGunModule capability, ItemStack bulletStack, BulletItem bulletItem) {
        super.shotWithBullet(player, stack, capability, bulletStack, bulletItem);
        EntityUtil.playEyeSound((Entity)player, (SoundEvent)DESounds.IS_GOLEM_HANDGUN_CHARGE.get(), 1.0f, 1.0f + this.random.nextFloat() * 0.1f);
    }

    @Override
    public boolean usageParameter(Player player, ItemStack stack, InteractionHand hand, PlayerGunModule capability) {
        return this.tryToGetBullet(BulletItem.class, player) != null;
    }

    @Override
    public void usageTick(Player player, PlayerGunModule module, ItemStack stack, int progress) {
        super.usageTick(player, module, stack, progress);
        if (progress != 6) {
            return;
        }
        ItemStack bulletStack = this.tryToGetBullet(BulletItem.class, player);
        if (bulletStack == null) {
            return;
        }
        BulletItem bulletItem = (BulletItem)bulletStack.m_41720_();
        PlayerGunModule gunModule = PlayerHelper.gunModule(player);
        if (!player.m_7500_()) {
            bulletStack.m_41774_(1);
        }
        bulletItem.onShot(player, player.f_19853_);
        this.applyCooldown(player);
        if (!player.f_19853_.f_46443_) {
            float movement = (float)DistanceCalc3.EUCLIDEAN.distance(player.f_19790_, player.f_19791_, player.f_19792_, player.m_20185_(), player.m_20186_(), player.m_20189_());
            float dispersion = this.baseDispersionFactor(player, gunModule.getRecoil(), movement);
            AbstractBullet bullet = bulletItem.setupBullet(bulletStack, player.f_19853_, player, (GunItem)this, 60);
            bullet.addBulletDamage(10.0f);
            bullet.addBulletSpeed(1.2f);
            bullet.setupForGun(player, dispersion);
            EntityUtil.playEyeSound((Entity)player, (SoundEvent)DESounds.IS_HEAVY_PISTOL_SHOT.get(), 1.0f, 1.0f + this.random.nextFloat() * 0.1f);
        } else {
            this.setVisualRecoil(player, 35.0f, 0.7f, 0.89f);
        }
        this.setRecoil(player, 70.0f, 105.0f, 1.0f, 0.87f);
    }

    @Override
    public BulletItem getDefaultBullet() {
        return (BulletItem)DEItems.BULLET.get();
    }

    @Override
    public float dispersionFactor(Player player, float recoil, float movement) {
        float mult = this.getMotionMultiplier(player);
        return (Mth.m_14036_((float)(recoil * 0.75f), (float)0.0f, (float)80.0f) + Mth.m_14036_((float)(movement * 100.0f), (float)0.0f, (float)60.0f)) * mult * 0.35f;
    }

    @Override
    public int cooldown() {
        return 10;
    }

    @Override
    public int usageTime() {
        return 6;
    }
}

