/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.items.bow;

import bottomtextdanny.dannys_expansion._util.tooltip.StringSuppliers;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipBlock;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipCondition;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipData;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipTable;
import bottomtextdanny.dannys_expansion._util.tooltip.TooltipWriter;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DERenderProperties;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import net.minecraftforge.event.ForgeEventFactory;

public class DEBowItem
extends ProjectileWeaponItem {
    protected Random random = new Random();
    private final boolean big;
    private WeakReference<TooltipWriter> tooltipInfo;
    protected float speedFactor = 1.0f;
    protected float damageFactor = 1.0f;
    protected int nockTime = 15;
    protected int nockZoom = 10;
    protected float nockMovementSpeed = 0.2f;

    public DEBowItem(boolean big, Item.Properties properties) {
        super(properties);
        this.big = big;
        this.init();
        this.tooltipInfo = new WeakReference<Object>(null);
    }

    public void init() {
    }

    @Nonnull
    public TooltipWriter createTooltipInfo() {
        return TooltipTable.builder().block(TooltipWriter.component((Component)new TextComponent(""))).block(TooltipBlock.builder().header(TooltipWriter.trans("description.dannys_expansion.statistics", (MutableComponent)StringSuppliers.translatable("description.dannys_expansion.bow"), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}), Style.f_131099_.m_131152_(new ChatFormatting[]{ChatFormatting.GRAY}))).add((Component)TooltipData.ARROW_DAMAGE_FACTOR.message(StringSuppliers.float_(this.damageFactor)).m_130940_(ChatFormatting.DARK_GREEN)).add((Component)TooltipData.ARROW_SPEED_FACTOR.message(StringSuppliers.float_(this.speedFactor)).m_130940_(ChatFormatting.DARK_GREEN)).add((Component)TooltipData.NOCK_TIME.message(StringSuppliers.ticksToSeconds(this.nockTime)).m_130940_(ChatFormatting.DARK_GREEN)).add(TooltipBlock.builder().condition(TooltipCondition.HOLD_SHIFT).add((Component)TooltipData.NOCK_MOVEMENT_SPEED.message(StringSuppliers.ticksToSeconds(this.nockMovementSpeed)).m_130940_(ChatFormatting.DARK_GRAY)).add((Component)TooltipData.NOCK_ZOOM.message(StringSuppliers.int_(this.nockZoom)).m_130940_(ChatFormatting.DARK_GRAY)).build()).build()).build();
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(this.big ? DERenderProperties.BIG_BOW : DERenderProperties.BOW);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        super.m_5551_(stack, worldIn, entityLiving, timeLeft);
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            int trueMaxCount = this.getTrueMaxCount(stack);
            this.shoot(worldIn, player, stack, (float)Math.min(this.m_8105_(stack) - timeLeft, trueMaxCount) / (float)trueMaxCount, timeLeft);
        }
    }

    public void shoot(Level world, Player player, ItemStack stack, float progress, int timeLeft) {
        int k;
        int j;
        boolean doesntNeedArrow = player.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        float f = DEBowItem.getArrowVelocity(progress);
        if (f < 0.3f) {
            return;
        }
        ItemStack arrowStack = DEBowItem.tryToGetArrow(player);
        if (doesntNeedArrow && arrowStack == null) {
            arrowStack = new ItemStack((ItemLike)Items.f_42412_);
        }
        if (arrowStack == null) {
            return;
        }
        ArrowItem arrow = (ArrowItem)arrowStack.m_41720_();
        AbstractArrow abstractarrowentity = arrow.m_6394_(world, arrowStack, (LivingEntity)player);
        abstractarrowentity.m_6034_(player.m_20185_(), player.m_20188_(), player.m_20189_());
        abstractarrowentity = this.customArrow(abstractarrowentity);
        abstractarrowentity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, f * 3.0f * this.getSpeedFactor(world, player, stack), 1.0f);
        if (progress == 1.0f) {
            abstractarrowentity.m_36762_(true);
        }
        if ((j = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack)) > 0) {
            abstractarrowentity.m_36781_(abstractarrowentity.m_36789_() + ((double)j * 0.5 + 0.5) * (double)this.getDamageMultiplier(world, player, stack));
        }
        if ((k = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack)) > 0) {
            abstractarrowentity.m_36735_(k);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0) {
            abstractarrowentity.m_20254_(100);
        }
        if (player.m_150110_().f_35937_) {
            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
        world.m_7967_((Entity)abstractarrowentity);
        if (player.m_6142_()) {
            player.m_5496_(this.getShootSound(world, player, stack), 1.0f, 1.0f + (float)this.random.nextInt(3) * 0.1f);
        }
        if (!player.f_19853_.m_5776_() && !doesntNeedArrow) {
            arrowStack.m_41774_(1);
        }
        stack.m_41622_(1, (LivingEntity)player, p_220009_1_ -> p_220009_1_.m_21190_(player.m_7655_()));
    }

    public float getSpeedFactor(Level world, Player player, ItemStack stack) {
        return this.speedFactor;
    }

    public float getDamageMultiplier(Level world, Player player, ItemStack stack) {
        return this.damageFactor;
    }

    public SoundEvent getShootSound(Level world, Player player, ItemStack stack) {
        return (SoundEvent)DESounds.IS_FROZEN_BOW_SHOT.get();
    }

    public int getNockZoom(Level world, Player player, ItemStack stack) {
        return this.nockZoom;
    }

    public int getNockTime(ItemStack stack) {
        return this.nockTime;
    }

    public float getNockMovementSpeed(Level world, Player player, ItemStack stack) {
        return this.nockMovementSpeed;
    }

    public boolean automatic() {
        return false;
    }

    public int m_6615_() {
        return 15;
    }

    public static ItemStack tryToGetArrow(Player player) {
        if (player.m_21206_().m_41720_() instanceof ArrowItem) {
            return player.m_21206_();
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack itemstack = player.m_150109_().m_8020_(i);
            if (!(itemstack.m_41720_() instanceof ArrowItem)) continue;
            return itemstack;
        }
        return null;
    }

    public Class<ArrowItem> getArrowType() {
        return ArrowItem.class;
    }

    public static float getArrowVelocity(float charge) {
        float f = charge;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        return arrow;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            return entity.m_21212_() > 0;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack;
        boolean flag = !playerIn.m_6298_(itemstack = playerIn.m_21120_(handIn)).m_41619_();
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)worldIn, (Player)playerIn, (InteractionHand)handIn, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!playerIn.m_150110_().f_35937_ && !flag) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, worldIn, tooltip, flag);
        TooltipWriter writerCache = (TooltipWriter)this.tooltipInfo.get();
        if (writerCache != null) {
            writerCache.write(0, stack, worldIn, tooltip, flag);
        } else {
            TooltipWriter writer = this.createTooltipInfo();
            this.tooltipInfo = new WeakReference<TooltipWriter>(writer);
            writer.write(0, stack, worldIn, tooltip, flag);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.NONE;
    }

    public Predicate<ItemStack> m_6437_() {
        return f_43005_;
    }

    public int getTrueMaxCount(ItemStack stack) {
        return this.getNockTime(stack);
    }

    public float getFloatProgression(LivingEntity entity, ItemStack stack) {
        return Math.min((float)entity.m_21252_() / (float)this.getTrueMaxCount(stack), (float)this.getTrueMaxCount(stack));
    }

    public float getClampCount(LivingEntity entity, ItemStack stack) {
        return Math.min((float)entity.m_21252_(), (float)this.getTrueMaxCount(stack));
    }
}

