/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.projectile.bullet;

import bottomtextdanny.braincell.mod.capability.level.speck.ShootLighSpeck;
import bottomtextdanny.braincell.mod.graphics.point_lighting.IPointLight;
import bottomtextdanny.braincell.mod.graphics.point_lighting.SimplePointLight;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion._util.DEParticleUtil;
import bottomtextdanny.dannys_expansion.content.entities.projectile.bullet.AbstractBullet;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AquaticBullet
extends AbstractBullet {
    public AquaticBullet(EntityType<? extends AbstractBullet> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    @Override
    public void m_8119_() {
        float multiplier = 1.0f;
        if (this.f_19798_) {
            multiplier = 1.5f;
        }
        this.setBulletSpeedMult(this.getDefaultSpeedMult() * multiplier);
        super.m_8119_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientHitCallout(Vec3 hitPosition) {
        for (int i = 0; i < 4 + this.f_19796_.nextInt(2); ++i) {
            DannyParticleData data = DEParticleUtil.dust(true, -16727809, this.f_19796_.nextFloat(0.08f, 0.1f), 0.85f, 0.85f);
            float f = 0.25f + this.f_19796_.nextFloat() * 0.35f;
            Vec3 vec = DEMath.fromPitchYaw(this.m_146909_() + (float)this.f_19796_.nextGaussian() * 30.0f, this.m_146908_() + (float)this.f_19796_.nextGaussian() * 30.0f).m_82490_((double)f);
            this.f_19853_.m_7106_((ParticleOptions)data, hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_, -vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
        }
        ShootLighSpeck light = new ShootLighSpeck(this.f_19853_, 0, 2, 8);
        light.setPosition(new Vec3(hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_));
        light.setLight((IPointLight)new SimplePointLight(new Vec3(0.0, 0.3, 1.0), 1.5f, 0.25f, 0.6f));
        light.addToLevel();
    }

    @Override
    protected void m_5790_(EntityHitResult result) {
        if (!this.f_19853_.f_46443_) {
            this.sendHitMsg(result.m_82450_());
        }
        super.m_5790_(result);
    }

    @Override
    protected void onBlockHit(BlockHitResult result) {
        if (!this.f_19853_.f_46443_) {
            this.sendHitMsg(result.m_82450_());
        }
        super.onBlockHit(result);
    }

    @Override
    public boolean canceledMovement() {
        return false;
    }

    @Override
    public void onDeath() {
        super.onDeath();
        if (!this.soundPlayed) {
            this.m_5496_((SoundEvent)DESounds.ES_BULLET_IMPACT_GENERIC.get(), 1.0f, 1.0f + 0.2f * this.f_19796_.nextFloat());
        }
    }
}

