/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.projectile.bullet;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.capability.level.speck.ShootLighSpeck;
import bottomtextdanny.braincell.mod.capability.player.BCAccessoryModule;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExternalMotion;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManagerProvider;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.graphics.point_lighting.IPointLight;
import bottomtextdanny.braincell.mod.graphics.point_lighting.SimplePointLight;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityClientMessenger;
import bottomtextdanny.dannys_expansion._base.capabilities.player.PlayerHelper;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion._util.DEParticleUtil;
import bottomtextdanny.dannys_expansion._util.DERayUtil;
import bottomtextdanny.dannys_expansion.content.entities.projectile.DEProjectile;
import bottomtextdanny.dannys_expansion.content.items.bullet.BulletItem;
import bottomtextdanny.dannys_expansion.tables.DEDamageSources;
import bottomtextdanny.dannys_expansion.tables.DEMiniAttributes;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables.items.DEItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public abstract class AbstractBullet
extends DEProjectile
implements BCDataManagerProvider,
EntityClientMessenger {
    public static final int HIT_CLIENT_CALLOUT_FLAG = 0;
    public static final int UPDATE_TICK_CALLOUT_FLAG = 1;
    public static final int UPDATE_DEFAULT_VALUES_FLAG = 2;
    public static final int SET_TEXTURE_FLAG = 3;
    public static final EntityDataReference<ItemStack> ITEM_REF = BCDataManager.attribute(AbstractBullet.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.ITEM_STACK, () -> ((BulletItem)DEItems.BULLET.get()).m_7968_(), (String)"item"));
    public static final EntityDataReference<Float> DAMAGE_REF = BCDataManager.attribute(AbstractBullet.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(0.0f), (String)"damage"));
    public static final EntityDataReference<Float> SPEED_REF = BCDataManager.attribute(AbstractBullet.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(0.0f), (String)"speed"));
    public static final EntityDataReference<Float> SPEED_MULT_REF = BCDataManager.attribute(AbstractBullet.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(0.0f), (String)"speed_mult"));
    public static final EntityDataReference<Float> DEGREE_FALL_REF = BCDataManager.attribute(AbstractBullet.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(0.0f), (String)"degree_fall"));
    private final BCDataManager deDataManager;
    private final EntityData<ItemStack> item;
    protected final EntityData<Float> damage;
    protected final EntityData<Float> speed;
    protected final EntityData<Float> speed_mult;
    protected final EntityData<Float> degreeFall;
    private float defaultDamage;
    private float defaultSpeed;
    private float defaultSpeedMult;
    private float defaultDegreeFall;
    public ExternalMotion acceleration = new ExternalMotion(0.95f);
    public boolean soundPlayed;
    public boolean waterSplashSoundPlayer;
    public float prevDifference;
    public float difference;

    public AbstractBullet(EntityType<? extends AbstractBullet> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.deDataManager = new BCDataManager((Entity)this);
        this.item = this.bcDataManager().addSyncedData(EntityData.of(ITEM_REF));
        this.damage = this.bcDataManager().addSyncedData(EntityData.of(DAMAGE_REF));
        this.speed = this.bcDataManager().addSyncedData(EntityData.of(SPEED_REF));
        this.speed_mult = this.bcDataManager().addSyncedData(EntityData.of(SPEED_MULT_REF));
        this.degreeFall = this.bcDataManager().addSyncedData(EntityData.of(DEGREE_FALL_REF));
        this.setDegreeFall(0.6f);
    }

    public AbstractBullet(EntityType<? extends AbstractBullet> entityTypeIn, Level worldIn, int lifetime) {
        this(entityTypeIn, worldIn);
        this.setLifetime(lifetime);
    }

    @Override
    public void commonInit() {
    }

    @Override
    protected void m_8097_() {
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.defaultDamage = ((Float)this.damage.get()).floatValue();
        this.defaultDegreeFall = ((Float)this.degreeFall.get()).floatValue();
        this.defaultSpeed = ((Float)this.speed.get()).floatValue();
        this.defaultSpeedMult = ((Float)this.speed_mult.get()).floatValue();
        this.syncDefaultValues();
        this.syncItem();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.f_19794_ = true;
        this.acceleration.tick();
        this.prevDifference = this.difference;
        this.difference = DEMath.getDistance(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19854_, this.f_19855_, this.f_19856_);
        this.m_146926_(this.m_146909_() + ((Float)this.degreeFall.get()).floatValue());
        Vec3 forward = Vec3.m_82498_((float)this.m_146909_(), (float)this.m_146908_());
        if (!this.canceledMovement()) {
            Vec3 nextPosition = this.m_20182_().m_82520_((double)this.getRealSpeed() * forward.f_82479_, (double)this.getRealSpeed() * forward.f_82480_, (double)this.getRealSpeed() * forward.f_82481_);
            BlockPos nextBlockPosition = new BlockPos((int)nextPosition.f_82479_, (int)nextPosition.f_82480_, (int)nextPosition.f_82481_);
            if (!this.m_146899_() && this.f_19853_.m_46749_(nextBlockPosition)) {
                this.m_6478_(MoverType.SELF, this.acceleration.getAcceleratedMotion());
            } else if (!this.f_19853_.m_5776_()) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            if (!this.f_19861_) {
                this.acceleration.setMotion((double)this.getRealSpeed() * forward.f_82479_, (double)this.getRealSpeed() * forward.f_82480_, (double)this.getRealSpeed() * forward.f_82481_);
            }
        } else {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        this.sendClientMsg(1, PacketDistributor.TRACKING_ENTITY.with(() -> this), new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.VEC3, (Object)this.m_20184_())});
        this.m_20101_();
    }

    @Override
    protected void m_6532_(HitResult result) {
        HitResult.Type type = result.m_6662_();
        if (!this.f_19853_.f_46443_) {
            if (type == HitResult.Type.ENTITY) {
                EntityHitResult entityResult = (EntityHitResult)result;
                if (this.caster.get() != null && entityResult.m_82443_().m_6087_() && entityResult.m_82443_().m_142049_() != ((Entity)this.caster.get()).m_142049_()) {
                    this.m_5790_(entityResult);
                }
            } else if (type == HitResult.Type.BLOCK) {
                this.onBlockHit((BlockHitResult)result);
            }
        }
    }

    public void onDeath() {
    }

    @Override
    protected void onBlockHit(BlockHitResult result) {
        this.m_8060_(result);
        BlockState blockState = this.f_19853_.m_8055_(result.m_82425_());
        Block block = blockState.m_60734_();
        SoundEvent breakSound = blockState.m_60827_().m_56775_();
        if (this.f_19853_.m_6425_(result.m_82425_()).m_76152_() == Fluids.f_76193_) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DESounds.ES_BULLET_IMPACT_WATER.get(), SoundSource.NEUTRAL, 0.6f, 1.0f + 0.2f * this.f_19796_.nextFloat());
            this.waterSplashSoundPlayer = true;
        } else if (breakSound == SoundEvents.f_12442_ || block.m_204297_().m_203616_().anyMatch(res -> res.equals((Object)Tags.Blocks.STONE))) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DESounds.ES_BULLET_IMPACT_STONE.get(), SoundSource.NEUTRAL, 0.6f, 1.0f + 0.2f * this.f_19796_.nextFloat());
            this.soundPlayed = true;
        } else if (breakSound == SoundEvents.f_11983_ || block.m_204297_().m_203616_().anyMatch(res -> res.equals((Object)Tags.Blocks.GLASS))) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DESounds.ES_BULLET_IMPACT_GLASS.get(), SoundSource.NEUTRAL, 0.6f, 1.0f + 0.2f * this.f_19796_.nextFloat());
            this.soundPlayed = true;
        } else if (breakSound == SoundEvents.f_11988_ || breakSound == SoundEvents.f_11993_ || block.m_204297_().m_203616_().anyMatch(res -> res == Tags.Blocks.GRAVEL)) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DESounds.ES_BULLET_IMPACT_DIRT.get(), SoundSource.NEUTRAL, 0.6f, 1.0f + 0.2f * this.f_19796_.nextFloat());
            this.soundPlayed = true;
        } else if (breakSound == SoundEvents.f_12630_) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)DESounds.ES_BULLET_IMPACT_WOOD.get(), SoundSource.NEUTRAL, 0.6f, 1.0f + 0.2f * this.f_19796_.nextFloat());
            this.soundPlayed = true;
        }
        if (!this.f_19853_.m_5776_()) {
            this.m_6089_();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity hitEntity = result.m_82443_();
        hitEntity.f_19802_ = 0;
        if (!this.f_19853_.m_5776_()) {
            float bulletDamage = this.getBulletDamage();
            this.castersDamage(hitEntity, bulletDamage);
            Item item = ((ItemStack)this.item.get()).m_41720_();
            if (item instanceof BulletItem) {
                BulletItem bulletItem = (BulletItem)item;
                bulletItem.onEntityHurt(this, hitEntity, bulletDamage);
            }
            this.m_6089_();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            this.clientHitCallout((Vec3)fetcher.get(0));
        } else if (flag == 1) {
            this.m_20256_((Vec3)fetcher.get(0));
        } else if (flag == 2) {
            this.defaultDamage = ((Float)fetcher.get(0)).floatValue();
            this.defaultDegreeFall = ((Float)fetcher.get(1)).floatValue();
            this.defaultSpeed = ((Float)fetcher.get(2)).floatValue();
            this.defaultSpeedMult = ((Float)fetcher.get(3)).floatValue();
        } else if (flag == 3) {
            this.item.set((Object)((ItemStack)fetcher.get(0)));
        }
    }

    public void setItem(ItemStack item) {
        if (item == null) {
            item = ItemStack.f_41583_;
        }
        this.item.set((Object)item);
    }

    public void syncItem() {
        if (this.isAddedToWorld()) {
            this.sendClientMsg(3, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.ITEM_STACK, (Object)((ItemStack)this.item.get()))});
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientHitCallout(Vec3 hitPosition) {
        Item item;
        float red = 1.0f;
        float green = 0.75f;
        float blue = 0.0f;
        if (this.item.get() != null && (item = ((ItemStack)this.item.get()).m_41720_()) instanceof BulletItem) {
            BulletItem bulletItem = (BulletItem)item;
            red = bulletItem.redColor();
            green = bulletItem.greenColor();
            blue = bulletItem.blueColor();
        }
        for (int i = 0; i < 4 + this.f_19796_.nextInt(2); ++i) {
            DannyParticleData data = DEParticleUtil.dust(true, red, green, blue, this.f_19796_.nextFloat(0.08f, 0.1f), 0.85f, 0.85f);
            float f = 0.25f + this.f_19796_.nextFloat() * 0.35f;
            Vec3 vec = DEMath.fromPitchYaw(this.m_146909_() + (float)this.f_19796_.nextGaussian() * 30.0f, this.m_146908_() + (float)this.f_19796_.nextGaussian() * 30.0f).m_82490_((double)f);
            this.f_19853_.m_7106_((ParticleOptions)data, hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_, -vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
        }
        ShootLighSpeck light = new ShootLighSpeck(this.f_19853_, 0, 2, 8);
        light.setPosition(new Vec3(hitPosition.f_82479_, hitPosition.f_82480_, hitPosition.f_82481_));
        light.setLight((IPointLight)new SimplePointLight(new Vec3((double)red, (double)green, (double)blue), 1.5f, 0.35f, 0.5f));
        light.addToLevel();
    }

    public void sendHitMsg(Vec3 hitPos) {
        this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.VEC3, (Object)hitPos)});
    }

    public void syncDefaultValues() {
        this.sendClientMsg(2, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(this.defaultDamage)), WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(this.defaultDegreeFall)), WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(this.defaultSpeed)), WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(this.defaultSpeedMult)), WorldPacketData.of((SerializerMark)BuiltinSerializers.ITEM_STACK, (Object)((ItemStack)this.item.get()))});
    }

    protected void m_6089_() {
        this.onDeath();
        super.m_6089_();
    }

    public boolean canceledMovement() {
        return false;
    }

    @Override
    public HitResult rayTraceResultType() {
        return DERayUtil.bulletRaytrace((Entity)this, this::collisionParameters, DEMath.fromPitchYaw(this.m_146909_(), this.m_146908_()).m_82542_((double)this.getRealSpeed(), (double)this.getRealSpeed(), (double)this.getRealSpeed()), ClipContext.Fluid.NONE);
    }

    @Override
    public boolean collisionParameters(Entity entityIn) {
        return !entityIn.m_5833_() && entityIn != this.caster.get();
    }

    @Override
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_37283_() {
    }

    public void castersDamage(Entity livingEntity, float amount) {
        livingEntity.m_6469_(DEDamageSources.causeBulletDamage(this, (Entity)this.caster.get()), amount);
    }

    @Override
    @Nullable
    public Entity m_37282_() {
        return (Entity)this.caster.get();
    }

    public void m_5602_(@Nullable Entity p_37263_) {
    }

    protected boolean m_150171_(Entity p_150172_) {
        return p_150172_ == this.caster.get() || super.m_150171_(p_150172_);
    }

    public ItemStack getItem() {
        return (ItemStack)this.item.get();
    }

    public void setBulletDamage(float damage) {
        this.damage.set((Object)Float.valueOf(damage));
    }

    public void addBulletDamage(float damage) {
        this.damage.set((Object)Float.valueOf(this.getBulletDamage() + damage));
    }

    public void setBulletSpeedMult(float speedMult) {
        this.speed_mult.set((Object)Float.valueOf(speedMult));
    }

    public void addBulletSpeedMult(float speedMult) {
        this.speed_mult.set((Object)Float.valueOf(this.getBulletSpeed() + speedMult));
    }

    public void setBulletSpeed(float speed) {
        this.speed.set((Object)Float.valueOf(speed));
    }

    public void addBulletSpeed(float speed) {
        this.speed.set((Object)Float.valueOf(this.getBulletSpeed() + speed));
    }

    public void setDegreeFall(float fall) {
        this.degreeFall.set((Object)Float.valueOf(fall));
    }

    public void addDegreeFall(float fall) {
        this.degreeFall.set((Object)Float.valueOf(((Float)this.degreeFall.get()).floatValue() + fall));
    }

    public void setOrigin(LivingEntity livingEntity) {
        this.caster.set((Object)livingEntity);
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            BCAccessoryModule cap = PlayerHelper.braincellAccessoryModule(player);
            this.addBulletSpeedMult((cap.getLesserModifier(DEMiniAttributes.BULLET_SPEED_MLT) - 100.0f) / 100.0f);
        }
    }

    public final float getDefaultDamage() {
        return this.defaultDamage;
    }

    public final float getDefaultDegreeFall() {
        return this.defaultDegreeFall;
    }

    public final float getDefaultSpeed() {
        return this.defaultSpeed;
    }

    public final float getDefaultSpeedMult() {
        return this.defaultSpeedMult;
    }

    public float getBulletDamage() {
        return ((Float)this.damage.get()).floatValue();
    }

    public float getBulletSpeedMult() {
        return ((Float)this.speed_mult.get()).floatValue();
    }

    public float getBulletSpeed() {
        return ((Float)this.speed.get()).floatValue();
    }

    public float getRealSpeed() {
        return this.getBulletSpeed() * this.getBulletSpeedMult() * 0.16f;
    }

    public void setupForGun(Player player, float dispersion) {
        this.setupForGunPellet(player, dispersion, 0.0f, 0.0f);
    }

    public void setupForGunPellet(Player player, float dispersion, float globalDispersionX, float globalDispersionY) {
        BCAccessoryModule cap = PlayerHelper.braincellAccessoryModule(player);
        this.addBulletDamage(cap.getLesserModifier(DEMiniAttributes.GUN_DAMAGE_ADD));
        this.setBulletDamage(this.getBulletDamage() * cap.getLesserModifier(DEMiniAttributes.GUN_DAMAGE_MLT) / 100.0f);
        this.m_19890_(player.m_20185_(), player.m_20188_(), player.m_20189_(), player.f_20885_ + (float)((double)dispersion * this.f_19796_.nextGaussian()) + globalDispersionY, player.m_146909_() - PlayerHelper.gunModule(player).getRecoil() + (float)((double)dispersion / 2.0 * this.f_19796_.nextGaussian()) + globalDispersionX);
        this.setOrigin((LivingEntity)player);
        player.f_19853_.m_7967_((Entity)this);
    }

    @Override
    public BCDataManager bcDataManager() {
        return this.deDataManager;
    }
}

