/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.projectile.arrow;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManagerProvider;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityClientMessenger;
import bottomtextdanny.dannys_expansion.content.items.arrow.DEArrowItem;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class DEArrow
extends AbstractArrow
implements BCDataManagerProvider,
EntityClientMessenger {
    public static final int SET_TEXTURE_FLAG = 0;
    public static final EntityDataReference<ItemStack> PICK_ITEM_REF = BCDataManager.attribute(DEArrow.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.ITEM_STACK, () -> Items.f_42412_.m_7968_(), (String)"pick_item"));
    public static final EntityDataReference<Float> DAMAGE_REF = BCDataManager.attribute(DEArrow.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(2.0f), (String)"dmg"));
    public static final EntityDataReference<Float> WATER_INERTIA_REF = BCDataManager.attribute(DEArrow.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(1.0f), (String)"water_vel"));
    public static final EntityDataReference<Float> VELOCITY_FACTOR_REF = BCDataManager.attribute(DEArrow.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(1.0f), (String)"vel"));
    public static final EntityDataReference<Float> KNOCKBACK_REF = BCDataManager.attribute(DEArrow.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(0.0f), (String)"kb"));
    private final BCDataManager bcDataManager = new BCDataManager((Entity)this);
    @Nullable
    private IntOpenHashSet piercedEntities;
    @Nullable
    private List<Entity> hitEntities;
    private final EntityData<ItemStack> pickItem = this.bcDataManager().addSyncedData(EntityData.of(PICK_ITEM_REF));
    private final EntityData<Float> damage = this.bcDataManager().addSyncedData(EntityData.of(DAMAGE_REF));
    private final EntityData<Float> knockback = this.bcDataManager().addSyncedData(EntityData.of(KNOCKBACK_REF));
    private final EntityData<Float> velocityFactor = this.bcDataManager().addSyncedData(EntityData.of(VELOCITY_FACTOR_REF));
    private final EntityData<Float> waterInertia = this.bcDataManager().addSyncedData(EntityData.of(WATER_INERTIA_REF));

    public DEArrow(EntityType<? extends AbstractArrow> type, Level level) {
        super(type, level);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.f_19853_.f_46443_) {
            this.syncPickItem();
        }
    }

    protected void m_5790_(EntityHitResult result) {
        DamageSource damagesource;
        Entity entity1;
        Entity target = result.m_82443_();
        float f = (float)this.m_20184_().m_82553_();
        int i = Mth.m_14165_((double)Mth.m_14008_((double)((double)f * this.m_36789_()), (double)0.0, (double)2.147483647E9));
        if (this.m_36796_() > 0) {
            if (this.piercedEntities == null) {
                this.piercedEntities = new IntOpenHashSet(5);
            }
            if (this.hitEntities == null) {
                this.hitEntities = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.piercedEntities.size() >= this.m_36796_() + 1) {
                this.m_142687_(Entity.RemovalReason.KILLED);
                return;
            }
            this.piercedEntities.add(target.m_142049_());
        }
        if (this.m_36792_()) {
            long j = this.f_19796_.nextInt(i / 2 + 2);
            i = (int)Math.min(j + (long)i, Integer.MAX_VALUE);
        }
        if ((entity1 = this.m_37282_()) == null) {
            damagesource = DamageSource.m_19346_((AbstractArrow)this, (Entity)this);
        } else {
            damagesource = DamageSource.m_19346_((AbstractArrow)this, (Entity)entity1);
            if (entity1 instanceof LivingEntity) {
                ((LivingEntity)entity1).m_21335_(target);
            }
        }
        boolean flag = target.m_6095_() == EntityType.f_20566_;
        int k = target.m_20094_();
        if (this.m_6060_() && !flag) {
            target.m_20254_(5);
        }
        if (target.m_6469_(damagesource, (float)i)) {
            Item item = ((ItemStack)this.pickItem.get()).m_41720_();
            if (item instanceof DEArrowItem) {
                DEArrowItem arrowItem = (DEArrowItem)item;
                arrowItem.onEntityHurt(this, target, i);
            }
            if (flag) {
                return;
            }
            if (target instanceof LivingEntity) {
                Vec3 vector3d;
                LivingEntity livingTarget = (LivingEntity)target;
                float knockbackFactor = this.getKnockbackFactor();
                if (knockbackFactor > 0.0f && (vector3d = this.m_20184_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)knockbackFactor * 0.6)).m_82556_() > 0.0) {
                    livingTarget.m_5997_(vector3d.f_82479_, 0.1, vector3d.f_82481_);
                }
                if (!this.f_19853_.f_46443_ && entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingTarget);
                }
                this.m_7761_(livingTarget);
                if (entity1 != null && livingTarget != entity1 && livingTarget instanceof Player && entity1 instanceof ServerPlayer && !this.m_20067_()) {
                    ((ServerPlayer)entity1).f_8906_.m_141995_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                }
                if (!target.m_6084_() && this.hitEntities != null) {
                    this.hitEntities.add((Entity)livingTarget);
                }
                if (!this.f_19853_.f_46443_ && entity1 instanceof ServerPlayer) {
                    ServerPlayer serverplayerentity = (ServerPlayer)entity1;
                    if (this.hitEntities != null && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, this.hitEntities);
                    } else if (!target.m_6084_() && this.m_36795_()) {
                        CriteriaTriggers.f_10556_.m_46871_(serverplayerentity, Arrays.asList(target));
                    }
                }
            }
            this.m_5496_(this.m_7239_(), 1.0f, 1.2f / (this.f_19796_.nextFloat() * 0.2f + 0.9f));
            if (this.m_36796_() <= 0) {
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        } else {
            target.m_7311_(k);
            this.m_20256_(this.m_20184_().m_82490_(-0.1));
            this.m_146922_(this.m_146908_() + 180.0f);
            this.f_19859_ += 180.0f;
            if (!this.f_19853_.f_46443_ && this.m_20184_().m_82556_() < 1.0E-7) {
                if (this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
        }
    }

    public void m_37251_(Entity shooter, float rotationPitch, float rotationYaw, float pitchDelta, float velocity, float inaccuracy) {
        float f = -BCMath.sin((float)(rotationYaw * ((float)Math.PI / 180))) * BCMath.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        float f1 = -BCMath.sin((float)((rotationPitch + pitchDelta) * ((float)Math.PI / 180)));
        float f2 = BCMath.cos((float)(rotationYaw * ((float)Math.PI / 180))) * BCMath.cos((float)(rotationPitch * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, velocity, inaccuracy);
        Vec3 vector3d = shooter.m_20184_();
        this.m_20256_(this.m_20184_().m_82520_(vector3d.f_82479_, shooter.m_20096_() ? 0.0 : vector3d.f_82480_, vector3d.f_82481_));
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity * this.getVelocityFactor(), inaccuracy);
    }

    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            this.pickItem.set((Object)((ItemStack)fetcher.get(0)));
        }
    }

    public void setPickItem(ItemStack item) {
        if (item == null) {
            item = ItemStack.f_41583_;
        }
        this.pickItem.set((Object)item);
    }

    public void syncPickItem() {
        if (this.isAddedToWorld()) {
            this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.ITEM_STACK, (Object)this.m_7941_())});
        }
    }

    public void setDamage(float value) {
        this.damage.set((Object)Float.valueOf(value));
    }

    public void setKnockback(float value) {
        this.knockback.set((Object)Float.valueOf(value));
    }

    public void setVelocityFactor(float value) {
        this.velocityFactor.set((Object)Float.valueOf(value));
    }

    public void setWaterInertia(float value) {
        this.waterInertia.set((Object)Float.valueOf(value));
    }

    public ItemStack getPickItem() {
        return (ItemStack)this.pickItem.get();
    }

    public double m_36789_() {
        return this.getDamage();
    }

    public float getDamage() {
        return ((Float)this.damage.get()).floatValue();
    }

    public float getKnockbackFactor() {
        return ((Float)this.knockback.get()).floatValue();
    }

    public float getVelocityFactor() {
        return ((Float)this.velocityFactor.get()).floatValue();
    }

    public float m_6882_() {
        return ((Float)this.waterInertia.get()).floatValue();
    }

    protected ItemStack m_7941_() {
        return this.getPickItem();
    }

    public BCDataManager bcDataManager() {
        return this.bcDataManager;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

