/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.projectile;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExternalMotion;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleType;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion._util.DERayUtil;
import bottomtextdanny.dannys_expansion.content.entities.projectile.SpellEntity;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SquigBubbleEntity
extends SpellEntity {
    public static final float DEFAULT_POP_DAMAGE = 0.5f;
    public static final EntityDataReference<Float> BUBBLE_DAMAGE_REF = BCDataManager.attribute(SquigBubbleEntity.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.FLOAT, () -> Float.valueOf(0.5f), (String)"bubble_damage"));
    public static final EntityDataReference<Integer> HIT_COUNTER_REF = BCDataManager.attribute(SquigBubbleEntity.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.INTEGER, () -> 0, (String)"hit_counter"));
    public static final SimpleAnimation POP = new SimpleAnimation(22);
    public static final SimpleAnimation HURT = new SimpleAnimation(12);
    public static final AnimationArray ANIMATIONS = new AnimationArray(new Animation[]{POP, HURT});
    private final EntityData<Float> bubbleDamage;
    private final EntityData<Integer> hitCounter;
    public final AnimationHandler<SquigBubbleEntity> hurtModule = this.addAnimationHandler(new AnimationHandler((Entity)this));
    public final ExternalMotion hurtMotion;
    private final IntScheduler hitCooldownTimer;
    private LivingEntity target;
    private LivingEntity hitEntity;

    public SquigBubbleEntity(EntityType<? extends SpellEntity> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
        this.setLifeTime(200);
        this.bubbleDamage = this.bcDataManager().addSyncedData(EntityData.of(BUBBLE_DAMAGE_REF));
        this.hitCounter = this.bcDataManager().addSyncedData(EntityData.of(HIT_COUNTER_REF));
        this.hitCooldownTimer = IntScheduler.simple((int)10);
        this.hurtMotion = new ExternalMotion(0.95f);
    }

    @Override
    protected AnimationGetter getAnimations() {
        return ANIMATIONS;
    }

    @Override
    public void onLifeStart() {
        super.onLifeStart();
        this.m_5496_((SoundEvent)DESounds.ES_SQUIG_BUBBLE_GENERATE.get(), 1.5f, 1.0f + 0.1f * (float)this.f_19796_.nextInt(3));
    }

    @Override
    public void m_8119_() {
        boolean targetFlag;
        super.m_8119_();
        boolean bl = targetFlag = this.target != null && this.target.isAddedToWorld() && this.target.m_6084_();
        if (!this.f_19853_.m_5776_()) {
            this.hurtMotion.tick();
            this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.VEC3, (Object)this.hurtMotion.getAcceleratedMotion())});
        } else if (this.f_19796_.nextInt(8) == 2) {
            Connection.doClientSide(() -> this.randomParticleTick());
        }
        if (targetFlag && !this.mainHandler.isPlaying((Animation)POP)) {
            float speedMult = 1.0f;
            if (this.getLifeTick() < 35) {
                speedMult = (float)this.getLifeTick() / 35.0f;
            }
            speedMult = (float)((double)speedMult * 0.23);
            if (this.m_20069_()) {
                speedMult = (float)((double)speedMult * 0.6);
            }
            this.m_5997_((double)speedMult * this.forward.f_82479_, (double)speedMult * this.forward.f_82480_, (double)speedMult * this.forward.f_82481_);
            float yaw = (float)Mth.m_14139_((double)0.98, (double)this.m_146908_(), (double)DEMath.getTargetYaw(this, (Entity)this.target));
            float pitch = (float)Mth.m_14139_((double)0.98, (double)this.m_146909_(), (double)DEMath.getTargetPitch(this, (Entity)this.target));
            this.setRotations(yaw, pitch);
        }
        if (!this.f_19853_.m_5776_()) {
            this.hitCooldownTimer.incrementFreely(1);
            if (this.mainHandler.isPlaying((Animation)POP)) {
                if (this.mainHandler.getTick() == 6) {
                    if (this.hitEntity != null && this.hitEntity.isAddedToWorld() && this.hitEntity.m_6084_() && this.getCaster() != null && this.castersDamage(this.hitEntity, ((Float)this.bubbleDamage.get()).floatValue() * (float)this.f_19853_.m_46791_().ordinal())) {
                        this.hitEntity.f_19802_ = 0;
                    }
                    this.setDeath();
                }
            } else if (!targetFlag || this.getLifeTick() > this.maxLife - 10 || (Integer)this.hitCounter.get() >= 1) {
                this.mainHandler.play((Animation)POP);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void randomParticleTick() {
        Vec3 pos = this.m_20182_();
        this.f_19853_.m_7106_((ParticleOptions)new DannyParticleData((Supplier<DannyParticleType>)DEParticles.SQUIG_BUBBLE), pos.f_82479_ + this.f_19796_.nextGaussian() * 0.6, pos.f_82480_ + 0.25 + this.f_19796_.nextGaussian() * 0.6, pos.f_82481_ + this.f_19796_.nextGaussian() * 0.6, 0.0, 0.0, 0.0);
    }

    @Override
    public float getMotionDeceleration() {
        return this.target != null && this.target.isAddedToWorld() && this.target.m_6084_() ? 0.7f : 0.95f;
    }

    @Override
    public Vec3 finalMotion() {
        return super.finalMotion().m_82549_(this.hurtMotion.getAcceleratedMotion());
    }

    @Override
    public void onLifeEnd() {
        super.onLifeEnd();
        if (!this.f_19853_.f_46443_) {
            this.m_5496_((SoundEvent)DESounds.ES_SQUIG_BUBBLE_POP.get(), 1.2f, 1.0f + 0.1f * (float)this.f_19796_.nextInt(3));
            this.sendClientMsg(1);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        super.clientCallOutHandler(flag, fetcher);
        if (flag == 0) {
            this.hurtMotion.setMotion((Vec3)fetcher.get(0, Vec3.class));
        } else if (flag == 1) {
            Vec3 pos = this.m_20182_();
            this.f_19853_.m_7106_((ParticleOptions)new DannyParticleData((Supplier<DannyParticleType>)DEParticles.SQUIG_BUBBLE_POP), pos.f_82479_, pos.f_82480_ + 0.25, pos.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7313_(Entity entityIn) {
        return super.m_7313_(entityIn);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entityIn;
        if (!this.f_19853_.m_5776_() && this.hitCooldownTimer.hasEnded() && source.m_7639_() != null && (entityIn = source.m_7639_()).isAddedToWorld() && entityIn.m_6084_() && entityIn != this.getCaster()) {
            this.hitCounter.set((Object)((Integer)this.hitCounter.get() + 1));
            this.hurtModule.play((Animation)HURT);
            this.m_5496_((SoundEvent)DESounds.ES_SQUIG_BUBBLE_HIT.get(), 0.7f, 1.0f + 0.1f * (float)this.f_19796_.nextInt(3));
            Vec3 invLook = DEMath.fromPitchYaw(-this.m_146909_(), this.m_146908_() + 180.0f).m_82490_(1.1);
            this.hurtMotion.addMotion(invLook);
            this.hitCooldownTimer.reset();
        }
        return super.m_6469_(source, amount);
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        this.setDeath();
        return super.m_7111_(player, vec, hand);
    }

    @Override
    public HitResult rayTraceResultType() {
        return DERayUtil.orbRaytrace(this, this::collisionParameters, this.finalMotion(), ClipContext.Fluid.ANY, 0.1f);
    }

    @Override
    protected void onBlockHit(BlockHitResult p_230299_1_) {
        super.onBlockHit(p_230299_1_);
    }

    @Override
    protected void onEntityHit(EntityHitResult p_213868_1_) {
        super.onEntityHit(p_213868_1_);
        if (!this.f_19853_.m_5776_()) {
            if (p_213868_1_.m_82443_() instanceof LivingEntity) {
                this.hitEntity = (LivingEntity)p_213868_1_.m_82443_();
            }
            if (!this.mainHandler.isPlaying((Animation)POP)) {
                this.mainHandler.play((Animation)POP);
            }
        }
    }

    public boolean m_6087_() {
        return !this.hitCooldownTimer.hasEnded();
    }

    public void setBobbleDamage(float damage) {
        this.bubbleDamage.set((Object)Float.valueOf(damage));
    }

    public void setTarget(LivingEntity target) {
        this.target = target;
    }
}

