/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.projectile;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion.content.entities.projectile.DEProjectile;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IceSpike
extends DEProjectile {
    public static final int COLLISION_CLIENT_CALL = 0;
    public static final float MOVEMENT_SPEED = 1.4f;

    public IceSpike(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    @Override
    public void commonInit() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.m_20256_(this.m_20154_().m_82490_((double)1.4f));
        } else {
            Connection.doClientSide(() -> this.clientTick());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick() {
        if (this.f_19796_.nextInt(2) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)DEParticles.ICY_CLOUD.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.nextGaussian() * 0.1, this.f_19796_.nextGaussian() * 0.1, this.f_19796_.nextGaussian() * 0.1);
        }
        if (this.f_19796_.nextInt(2) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)DEParticles.SNOWFLAKE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.nextGaussian() * 0.1, this.f_19796_.nextGaussian() * 0.1, this.f_19796_.nextGaussian() * 0.1);
        }
    }

    @Override
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            Vec3 location = (Vec3)fetcher.get(0);
            this.f_19853_.m_7106_((ParticleOptions)DEParticles.ICY_CIRCULAR_SMOKE.get(), location.m_7096_(), location.m_7098_() + 0.01, location.m_7094_(), 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_ && result.m_6662_() != HitResult.Type.MISS) {
            this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.VEC3, (Object)result.m_82450_())});
        }
        super.m_6532_(result);
    }

    @Override
    protected void onBlockHit(BlockHitResult result) {
        super.onBlockHit(result);
        this.removeProjectile();
    }

    @Override
    protected void onEntityHit(EntityHitResult result, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.getCaster() == null || living != this.getCaster()) {
                boolean effectiveHurt = living.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)this.getCaster()), (float)this.getCasterAttribute(Attributes.f_22281_));
                if (effectiveHurt && this.f_19796_.nextFloat() < 0.3f * (float)this.f_19853_.m_46791_().m_19028_()) {
                    entity.m_146917_(entity.m_146888_() + 40);
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 30));
                }
                this.removeProjectile();
            }
        }
    }

    @Override
    protected void removeCallOut() {
        this.m_5496_((SoundEvent)DESounds.ES_ICE_SPIKE_HIT.get(), 1.0f, 0.9f + this.f_19796_.nextFloat() * 0.2f);
    }

    @Override
    public int baseLifetime() {
        return 80;
    }
}

