/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.projectile;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimatableModule;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimatableProvider;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationHandler;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManagerProvider;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.world.entity_utilities.EntityClientMessenger;
import bottomtextdanny.dannys_expansion._util.DERayUtil;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public abstract class DEProjectile
extends Projectile
implements BCDataManagerProvider,
EntityClientMessenger,
AnimatableProvider {
    private static final int BASE_UPDATE_TICK_CLIENT_FLAG = 0;
    public static final EntityDataReference<Entity> CASTER_REF = BCDataManager.attribute(DEProjectile.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.ENTITY_REFERENCE, () -> null, (String)"caster"));
    public static final EntityDataReference<Integer> ACTUAL_TICK_REF = BCDataManager.attribute(DEProjectile.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.INTEGER, () -> 0, (String)"actual_tick"));
    private BCDataManager deDataManager;
    private AnimatableModule animatableModule;
    protected final EntityData<Integer> actualTick;
    protected final EntityData<Entity> caster;
    public final AnimationHandler<DEProjectile> mainModule = this.operateAnimatableModule() ? this.addAnimationHandler(new AnimationHandler((Entity)this)) : null;
    private int lifetime;

    public DEProjectile(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
        this.deDataManager = new BCDataManager((Entity)this);
        this.caster = this.deDataManager.addSyncedData(EntityData.of(CASTER_REF));
        this.actualTick = this.deDataManager.addSyncedData(EntityData.of(ACTUAL_TICK_REF));
    }

    protected void m_8097_() {
        this.lifetime = this.baseLifetime();
        this.animatableModule = new AnimatableModule((Entity)this, this.getAnimations());
        this.commonInit();
    }

    protected AnimationGetter getAnimations() {
        return null;
    }

    public abstract void commonInit();

    public AnimatableModule animatableModule() {
        return this.animatableModule;
    }

    public BCDataManager bcDataManager() {
        return this.deDataManager;
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 delta = this.m_20184_();
        if ((Integer)this.actualTick.get() < this.lifetime) {
            this.actualTick.set((Object)((Integer)this.actualTick.get() + 1));
        } else if (!this.f_19853_.f_46443_) {
            this.removeProjectile();
        }
        if (!this.f_19853_.f_46443_) {
            HitResult raytraceresult = this.rayTraceResultType();
            this.m_6532_(raytraceresult);
            this.sendClientMsg(0, PacketDistributor.TRACKING_ENTITY.with(() -> this), new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.VEC3, (Object)delta)});
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20101_();
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type type = result.m_6662_();
        if (this.caster.get() != null) {
            if (type == HitResult.Type.ENTITY) {
                this.onEntityHit((EntityHitResult)result, ((EntityHitResult)result).m_82443_());
            } else if (type == HitResult.Type.BLOCK) {
                this.onBlockHit((BlockHitResult)result);
            }
        } else {
            this.removeProjectile();
        }
    }

    protected void onBlockHit(BlockHitResult result) {
    }

    protected void onEntityHit(EntityHitResult result, Entity entity) {
    }

    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            Vec3 serverDeltaMovement = (Vec3)fetcher.get(0, Vec3.class);
            this.m_20256_(serverDeltaMovement);
        }
    }

    public void removeProjectile() {
        this.removeCallOut();
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public HitResult rayTraceResultType() {
        return DERayUtil.bulletRaytrace((Entity)this, this::collisionParameters, this.m_20184_(), ClipContext.Fluid.NONE);
    }

    public boolean collisionParameters(Entity entityIn) {
        if (!entityIn.m_6084_() || entityIn.m_146910_()) {
            return false;
        }
        if (!entityIn.m_6087_()) {
            return false;
        }
        return EntitySelector.f_20406_.test(entityIn) && entityIn != this.caster.get();
    }

    protected void removeCallOut() {
    }

    public void setCaster(LivingEntity livingEntity) {
        this.caster.set((Object)livingEntity);
        this.m_5602_((Entity)livingEntity);
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int baseLifetime() {
        return 10;
    }

    public LivingEntity getCaster() {
        return (LivingEntity)this.caster.get();
    }

    protected double getCasterAttribute(Attribute attribute) {
        return this.getCaster().m_21051_(attribute).m_22135_();
    }

    public int getLifeTick() {
        return (Integer)this.actualTick.get();
    }

    @Nullable
    public Entity m_37282_() {
        return (Entity)this.caster.get();
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

