/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.projectile;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.capability.level.speck.ShootLighSpeck;
import bottomtextdanny.braincell.mod.graphics.point_lighting.IPointLight;
import bottomtextdanny.braincell.mod.graphics.point_lighting.SimplePointLight;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._util.DEMath;
import bottomtextdanny.dannys_expansion._util.DEParticleUtil;
import bottomtextdanny.dannys_expansion._util.DERayUtil;
import bottomtextdanny.dannys_expansion.content.entities.projectile.DEProjectile;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CursedFireball
extends DEProjectile {
    public static final int COLLISION_CLIENT_CALL = 0;
    public static final float MOVEMENT_SPEED = 1.5f;

    public CursedFireball(EntityType<? extends Projectile> type, Level level) {
        super(type, level);
    }

    @Override
    public void commonInit() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.m_20256_(this.m_20154_().m_82490_(1.5));
        } else {
            Connection.doClientSide(() -> this.clientTick());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick() {
        if (this.f_19796_.nextInt(2) == 0) {
            DannyParticleData data = DEParticleUtil.dust(true, -4129024, this.f_19796_.nextFloat(0.1f, 0.15f), 0.9f, 0.9f);
            this.f_19853_.m_7106_((ParticleOptions)data, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.nextGaussian() * 0.4, this.f_19796_.nextGaussian() * 0.4, this.f_19796_.nextGaussian() * 0.4);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            Vec3 location = (Vec3)fetcher.get(0);
            for (int i = 0; i < 5; ++i) {
                DannyParticleData data = DEParticleUtil.dust(true, -4129024, this.f_19796_.nextFloat(0.12f, 0.16f), 0.85f, 0.85f);
                float f = 0.25f + this.f_19796_.nextFloat() * 0.35f;
                Vec3 vec = DEMath.fromPitchYaw(this.m_146909_() + (float)this.f_19796_.nextGaussian() * 30.0f, this.m_146908_() + (float)this.f_19796_.nextGaussian() * 30.0f).m_82490_((double)f);
                this.f_19853_.m_7106_((ParticleOptions)data, location.f_82479_, location.f_82480_, location.f_82481_, -vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
            }
            ShootLighSpeck light = new ShootLighSpeck(this.f_19853_, 0, 2, 8);
            light.setPosition(new Vec3(location.f_82479_, location.f_82480_, location.f_82481_));
            light.setLight((IPointLight)new SimplePointLight(new Vec3(0.2, 1.0, 0.0), 1.5f, 0.35f, 0.5f));
            light.addToLevel();
        }
    }

    @Override
    protected void m_6532_(HitResult result) {
        if (!this.f_19853_.f_46443_ && result.m_6662_() != HitResult.Type.MISS) {
            this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.VEC3, (Object)result.m_82450_())});
        }
        super.m_6532_(result);
    }

    @Override
    protected void onBlockHit(BlockHitResult result) {
        super.onBlockHit(result);
        this.removeProjectile();
    }

    @Override
    protected void onEntityHit(EntityHitResult result, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (this.getCaster() == null || living != this.getCaster()) {
                boolean effectiveHurt = living.m_6469_(DamageSource.m_19340_((Entity)this, (LivingEntity)this.getCaster()), (float)this.getCasterAttribute(Attributes.f_22281_));
                this.removeProjectile();
            }
        }
    }

    @Override
    public HitResult rayTraceResultType() {
        return DERayUtil.orbRaytrace((Entity)this, this::collisionParameters, this.m_20184_(), ClipContext.Fluid.NONE, 0.25f);
    }

    @Override
    protected void removeCallOut() {
        this.m_5496_((SoundEvent)DESounds.ES_CURSED_FIREBALL_HIT.get(), 1.0f, 0.9f + this.f_19796_.nextFloat() * 0.2f);
    }

    @Override
    public int baseLifetime() {
        return 80;
    }
}

