/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.squig;

import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.MarkedTimer;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.AnimationAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessor;
import bottomtextdanny.braincell.mod.entity.psyche.pos_finder.MobPosProcessors;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.dannys_expansion._util.DERayUtil;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.ai.HoverProfile;
import bottomtextdanny.dannys_expansion.content.entities.ai.controllers.MGLookController;
import bottomtextdanny.dannys_expansion.content.entities.mob.squig.Squig;
import bottomtextdanny.dannys_expansion.content.entities.projectile.SpellEntity;
import bottomtextdanny.dannys_expansion.content.entities.projectile.SquigBubbleEntity;
import bottomtextdanny.dannys_expansion.tables.DEEntities;
import java.util.Comparator;
import java.util.function.Function;
import java.util.random.RandomGenerator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class SquigPsyche
extends Psyche<Squig> {
    private static final int IMPULSE_MODULE = 1;
    private static MobPosPredicate<Object> STABILIZE = MobPosPredicates.isSolid().negate().and(MobPosPredicates.noFluid());
    private static HoverProfile HOVER_PROFILE = new HoverProfile(STABILIZE, 6, 20);
    private static MobPosProcessor<Object> IDLE_POS = (pos, mob, r, extra) -> {
        HOVER_PROFILE.update(mob);
        float yOffset = 0.0f;
        if (HOVER_PROFILE.isGroundLowerThan(15)) {
            yOffset = -32.0f;
        } else if (!HOVER_PROFILE.isGroundLowerThan(8)) {
            yOffset = 6.0f;
        } else if (!HOVER_PROFILE.isCeilingHigher(5)) {
            yOffset = -6.0f;
        }
        return MobPosProcessors.sample((int)10, (MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.randomOffset((int)4, (int)4, (int)4)).push(MobPosProcessors.offset((int)0, (int)((int)(yOffset *= r.nextFloat(0.5f, 1.0f))), (int)0)), SquigPsyche.evaluatePos((Squig)mob)).compute(pos, mob, r, extra);
    };
    private static MobPosProcessor<LivingEntity> COMBAT_POS = (pos, mob, r, extra) -> {
        HOVER_PROFILE.update(mob);
        int yOffset = 0;
        if (!HOVER_PROFILE.isGroundLowerThan(5)) {
            yOffset = 3;
        } else if (!HOVER_PROFILE.isCeilingHigher(5)) {
            yOffset = -3;
        }
        yOffset = (int)((float)yOffset * r.nextFloat());
        return MobPosProcessors.sample((int)10, (MobPosProcessor)MobPosProcessors.stack().push(MobPosProcessors.randomOffset((int)4, (int)4, (int)4)).push(MobPosProcessors.offset((int)0, (int)yOffset, (int)0)), SquigPsyche.evaluateCombatPos((Entity)mob)).compute(pos, mob, r, extra);
    };
    private final MarkedTimer unseenTimer = new MarkedTimer((IntScheduler)IntScheduler.simple((int)100));
    private ImpulseAction impulseAction;

    public SquigPsyche(Squig mob) {
        super((PathfinderMob)mob);
        this.allocateModules(4);
    }

    protected void populateInputs(UnbuiltActionInputs unbuiltActionInputs) {
        unbuiltActionInputs.put(ActionInputKey.MARKED_UNSEEN, () -> this.unseenTimer);
    }

    protected void initialize() {
        this.impulseAction = new ImpulseAction((Squig)this.getMob());
        ConstantThoughtAction global = new ConstantThoughtAction((PathfinderMob)((Squig)this.getMob()), mob -> {
            SquigPsyche.rotateToTarget(mob);
            mob.m_20242_(true);
            mob.f_19789_ = 0.0f;
            SquigPsyche.tryChangeTarget(mob, IDLE_POS);
            this.tryDoImpulse((Squig)((Object)mob));
        });
        this.tryAddRunningAction(0, (Action)global);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
    }

    protected void tryDoImpulse(Squig mob) {
        IntScheduler delay = mob.getImpulseDelay();
        if (delay.hasEnded()) {
            delay.reset();
            Vec3 impulseVector = Vec3.m_82498_((float)mob.m_146909_(), (float)mob.m_6080_()).m_82490_(4.0);
            impulseVector = impulseVector.m_82549_(mob.m_20182_());
            if (mob.m_21187_().nextFloat() < 0.1f || DERayUtil.noCollision(mob.f_19853_, mob.m_20182_(), impulseVector)) {
                this.tryAddRunningAction(1, (Action)this.impulseAction);
            }
        }
        delay.incrementFreely(1);
    }

    protected static void tryChangeTarget(Squig mob, MobPosProcessor<Object> finder) {
        IntScheduler wait = mob.getChangeTargetThreshold();
        wait.incrementFreely(1);
        if ((SquigPsyche.canChangeTarget(mob) || wait.hasEnded()) && SquigPsyche.changeTarget(mob)) {
            wait.reset();
        }
    }

    protected static boolean changeTarget(Squig mob) {
        BlockPos pos = CombatHelper.isValidAttackTarget((LivingEntity)mob.m_5448_()) ? COMBAT_POS.compute(mob.m_142538_(), (Mob)mob, (RandomGenerator)mob.m_21187_(), (Object)mob.m_5448_()) : IDLE_POS.compute(mob.m_142538_(), (Mob)mob, (RandomGenerator)mob.m_21187_(), null);
        if (pos == null) {
            return false;
        }
        Vec2 newLook = Shared.rotationsToTarget((Position)mob.m_20182_(), (Position)Vec3.m_82512_((Vec3i)pos));
        mob.setTargetLook(newLook.f_82470_, newLook.f_82471_);
        return true;
    }

    protected static void rotateToTarget(Squig mob) {
        LookControl lookControl = mob.m_21563_();
        if (!(lookControl instanceof MGLookController)) {
            return;
        }
        MGLookController look = (MGLookController)lookControl;
        look.setTargetPitch(mob.getXTarget(), 3.0f);
        look.setTargetYaw(mob.getYTarget(), 3.0f);
    }

    protected static boolean canChangeTarget(Squig mob) {
        float xDiff = Math.abs(mob.getXTarget() - mob.m_146909_());
        float yDiff = Math.abs(mob.getYTarget() - mob.m_6080_());
        return xDiff < 5.0f && yDiff < 5.0f;
    }

    private static Function<Object, Comparator<BlockPos>> evaluatePos(Squig mob) {
        return ignored -> Comparator.comparingDouble(pos -> {
            if (pos == null) {
                return 3.4028234663852886E38;
            }
            Vec3 asVector = Vec3.m_82512_((Vec3i)pos);
            double value = 0.0;
            if (DERayUtil.noCollision(mob.f_19853_, mob.m_146892_(), asVector)) {
                value += 256.0;
            }
            return value -= Vec3.m_82512_((Vec3i)mob.getHome()).m_82554_(asVector);
        });
    }

    private static Function<LivingEntity, Comparator<BlockPos>> evaluateCombatPos(Entity mob) {
        return target -> Comparator.comparingDouble(pos -> {
            if (pos == null) {
                return Float.MIN_VALUE;
            }
            Vec3 asVector = Vec3.m_82512_((Vec3i)pos);
            double value = 0.0;
            if (DERayUtil.noCollision(mob.f_19853_, mob.m_146892_(), asVector)) {
                value += 256.0;
            }
            return value -= target.m_20182_().m_82557_(asVector) / 200.0;
        });
    }

    protected static final class ImpulseAction
    extends AnimationAction<Squig, SimpleAnimation> {
        public ImpulseAction(Squig mob) {
            super((PathfinderMob)mob, (Animation)Squig.IMPULSE, mob.mainHandler);
        }

        protected void update() {
            super.update();
            int tick = ((Squig)this.mob).mainHandler.getTick();
            if (tick == 7) {
                Vec3 pos = ((Squig)this.mob).m_20182_();
                Vec3 impulseVector = Vec3.m_82498_((float)((Squig)this.mob).m_146909_(), (float)((Squig)this.mob).m_6080_()).m_82490_(0.45);
                ((Squig)this.mob).getImpulseMotion().addMotion(impulseVector);
                ((Squig)this.mob).tellClientToDoImpulse();
                if (CombatHelper.isValidAttackTarget((LivingEntity)((Squig)this.mob).m_5448_())) {
                    Vec3 move = Vec3.m_82498_((float)(((Squig)this.mob).m_146909_() + 20.0f * (float)RANDOM.nextGaussian()), (float)(((Squig)this.mob).m_6080_() + 20.0f * (float)RANDOM.nextGaussian())).m_82490_(-1.0);
                    Vec3 mot = move.m_82490_(0.45 + 0.25 * RANDOM.nextGaussian());
                    SquigBubbleEntity bubble = new SquigBubbleEntity((EntityType<? extends SpellEntity>)((EntityType)DEEntities.SQUIG_BUBBLE.get()), ((Squig)this.mob).f_19853_);
                    bubble.setCaster((LivingEntity)this.mob);
                    bubble.setBobbleDamage(1.5f);
                    bubble.setTarget(((Squig)this.mob).m_5448_());
                    bubble.m_19890_(pos.f_82479_ + move.f_82479_, pos.f_82480_ + 0.31 + move.f_82480_, pos.f_82481_ + move.f_82481_, 0.0f, 0.0f);
                    bubble.hurtMotion.addMotion(mot.f_82479_, mot.f_82480_, mot.f_82481_);
                    ((Squig)this.mob).f_19853_.m_7967_((Entity)bubble);
                }
            }
        }
    }
}

