/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.squig;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.WorldPacketData;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod._mod.client_sided.variant_data.SimpleVariantRenderingData;
import bottomtextdanny.braincell.mod._mod.client_sided.variant_data.VariantRenderingData;
import bottomtextdanny.braincell.mod.capability.CapabilityHelper;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExternalMotion;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExtraMotionModule;
import bottomtextdanny.braincell.mod.entity.modules.additional_motion.ExtraMotionProvider;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedFormManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedVariableModule;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.braincell.mod.network.Connection;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelCapability;
import bottomtextdanny.dannys_expansion._base.capabilities.world.LevelPhaseModule;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleType;
import bottomtextdanny.dannys_expansion.content._client.rendering.entity.mob.SquigRenderer;
import bottomtextdanny.dannys_expansion.content.entities.ai.controllers.MGLookController;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.squig.SquigPsyche;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import bottomtextdanny.dannys_expansion.tables._client.DEParticles;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Squig
extends SmartyMob
implements ExtraMotionProvider {
    private static final int UPDATE_YAW_OFFSET_FLAG = 0;
    private static final int IMPULSE_FLAG = 1;
    public static final SquigForm BLUE = new SquigForm(new ResourceLocation("dannys_expansion", "textures/entity/squig/freedom_squig.png"), 0, 0);
    public static final SquigForm GREEN = new SquigForm(new ResourceLocation("dannys_expansion", "textures/entity/squig/harmony_squig.png"), 2, 2);
    public static final SquigForm RED = new SquigForm(new ResourceLocation("dannys_expansion", "textures/entity/squig/courage_squig.png"), 1, 1);
    public static final SquigForm PURPLE = new SquigForm(new ResourceLocation("dannys_expansion", "textures/entity/squig/luxury_squig.png"), 3, 3);
    public static final IndexedFormManager FORMS = IndexedFormManager.builder().add((Form)BLUE).add((Form)GREEN).add((Form)RED).add((Form)PURPLE).create();
    public static final EntityDataReference<BlockPos> HOME_REF = BCDataManager.attribute(Squig.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BLOCK_POS, () -> BlockPos.f_121853_, (String)"home"));
    public static final EntityDataReference<Boolean> UPDATED_HOME_REF = BCDataManager.attribute(Squig.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BOOLEAN, () -> false, (String)"updated_home"));
    public static final SimpleAnimation IMPULSE = new SimpleAnimation(15);
    private final EntityData<BlockPos> home = this.bcDataManager().addNonSyncedData(EntityData.of(HOME_REF));
    private final EntityData<Boolean> updatedHome = this.bcDataManager().addNonSyncedData(EntityData.of(UPDATED_HOME_REF));
    private ExtraMotionModule extraMotionModule;
    private ExternalMotion impulseMotion;
    private final IntScheduler.Simple changeTargetThreshold = IntScheduler.simple((int)60);
    private final IntScheduler.Ranged impulseDelay = IntScheduler.ranged((int)60, (int)80);
    private float xTarget;
    private float yTarget;
    private float offsetYawTarget;
    private float offsetYaw;
    private float offsetYawO;

    public Squig(EntityType<? extends Squig> type, Level worldIn) {
        super(type, worldIn);
        this.f_21365_ = new MGLookController((Mob)this);
    }

    public static AttributeSupplier.Builder attributes() {
        return Squig.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22278_, 0.9);
    }

    public static boolean spawnPlacement(EntityType<Squig> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, Random randomIn) {
        Level level;
        int worldPhaseOrdinal;
        if (worldIn.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        if (worldIn instanceof Level && (worldPhaseOrdinal = ((LevelCapability)CapabilityHelper.get((Object)(level = (Level)worldIn), LevelCapability.TOKEN)).getPhaseModule().getPhase().ordinal()) < LevelPhaseModule.Phase.DRAGON.ordinal()) {
            return false;
        }
        if (pos.m_123342_() < worldIn.m_5736_()) {
            return false;
        }
        if (pos.m_123342_() > worldIn.m_5736_() + 20) {
            return false;
        }
        if (Biome.m_204183_((Holder)worldIn.m_204166_(pos)) != Biome.BiomeCategory.OCEAN) {
            return false;
        }
        return worldIn.m_6106_().m_6533_();
    }

    protected void commonInit() {
        super.commonInit();
        this.variableModule = new IndexedVariableModule((LivingEntity)this, FORMS);
        this.extraMotionModule = new ExtraMotionModule((Entity)this);
        this.impulseMotion = this.addCustomMotion(new ExternalMotion(0.96f));
    }

    @Override
    public Psyche<?> makePsyche() {
        return new SquigPsyche(this);
    }

    protected BodyRotationControl m_7560_() {
        return new Body((Mob)this);
    }

    public LookControl m_21563_() {
        return this.f_21365_;
    }

    public AnimationGetter getAnimations() {
        return IMPULSE;
    }

    public Form<?> chooseVariant() {
        int rng = this.f_19796_.nextInt(100);
        if (rng <= 50) {
            return BLUE;
        }
        if (rng <= 69) {
            return RED;
        }
        if (rng <= 88) {
            return GREEN;
        }
        if (rng <= 95) {
            return PURPLE;
        }
        return BLUE;
    }

    public ExtraMotionModule extraMotionModule() {
        return this.extraMotionModule;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.checkHome();
            if (this.offsetYawO != this.offsetYaw) {
                this.syncYawOffsetTarget();
            }
        }
        Connection.doClientSide(() -> this.clientTick());
    }

    public void checkHome() {
        if (!((Boolean)this.updatedHome.get()).booleanValue()) {
            this.home.set((Object)this.m_142538_());
            this.updatedHome.set((Object)true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick() {
        this.offsetYawO = this.offsetYaw;
        this.offsetYaw = Mth.m_14179_((float)0.1f, (float)this.offsetYaw, (float)this.offsetYawTarget);
    }

    public void syncYawOffsetTarget() {
        this.offsetYawO = this.offsetYaw;
        this.sendClientMsg(0, new WorldPacketData[]{WorldPacketData.of((SerializerMark)BuiltinSerializers.FLOAT, (Object)Float.valueOf(this.offsetYawTarget))});
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateYawOffset(int serverTarget) {
        this.offsetYawTarget = serverTarget;
    }

    public void tellClientToDoImpulse() {
        this.sendClientMsg(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientImpulse() {
        ClientLevel clientLevel = (ClientLevel)this.f_19853_;
        SquigForm form = this.getForm();
        if (form == null) {
            return;
        }
        Vec3 pos = this.m_20182_();
        Vec3 lookVec = Vec3.m_82498_((float)this.m_146909_(), (float)this.m_6080_()).m_82490_(-1.5);
        Vec3 ringPos = pos.m_82549_(lookVec).m_82520_(0.0, 0.31, 0.0);
        DannyParticleData ringParticle = new DannyParticleData((Supplier<DannyParticleType>)DEParticles.SQUIG_RING, form.getRingSprite(), Float.valueOf(this.m_6080_() - 180.0f), Float.valueOf(-this.m_146909_()));
        DannyParticleData crossData = new DannyParticleData((Supplier<DannyParticleType>)DEParticles.SQUIG_CROSS, form.getCrossSprite());
        clientLevel.m_7106_((ParticleOptions)ringParticle, ringPos.f_82479_, ringPos.f_82480_, ringPos.f_82481_, lookVec.f_82479_ * 0.2, lookVec.f_82480_ * 0.2, lookVec.f_82481_ * 0.2);
        int rgn = this.f_19796_.nextInt(4) + 3;
        for (int i = 0; i < rgn; ++i) {
            Vec3 move = Vec3.m_82498_((float)(this.m_146909_() + 30.0f * (float)this.f_19796_.nextGaussian()), (float)(this.m_146908_() + 30.0f * (float)this.f_19796_.nextGaussian())).m_82490_(-1.0);
            Vec3 mot = move.m_82490_(0.25 + 0.15 * this.f_19796_.nextGaussian());
            clientLevel.m_7106_((ParticleOptions)crossData, pos.f_82479_ + move.f_82479_, pos.f_82480_ + 0.31 + move.f_82480_, pos.f_82481_ + move.f_82481_, mot.f_82479_, mot.f_82480_, mot.f_82481_);
        }
        this.offsetYawTarget += 340.0f;
        clientLevel.m_7785_(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_(), (SoundEvent)DESounds.ES_SQUIG_JUMP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        if (flag == 0) {
            this.updateYawOffset((Integer)fetcher.get(0));
        } else if (flag == 1) {
            this.clientImpulse();
        }
    }

    public void setTargetLook(float x, float y) {
        this.xTarget = x;
        this.yTarget = y;
    }

    private SquigForm getForm() {
        SquigForm squigForm;
        Form form = this.variableModule.getForm();
        return form instanceof SquigForm ? (squigForm = (SquigForm)form) : null;
    }

    public BlockPos getHome() {
        return (BlockPos)this.home.get();
    }

    public IntScheduler getChangeTargetThreshold() {
        return this.changeTargetThreshold;
    }

    public IntScheduler getImpulseDelay() {
        return this.impulseDelay;
    }

    public float getXTarget() {
        return this.xTarget;
    }

    public float getYTarget() {
        return this.yTarget;
    }

    public float getOffsetYaw() {
        return this.offsetYaw;
    }

    public float getOffsetYawO() {
        return this.offsetYawO;
    }

    public ExternalMotion getImpulseMotion() {
        return this.impulseMotion;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)DESounds.ES_SQUIG_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DESounds.ES_SQUIG_HURT.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DESounds.ES_SQUIG_IDLE.get();
    }

    public boolean m_6785_(double v) {
        return true;
    }

    public static class Body
    extends BodyRotationControl {
        private final Mob mob;
        private static final int HEAD_STABLE_ANGLE = 15;
        private static final int DELAY_UNTIL_STARTING_TO_FACE_FORWARD = 10;
        private static final int HOW_LONG_IT_TAKES_TO_FACE_FORWARD = 10;
        private int headStableTime;
        private float lastStableYHeadRot;

        public Body(Mob mob) {
            super(mob);
            this.mob = mob;
        }

        public void m_8121_() {
            if (this.isMoving()) {
                this.mob.f_20883_ = this.mob.m_146908_();
                this.rotateHeadIfNecessary();
                this.lastStableYHeadRot = this.mob.f_20885_;
                this.headStableTime = 0;
            } else if (this.notCarryingMobPassengers()) {
                if (Math.abs(this.mob.f_20885_ - this.lastStableYHeadRot) > 15.0f) {
                    this.headStableTime = 0;
                    this.lastStableYHeadRot = this.mob.f_20885_;
                    this.rotateBodyIfNecessary();
                } else {
                    ++this.headStableTime;
                }
            }
        }

        private void rotateBodyIfNecessary() {
            this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)this.mob.m_8085_());
        }

        private void rotateHeadIfNecessary() {
            this.mob.f_20885_ = Mth.m_14094_((float)this.mob.f_20885_, (float)this.mob.f_20883_, (float)this.mob.m_8085_());
        }

        private void rotateHeadTowardsFront() {
            int i = this.headStableTime - 10;
            float f = Mth.m_14036_((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
            float f1 = (float)this.mob.m_8085_() * (1.0f - f);
            this.mob.f_20883_ = Mth.m_14094_((float)this.mob.f_20883_, (float)this.mob.f_20885_, (float)f1);
        }

        private boolean notCarryingMobPassengers() {
            return !(this.mob.m_146895_() instanceof Mob);
        }

        private boolean isMoving() {
            double d1;
            double d0 = this.mob.m_20185_() - this.mob.f_19854_;
            return d0 * d0 + (d1 = this.mob.m_20189_() - this.mob.f_19856_) * d1 > 2.500000277905201E-7;
        }
    }

    public static class SquigForm
    extends Form<Squig> {
        private final ResourceLocation texture = (ResourceLocation)Connection.makeClientSideOrElse(() -> texture, () -> texture);
        private final int crossSprite;
        private final int ringSprite;

        public SquigForm(ResourceLocation texture, int crossSprite, int ringSprite) {
            this.crossSprite = crossSprite;
            this.ringSprite = ringSprite;
        }

        public int getCrossSprite() {
            return this.crossSprite;
        }

        public int getRingSprite() {
            return this.ringSprite;
        }

        @OnlyIn(value=Dist.CLIENT)
        protected VariantRenderingData<Squig> createRenderingHandler() {
            return new SimpleVariantRenderingData(this.texture, (EntityModel)SquigRenderer.MODEL);
        }
    }
}

