/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime;

import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod._base.serialization.SerializerMark;
import bottomtextdanny.braincell.mod._base.serialization.builtin.BuiltinSerializers;
import bottomtextdanny.braincell.mod.entity.modules.data_manager.BCDataManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.Form;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedFormManager;
import bottomtextdanny.braincell.mod.entity.modules.variable.IndexedVariableModule;
import bottomtextdanny.braincell.mod.entity.serialization.EntityData;
import bottomtextdanny.braincell.mod.entity.serialization.EntityDataReference;
import bottomtextdanny.braincell.mod.entity.serialization.RawEntityDataReference;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.AbstractSlime;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopAnimationInput;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopMovementInput;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopSoundInput;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime.MundaneSlimeBigForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime.MundaneSlimeFlowerForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime.MundaneSlimeForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime.MundaneSlimeGoldenForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime.MundaneSlimeMediumForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime.MundaneSlimeOldForm;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.mundane_slime.MundaneSlimeSpookyForm;
import bottomtextdanny.dannys_expansion.content.items.material.GelItem;
import com.google.common.collect.ImmutableList;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;

public class MundaneSlime
extends AbstractSlime {
    public static final byte GREEN = 0;
    public static final byte RED = 1;
    public static final byte BLUE = 2;
    public static final byte YELLOW = 3;
    public static final List<GelItem.Model> COLORED_GEL_MODELS = ImmutableList.of((Object)((Object)GelItem.Model.GREEN), (Object)((Object)GelItem.Model.RED), (Object)((Object)GelItem.Model.BLUE), (Object)((Object)GelItem.Model.YELLOW));
    public static final List<Integer> POOF_COLORS = ImmutableList.of((Object)-5705109, (Object)-1020820, (Object)-11154979, (Object)-2364056);
    public static final EntityDataReference<Byte> COLOR_VARIANT_REF = BCDataManager.attribute(MundaneSlime.class, (RawEntityDataReference)RawEntityDataReference.of((SerializerMark)BuiltinSerializers.BYTE, () -> (byte)0, (String)"color_variant"));
    public static final Form<MundaneSlime> MEDIUM_FORM = new MundaneSlimeMediumForm();
    public static final Form<MundaneSlime> BIG_FORM = new MundaneSlimeBigForm();
    public static final Form<MundaneSlime> GOLDEN_FORM = new MundaneSlimeGoldenForm();
    public static final Form<MundaneSlime> OLD_FORM = new MundaneSlimeOldForm();
    public static final Form<MundaneSlime> FLOWER_FORM = new MundaneSlimeFlowerForm();
    public static final Form<MundaneSlime> SPOOKY_FORM = new MundaneSlimeSpookyForm();
    public static final IndexedFormManager FORMS = IndexedFormManager.builder().add(MEDIUM_FORM).add(BIG_FORM).add(GOLDEN_FORM).add(OLD_FORM).add(FLOWER_FORM).add(SPOOKY_FORM).create();
    public static final SlimeHopMovementInput HOP_MOVEMENT = new SlimeHopMovementInput(0.5f, 0.1f, RandomIntegerMapper.of((int)35));
    public final EntityData<Byte> colorVariant;

    public MundaneSlime(EntityType<? extends MundaneSlime> type, Level worldIn) {
        super(type, worldIn);
        this.f_21364_ = 4;
        this.colorVariant = this.bcDataManager().addSyncedData(EntityData.of(COLOR_VARIANT_REF));
    }

    public static AttributeSupplier.Builder attributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, -0.4).m_22268_(Attributes.f_22281_, 2.5);
    }

    protected void commonInit() {
        super.commonInit();
        this.variableModule = new IndexedVariableModule((LivingEntity)this, FORMS);
    }

    @Override
    public float getGelAmount() {
        return 0.7f;
    }

    @Override
    public GelItem.Model getGelVariant() {
        return ((MundaneSlimeForm)this.variableModule().getForm()).gelModel(this);
    }

    @Override
    public SlimeHopSoundInput hopSoundsInput() {
        return DEFAULT_SOUND_INPUT;
    }

    @Override
    public SlimeHopAnimationInput hopAnimationInput() {
        return DEFAULT_HOP_ANIMATION_INPUT;
    }

    @Override
    public SlimeHopMovementInput hopInput() {
        return HOP_MOVEMENT;
    }

    @Override
    public boolean isSurfaceSlime() {
        return true;
    }

    public Form<?> chooseVariant() {
        int randomVal0 = this.f_19796_.nextInt(299);
        this.chooseColor();
        if (randomVal0 == 2) {
            int randomVal1 = this.f_19796_.nextInt(14);
            if (randomVal1 == 2) {
                return OLD_FORM;
            }
            return GOLDEN_FORM;
        }
        LocalDate localdate = LocalDate.now();
        int month = localdate.get(ChronoField.MONTH_OF_YEAR);
        int day = localdate.get(ChronoField.DAY_OF_MONTH);
        if (month == 5 && day == 21 && this.f_19796_.nextFloat() < 0.25f || ((Biome)this.f_19853_.m_7062_().m_204214_(this.m_142538_()).m_203334_()).getRegistryName() == Biomes.f_48179_.getRegistryName() && this.f_19796_.nextFloat() < 0.33f) {
            return FLOWER_FORM;
        }
        if (month == 10 && this.f_19796_.nextFloat() < 0.25f) {
            return SPOOKY_FORM;
        }
        if (this.f_19796_.nextFloat() < 0.12f) {
            return BIG_FORM;
        }
        return MEDIUM_FORM;
    }

    protected int m_6552_(Player murderer) {
        int experienceReward = super.m_6552_(murderer);
        if (this.variableModule().getForm() == BIG_FORM) {
            experienceReward = (int)((float)experienceReward * 2.0f);
        }
        return experienceReward;
    }

    @Override
    public int poofColor() {
        return POOF_COLORS.get(((Byte)this.colorVariant.get()).byteValue());
    }

    private void chooseColor() {
        this.colorVariant.set((Object)((byte)this.f_19796_.nextInt(4)));
    }
}

