/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.slimes.ai;

import bottomtextdanny.braincell.base.BCMath;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.AbstractSlime;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopAnimationInput;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopMovementInput;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopSoundInput;
import java.util.random.RandomGenerator;
import net.minecraft.world.entity.PathfinderMob;

public class SlimeHopAction
extends Action<AbstractSlime> {
    public static final int EFFECTS_DELAY = 5;
    private int tillHopCounter;
    private int effectsDelay = 0;
    private boolean wasJumping;

    public SlimeHopAction(AbstractSlime mob) {
        super((PathfinderMob)mob);
    }

    protected void update() {
        super.update();
        boolean canJump = ((AbstractSlime)this.mob).m_20096_() || ((AbstractSlime)this.mob).m_20069_() || ((AbstractSlime)this.mob).m_20077_();
        SlimeHopMovementInput movementData = ((AbstractSlime)this.mob).hopInput();
        SlimeHopSoundInput soundData = ((AbstractSlime)this.mob).hopSoundsInput();
        SlimeHopAnimationInput animationData = ((AbstractSlime)this.mob).hopAnimationInput();
        if (canJump && --this.tillHopCounter < 0) {
            this.tillHopCounter = movementData.hopDelay().map(UNSAFE_RANDOM);
            ((AbstractSlime)this.mob).mainHandler.play(animationData.animation());
        }
        if (((AbstractSlime)this.mob).mainHandler.getTick() >= animationData.hopLiftTick() && ((AbstractSlime)this.mob).mainHandler.getTick() < animationData.hopLiftTick() + animationData.hopTicks()) {
            float sine = BCMath.sin((float)(((AbstractSlime)this.mob).m_146908_() * ((float)Math.PI / 180)));
            float cosine = BCMath.cos((float)(((AbstractSlime)this.mob).m_146908_() * ((float)Math.PI / 180)));
            ((AbstractSlime)this.mob).m_5997_(movementData.speed() * -sine, 0.0, movementData.speed() * cosine);
            if (((AbstractSlime)this.mob).mainHandler.getTick() == animationData.hopLiftTick()) {
                ((AbstractSlime)this.mob).m_5997_(0.0, movementData.height(), 0.0);
                ((AbstractSlime)this.mob).m_5496_(soundData.hop(), 0.3f + UNSAFE_RANDOM.nextFloat() * 0.4f, soundData.pitch().map((RandomGenerator)UNSAFE_RANDOM));
            }
            if (((AbstractSlime)this.mob).mainHandler.getTick() == 5) {
                this.wasJumping = true;
            }
        }
        if (this.wasJumping && canJump) {
            if (this.effectsDelay > 0) {
                --this.effectsDelay;
            } else {
                ((AbstractSlime)this.mob).runFallEffects();
                this.wasJumping = false;
                this.effectsDelay = 5;
            }
        }
    }

    public boolean shouldKeepGoing() {
        return true;
    }
}

