/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.slimes;

import bottomtextdanny.braincell.base.ObjectFetcher;
import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.FloatMappers;
import bottomtextdanny.braincell.mixin_support.ItemEntityExtensor;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationArray;
import bottomtextdanny.braincell.mod.entity.modules.animatable.AnimationGetter;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.dannys_expansion._base.particle.DannyParticleData;
import bottomtextdanny.dannys_expansion._util.DEParticleUtil;
import bottomtextdanny.dannys_expansion._util.DEVecHelper;
import bottomtextdanny.dannys_expansion.content.entities.mob.SmartyMob;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.ai.DESlimePsyche;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopAnimationInput;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopMovementInput;
import bottomtextdanny.dannys_expansion.content.entities.mob.slimes.data.SlimeHopSoundInput;
import bottomtextdanny.dannys_expansion.content.items.material.GelItem;
import bottomtextdanny.dannys_expansion.tables.items.DEItems;
import java.util.random.RandomGenerator;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class AbstractSlime
extends SmartyMob
implements Enemy {
    private static final int FALL_FLAG = 0;
    public static final float DEFAULT_HORIZONTAL_HOP_SPEED = 0.1f;
    public static final float DEFAULT_HOP_HEIGHT = 0.7f;
    public static final int DEFAULT_ATTACK_DELAY = 40;
    public static final SimpleAnimation JUMP = new SimpleAnimation(17);
    public static final SimpleAnimation DEATH = new SimpleAnimation(10);
    public static final AnimationArray BASE_ANIMATIONS = new AnimationArray(new Animation[]{JUMP, DEATH});
    public static final SlimeHopSoundInput DEFAULT_SOUND_INPUT = new SlimeHopSoundInput(SoundEvents.f_11964_, SoundEvents.f_11964_, FloatMappers.of((float)1.0f, (float)1.21f));
    public static final SlimeHopAnimationInput DEFAULT_HOP_ANIMATION_INPUT = new SlimeHopAnimationInput((Animation<?>)JUMP, 2, 5);
    public int timeCollidedHorizontally;
    public IntScheduler.Simple attackDelay;

    protected AbstractSlime(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.m_6210_();
        this.attackDelay = IntScheduler.simple((int)40);
    }

    public AnimationGetter getAnimations() {
        return BASE_ANIMATIONS;
    }

    @Override
    public Psyche<?> makePsyche() {
        return new DESlimePsyche(this);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.m_6210_();
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }

    public void m_8119_() {
        if (this.f_19862_) {
            ++this.timeCollidedHorizontally;
        }
        super.m_8119_();
        this.f_19789_ = 0.0f;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_20069_() || this.m_20077_()) {
            this.m_5997_(0.0, 0.05, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientCallOutHandler(int flag, ObjectFetcher fetcher) {
        super.clientCallOutHandler(flag, fetcher);
        if (flag == 0) {
            Vec3 pos = this.m_20182_();
            SlimeHopSoundInput slimeHopSoundInput = this.hopSoundsInput();
            this.f_19853_.m_7785_(pos.f_82479_, pos.f_82480_, pos.f_82481_, slimeHopSoundInput.fall(), SoundSource.HOSTILE, 0.3f + this.f_19796_.nextFloat() * 0.4f, slimeHopSoundInput.pitch().map((RandomGenerator)this.f_19796_), false);
            for (int i = 0; i < 6; ++i) {
                Vec2 offset = DEVecHelper.randomOutlinePos(this.f_19796_);
                DannyParticleData data = DEParticleUtil.dust(this.litPoof(), this.poofColor(), this.f_19796_.nextFloat(0.05f, 0.12f), 0.9f, 0.97f, 0.13f);
                double xd = (double)this.m_21187_().nextFloat() * 0.03 * (double)offset.f_82470_;
                double yd = (double)this.m_21187_().nextFloat() * 0.3 + 0.1;
                double zd = (double)this.m_21187_().nextFloat() * 0.03 * (double)offset.f_82471_;
                offset = offset.m_165903_(this.m_20205_() / 2.0f);
                this.f_19853_.m_7106_((ParticleOptions)data, pos.f_82479_ + (double)offset.f_82470_, pos.f_82480_ + 0.1, pos.f_82481_ + (double)offset.f_82471_, xd, yd, zd);
            }
        }
    }

    public void onDeathAnimationEnd() {
        super.onDeathAnimationEnd();
        if (!this.f_19853_.f_46443_) {
            float f = this.getGelAmount();
            int i = (int)this.getGelAmount();
            f -= (float)i;
            float f1 = this.f_19796_.nextFloat();
            if (f1 < f) {
                ++i;
            }
            if (i != 0) {
                ItemStack gel = new ItemStack((ItemLike)DEItems.GEL.get());
                gel.m_41764_(i);
                ItemEntity itemEntity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), gel);
                ((ItemEntityExtensor)itemEntity).setShowingModel((Enum)this.getGelVariant());
                itemEntity.m_20334_(0.0, 0.5, 0.0);
                this.f_19853_.m_7967_((Entity)itemEntity);
            }
        }
    }

    public void runFallEffects() {
        this.sendClientMsg(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDeathAnimationEndClient() {
        for (int i = 0; i < 20; ++i) {
            DannyParticleData data = DEParticleUtil.cloud(this.litPoof(), 18, this.poofColor(), this.f_19796_.nextFloat(0.2f, 0.5f), 0.9f, 0.97f);
            double d0 = this.m_21187_().nextGaussian() * 0.02;
            double d1 = this.m_21187_().nextGaussian() * 0.02;
            double d2 = this.m_21187_().nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)data, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundEvents.f_11965_;
    }

    public float getGelAmount() {
        return 1.0f;
    }

    public abstract GelItem.Model getGelVariant();

    public abstract SlimeHopSoundInput hopSoundsInput();

    public abstract SlimeHopAnimationInput hopAnimationInput();

    public abstract SlimeHopMovementInput hopInput();

    public int poofColor() {
        return -1;
    }

    public boolean litPoof() {
        return false;
    }

    public boolean isSurfaceSlime() {
        return false;
    }
}

