/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion;

import bottomtextdanny.braincell.base.scheduler.IntScheduler;
import bottomtextdanny.braincell.base.value_mapper.RandomIntegerMapper;
import bottomtextdanny.braincell.mod.entity.modules.animatable.Animation;
import bottomtextdanny.braincell.mod.entity.modules.animatable.SimpleAnimation;
import bottomtextdanny.braincell.mod.entity.psyche.Action;
import bottomtextdanny.braincell.mod.entity.psyche.Psyche;
import bottomtextdanny.braincell.mod.entity.psyche.actions.AnimationAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.ConstantThoughtAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FloatAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.FollowTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.RandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.WaterAvoidingRandomStrollAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.LookForAttackTargetAction;
import bottomtextdanny.braincell.mod.entity.psyche.actions.target.TargetBullyAction;
import bottomtextdanny.braincell.mod.entity.psyche.input.UnbuiltActionInputs;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchNearestPredicates;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.SearchPredicate;
import bottomtextdanny.braincell.mod.world.helpers.CombatHelper;
import bottomtextdanny.braincell.mod.world.helpers.ReachHelper;
import bottomtextdanny.dannys_expansion.content.entities.Shared;
import bottomtextdanny.dannys_expansion.content.entities.mob.monstrous_scorpion.MonstrousScorpion;
import bottomtextdanny.dannys_expansion.tables.DEEffects;
import bottomtextdanny.dannys_expansion.tables.DESounds;
import java.util.function.ToDoubleFunction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;

public class MonstrousScorpionPsyche
extends Psyche<MonstrousScorpion> {
    public static final int MAIN_MODULE = 1;
    public static final int ANIMATION_ACTIONS_MODULE = 2;
    public static final int IDLE_ACTIONS_MODULE = 3;
    private RandomStrollAction randomStrollAction;
    private FollowTargetAction<MonstrousScorpion> followTargetAction;
    private StingAttackAction stingAttackAction;
    private ClawAttackAction clawAttackAction;

    public MonstrousScorpionPsyche(MonstrousScorpion mob) {
        super((PathfinderMob)mob);
        this.allocateModules(3);
    }

    protected void populateInputs(UnbuiltActionInputs inputs) {
    }

    protected void initialize() {
        this.followTargetAction = new LocalFollowTargetAction((MonstrousScorpion)this.getMob(), target -> (double)1.2f).setRefreshRate(10);
        this.followTargetAction.addBlockedModule(3);
        this.randomStrollAction = new WaterAvoidingRandomStrollAction(this.getMob(), Shared.LAND_STROLL, RandomIntegerMapper.of((int)120, (int)190));
        this.randomStrollAction.addModule(3);
        this.stingAttackAction = new StingAttackAction((MonstrousScorpion)this.getMob());
        this.stingAttackAction.addBlockedModule(1);
        this.clawAttackAction = new ClawAttackAction((MonstrousScorpion)this.getMob());
        this.clawAttackAction.addBlockedModule(1);
        ConstantThoughtAction globalCheck = ConstantThoughtAction.withUpdateCallback((PathfinderMob)((MonstrousScorpion)this.getMob()), mobo -> {
            if (mobo.m_5448_() != null) {
                float reach = ReachHelper.reachSqr((PathfinderMob)mobo, (Entity)mobo.m_5448_());
                if (((MonstrousScorpion)this.getMob()).mainHandler.isPlayingNull() && reach < 1.4f) {
                    if (((IntScheduler.Ranged)((MonstrousScorpion)this.getMob()).attackDelay.get()).hasEnded()) {
                        IntScheduler.Ranged clawAttackTimer = (IntScheduler.Ranged)((MonstrousScorpion)this.getMob()).clawAttackDelay.get();
                        if (clawAttackTimer.hasEnded() && reach < 0.9f) {
                            this.tryAddRunningAction(2, this.clawAttackAction);
                            clawAttackTimer.reset();
                        } else {
                            this.tryAddRunningAction(2, (Action)this.stingAttackAction);
                        }
                        ((IntScheduler.Ranged)((MonstrousScorpion)this.getMob()).attackDelay.get()).reset();
                    } else {
                        ((IntScheduler.Ranged)((MonstrousScorpion)this.getMob()).attackDelay.get()).advance();
                    }
                }
                ((IntScheduler.Ranged)((MonstrousScorpion)this.getMob()).clawAttackDelay.get()).advance();
                this.tryAddRunningAction(1, (Action)this.followTargetAction);
            } else {
                this.tryAddRunningAction(1, (Action)this.randomStrollAction);
            }
        });
        this.tryAddRunningAction(0, (Action)globalCheck);
        this.tryAddRunningAction(0, (Action)new TargetBullyAction(this.getMob(), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((MonstrousScorpion)this.getMob()), (IntScheduler)IntScheduler.simple((int)4), (MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS, (SearchPredicate)SearchNearestPredicates.nearestPlayer()));
        this.tryAddRunningAction(0, (Action)new LookForAttackTargetAction((PathfinderMob)((MonstrousScorpion)this.getMob()), (IntScheduler)IntScheduler.simple((int)12), (MobMatchPredicate)Shared.GOODIE.and((MobMatchPredicate)Shared.DEFAULT_TARGET_PARAMETERS), (SearchPredicate)SearchNearestPredicates.nearestLiving()));
        this.tryAddRunningAction(3, (Action)new FloatAction(this.getMob(), 0.3f));
    }

    public static class LocalFollowTargetAction
    extends FollowTargetAction<MonstrousScorpion> {
        public LocalFollowTargetAction(MonstrousScorpion mob, ToDoubleFunction<LivingEntity> moveSpeed) {
            super((PathfinderMob)mob, moveSpeed);
        }

        protected void start() {
            super.start();
            ((IntScheduler.Ranged)((MonstrousScorpion)this.mob).clawAttackDelay.get()).reset();
            ((IntScheduler.Ranged)((MonstrousScorpion)this.mob).attackDelay.get()).end();
        }
    }

    public static class StingAttackAction
    extends AnimationAction<MonstrousScorpion, SimpleAnimation> {
        public StingAttackAction(MonstrousScorpion mob) {
            super((PathfinderMob)mob, (Animation)MonstrousScorpion.STING, mob.mainHandler);
        }

        public void update() {
            super.update();
            LivingEntity livingEntity = ((MonstrousScorpion)this.mob).m_5448_();
            if (livingEntity != null) {
                ((MonstrousScorpion)this.mob).m_21563_().m_24960_((Entity)((MonstrousScorpion)this.mob).m_5448_(), 30.0f, 20.0f);
            }
            if (this.animationHandler.getTick() == 2) {
                ((MonstrousScorpion)this.mob).f_19853_.m_6263_(null, ((MonstrousScorpion)this.mob).m_20185_(), ((MonstrousScorpion)this.mob).m_20188_(), ((MonstrousScorpion)this.mob).m_20189_(), (SoundEvent)DESounds.ES_SWOOSH.get(), SoundSource.HOSTILE, 0.6f + 0.07f * ((MonstrousScorpion)this.mob).m_21187_().nextFloat(), 1.0f + 0.2f * ((MonstrousScorpion)this.mob).m_21187_().nextFloat());
            } else if (this.animationHandler.getTick() == 6 && livingEntity != null && livingEntity.m_6084_() && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)livingEntity) < 1.6800001f) {
                ((MonstrousScorpion)this.mob).m_5496_((SoundEvent)DESounds.ES_BLACK_SCORPION_STING.get(), 1.0f, 1.0f + ((MonstrousScorpion)this.mob).m_21187_().nextFloat() * 0.2f);
                if (CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)livingEntity, (float)1.0f)) {
                    ((MonstrousScorpion)this.mob).m_5448_().m_7292_(new MobEffectInstance((MobEffect)DEEffects.VENOM.get(), 50 * ((MonstrousScorpion)this.mob).f_19853_.m_46791_().m_19028_(), 0));
                }
            }
        }
    }

    public static class ClawAttackAction
    extends Action<MonstrousScorpion> {
        public ClawAttackAction(MonstrousScorpion mob) {
            super((PathfinderMob)mob);
        }

        public boolean canStart() {
            return this.active();
        }

        protected void start() {
            super.start();
            int rgn = ((MonstrousScorpion)this.mob).m_21187_().nextInt(3);
            ((MonstrousScorpion)this.mob).mainHandler.play((Animation)MonstrousScorpion.getClawAttackAnimations()[rgn]);
        }

        public void update() {
            super.update();
            LivingEntity livingEntity = ((MonstrousScorpion)this.mob).m_5448_();
            if (livingEntity != null) {
                ((MonstrousScorpion)this.mob).m_21563_().m_24960_((Entity)((MonstrousScorpion)this.mob).m_5448_(), 30.0f, 20.0f);
            }
            if (((MonstrousScorpion)this.mob).mainHandler.getTick() == 5) {
                ((MonstrousScorpion)this.mob).f_19853_.m_6263_(null, ((MonstrousScorpion)this.mob).m_20185_(), ((MonstrousScorpion)this.mob).m_20188_(), ((MonstrousScorpion)this.mob).m_20189_(), (SoundEvent)DESounds.ES_SWOOSH.get(), SoundSource.HOSTILE, 0.6f + 0.07f * ((MonstrousScorpion)this.mob).m_21187_().nextFloat(), 1.0f + 0.2f * ((MonstrousScorpion)this.mob).m_21187_().nextFloat());
            } else if (((MonstrousScorpion)this.mob).mainHandler.getTick() == 7 && livingEntity != null && livingEntity.m_6084_() && ReachHelper.reachSqr((PathfinderMob)this.mob, (Entity)livingEntity) < 1.08f) {
                ((MonstrousScorpion)this.mob).m_5496_((SoundEvent)DESounds.ES_MONSTROUS_SCORPION_CLAW_ATTACK.get(), 1.0f, 1.0f + ((MonstrousScorpion)this.mob).m_21187_().nextFloat() * 0.2f);
                if (CombatHelper.attackWithMultiplier((Mob)this.mob, (LivingEntity)livingEntity, (float)1.1f) && ((MonstrousScorpion)this.mob).f_19853_.m_46791_().m_19028_() != 0) {
                    ((MonstrousScorpion)this.mob).m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19597_, 40 * ((MonstrousScorpion)this.mob).f_19853_.m_46791_().m_19028_(), 0));
                }
            }
        }

        public boolean shouldKeepGoing() {
            return this.active() && ((MonstrousScorpion)this.mob).mainHandler.getAnimation().isFrom(1);
        }
    }
}

